# -*- coding: utf-8 -*-
"""
/***************************************************************************
 UNIKtimestampDialog
                                 A QGIS plugin
 UNIX timestamp
                             -------------------
        begin                : 2014-01-19
        copyright            : (C) 2014 by Bartłomiej Staroń
        email                : bartekstaron () gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""


from PyQt4.QtCore import *
from PyQt4.QtGui import *
from ui_UNIXtimestamp import Ui_ConverUNIXtimestamp
from string import maketrans
import calendar
import datetime


class UNIKtimestampDialog(QDialog):
    def __init__(self):
        QDialog.__init__(self)
        # Set up the user interface from Designer.
        self.ui = Ui_ConverUNIXtimestamp()
        self.ui.setupUi(self)
        self.ui.timestampEnter.text()
        self.ui.ConvertButton.clicked.connect(self.UNIXtimestamp)
        self.ui.pushButton.clicked.connect(self.NormalDate)
        

        
    def UNIXtimestamp(self):
        timeStam = self.ui.timestampEnter.text()
        if len(str(timeStam)) == 0 or str(timeStam).isdigit() == False:
            info = "Number required!"
        elif len(str(timeStam)) >= 11:
            info = "To many number!"
        else:
            info= str(datetime.datetime.fromtimestamp(float(timeStam)))
        QMessageBox.information( self, self.tr( "Convert timestamp" ), self.tr(str(info)) )

    def NormalDate(self):
        normaldate = (str(self.ui.dateTimeEdit.text()).translate(maketrans('- :.', ',,,,'))).split(',')
        stamp  = calendar.timegm(tuple(map(int,normaldate)))
        
        QMessageBox.information( self, self.tr( "Convert normal date" ), self.tr(str(stamp)) )
        
