#-------------------------------------------------------------------------------
# Name:        GenerateAFFont
# Purpose:     Opens the learning sheet, processes it and returns a dict to cut and paste into
#              a new AFFont class for your font
#
# Author:      Warwick Prince
#
# Created:     3/02/12 2:22 PM
# Copyright:   (c) 2012 Mushroom Systems International Pty. Ltd.
# Licence:     You are free to use this code in any way you see fit - but you must retain this license message
#-------------------------------------------------------------------------------
#!/usr/bin/env python

import xlrd
import sys
from pprint import pprint

def GenerateAFFont():
    """
    Open up the sampler sheet supplied, read in the sizes and determine the factors from there..
    """
    if len(sys.argv) != 2:
        print 'Usage: GenerateAFFont [SampleSheet.xls]'
        sys.exit()

    # Get the workbook file name from the command line
    fileName = sys.argv[1]

    if not fileName.lower().endswith('.xls'):
        fileName = '%s.xls' % fileName

    try:
        sampleBook = xlrd.open_workbook(fileName, formatting_info=True)
    except IOError:
        print 'Failed to open Excel sample sheet %s' % fileName
        sys.exit()

    if sampleBook._all_sheets_count is not 6:
        print 'Invalid Sample Workbook format - must be generated by CreateLearningSheet and contain 6 Sheets'
        sys.exit()

    # Read it in and process it
    charMapping = {}
    gutter = 190
    creepDivisor = 50.00

    # Normal UPPER
    sheet = sampleBook.sheet_by_index(0)
    letterValue = 65
    for col in range(0, 51, 2):
        width10 = (sheet.colinfo_map[col].width - gutter) / 10.00
        width100 = (sheet.colinfo_map[col+1].width - gutter) / 100.00
        creepFactor = round((width10 - width100) / creepDivisor, 4)
        letter = chr(letterValue)
        charMapping[letter] = [(round(width10, 4), creepFactor)]
        letterValue += 1

    # Normal lower
    sheet = sampleBook.sheet_by_index(1)
    letterValue = 97
    for col in range(0, 51, 2):
        width10 = (sheet.colinfo_map[col].width - gutter) / 10.00
        width100 = (sheet.colinfo_map[col+1].width - gutter) / 100.00
        creepFactor = round((width10 - width100) / creepDivisor, 4)
        letter = chr(letterValue)
        charMapping[letter] = [(round(width10, 4), creepFactor)]
        letterValue += 1

    # Normal Other
    sheet = sampleBook.sheet_by_index(2)
    letterValue = 32
    for col in range(0, 66, 2):
        width10 = (sheet.colinfo_map[col].width - gutter) / 10.00
        width100 = (sheet.colinfo_map[col+1].width - gutter) / 100.00
        creepFactor = round((width10 - width100) / creepDivisor, 4)
        letter = chr(letterValue)
        charMapping[letter] = [(round(width10, 4), creepFactor)]
        letterValue += 1

    # Bold UPPER
    sheet = sampleBook.sheet_by_index(3)
    letterValue = 65
    for col in range(0, 51, 2):
        width10 = (sheet.colinfo_map[col].width - gutter) / 10.00
        width100 = (sheet.colinfo_map[col+1].width - gutter) / 100.00
        creepFactor = round((width10 - width100) / creepDivisor, 4)
        letter = chr(letterValue)
        charMapping[letter].append((round(width10, 4), creepFactor))
        letterValue += 1

    # Normal lower
    sheet = sampleBook.sheet_by_index(4)
    letterValue = 97
    for col in range(0, 51, 2):
        width10 = (sheet.colinfo_map[col].width - gutter) / 10.00
        width100 = (sheet.colinfo_map[col+1].width - gutter) / 100.00
        creepFactor = round((width10 - width100) / creepDivisor, 4)
        letter = chr(letterValue)
        charMapping[letter].append((round(width10, 4), creepFactor))
        letterValue += 1

    # Normal Other
    sheet = sampleBook.sheet_by_index(5)
    letterValue = 32
    for col in range(0, 66, 2):
        width10 = (sheet.colinfo_map[col].width - gutter) / 10.00
        width100 = (sheet.colinfo_map[col+1].width - gutter) / 100.00
        creepFactor = round((width10 - width100) / creepDivisor, 4)
        letter = chr(letterValue)
        charMapping[letter].append((round(width10, 4), creepFactor))
        letterValue += 1

    print
    print '=' * 40
    pprint(charMapping)
    print '=' * 40
    print
    print 'CUT the ^above^ dict and paste it into your new AFFont class code where indicated'

if __name__ == '__main__':
    GenerateAFFont()
