# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MezclaValoresCapas
                                 A QGIS plugin
 Mezcla valores de capas
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-09-18
        git sha              : $Format:%H$
        copyright            : (C) 2023 by tidop
        email                : gustavo1976@usal.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import time

from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
import os.path
import pyproj

from .MezclaValores_dialog import MezclaValoresCapasDialog
from qgis.core import *
from qgis.gui import *

from PyQt5.QtCore import QVariant
import processing
import numpy as np


import math
from qgis.utils import iface
#import joblib

import tensorflow as tf
import os
from osgeo import gdal_array, gdal,osr


#Librerias para genético
from deap import base, creator, tools, algorithms
import random
import matplotlib.pyplot as plt


class MezclaValoresCapas:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'MezclaValoresCapas_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&MezclaValores')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('MezclaValoresCapas', message)

    def add_action(
            self,
            icon_path,
            text,
            callback,
            enabled_flag=True,
            add_to_menu=True,
            add_to_toolbar=True,
            status_tip=None,
            whats_this=None,
            parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/MezclaValores/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Mezcla Valores'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&MezclaValores'),
                action)
            self.iface.removeToolBarIcon(action)

    def run(self):
        """Run method that performs all the real work"""

        if self.first_start == True:
            self.first_start = False
            self.dlg = MezclaValoresCapasDialog()
            self.dlg.buttonAverage.clicked.connect(self.averageValues)
            self.dlg.buttonAlturasCarreteras.clicked.connect(self.roadsHighsBuffer)
            self.dlg.buttonSimplyRoads.clicked.connect(self.simplyRoads)
            self.dlg.buttonHot.clicked.connect(self.calculateHot)
            self.dlg.buttonCriterio.clicked.connect(self.analizarCriterios)
            self.dlg.ButtonAddSVF.clicked.connect(self.calculateSVF)

            self.dlg.buttonInterpolation.clicked.connect(self.generatImage)
            self.dlg.buttonInterpolation.clicked.connect(self.generatImage)

            self.dlg.ButtonOptimize.clicked.connect(self.optimizeUHI)


        self.cargarLayers()

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass

    '''
    Carga las capas de qgis en los combobox
    '''

    def cargarLayers(self):

        layers = [layer for layer in QgsProject.instance().mapLayers().values()]

        layer_list = [layer.name() for layer in layers]

        self.dlg.comboContru.clear()
        self.dlg.comboContru.addItems(layer_list)

        self.dlg.comboClouds.clear()
        self.dlg.comboClouds.addItems(layer_list)

        self.dlg.comboCarreteraCalor.clear()
        self.dlg.comboCarreteraCalor.addItems(layer_list)

        self.dlg.comboTemp.clear()
        self.dlg.comboTemp.addItems(layer_list)

        self.dlg.comboSimply.clear()
        self.dlg.comboSimply.addItems(layer_list)

        self.dlg.comboRoads.clear()
        self.dlg.comboRoads.addItems(layer_list)
        self.dlg.comboBuildings.clear()
        self.dlg.comboBuildings.addItems(layer_list)


        self.dlg.comboCriterio.clear()
        self.dlg.comboCriterio.addItems(layer_list)

        self.dlg.comboNdvi.clear()
        self.dlg.comboNdvi.addItems(layer_list)
        self.dlg.comboNdwi2.clear()
        self.dlg.comboNdwi2.addItems(layer_list)

        self.dlg.comboMDT.clear()
        self.dlg.comboMDT.addItems(layer_list)

        zones = ["Zone 1","Zone 2","Zone 3","Zone 4"]
        self.dlg.comboZona.clear()
        self.dlg.comboZona.addItems(zones)


        self.dlg.comboStrretOptimze.clear();
        self.dlg.comboStrretOptimze.addItems(layer_list)
        self.dlg.comboSpace.clear()
        self.dlg.comboSpace.addItems(layer_list)
        self.dlg.comboSpaceFree.clear()
        self.dlg.comboSpaceFree.addItems(layer_list)
        self.dlg.comboArea.clear()
        self.dlg.comboArea.addItems(layer_list)

        self.dlg.comboCarreteraSVF.clear()
        self.dlg.comboCarreteraSVF.addItems(layer_list)
        self.dlg.comboSVF.clear()
        self.dlg.comboSVF.addItems(layer_list)




        self.dlg.comboTempError.clear()
        self.dlg.comboTempError.addItems(layer_list)
        self.dlg.comboInterpolation.clear()
        self.dlg.comboInterpolation.addItems(layer_list)



    '''Punto 1
    Obtiene altura edificio segun la media de la nube de puntos
    La funcion coge un edificio que se ha obtenido del catastro y obtiene el valor medio de la altura según
    se intersecta el edificio con la nube de puntos, y si hay menos del 50% de puntos en la nube de puntos
    entonces no calcula la media de ese edificio'''

    def averageValues(self):
        tiempoInicio = time.time()
        layers = [layer for layer in QgsProject.instance().mapLayers().values()]
        selectedLayerIndexConstru = self.dlg.comboContru.currentIndex()
        selectedLayerIndexCloud = self.dlg.comboClouds.currentIndex()
        selectedLayerConstru = layers[selectedLayerIndexConstru]
        selectedLayerCloud = layers[selectedLayerIndexCloud]

        # Crear el proveedor de datos de la capa "cloud"
        provider = selectedLayerCloud.dataProvider()
        # Iterar a través de las características de la capa "constru" y obtener las geometrías
        valores_alturas = []

        line = "Calculando alturas... \n"
        self.dlg.textSalida.setText(line)
        # Para mostrar el texto sin que termine la funcion
        QCoreApplication.processEvents()

        # Cogemos cada uno de los valores de la capa Constru y los vamos a analizar
        for feature_constru in selectedLayerConstru.getFeatures():

            atributos = feature_constru.attributes()

            '''indice_atributoConstru = selectedLayerConstru.fields().indexFromName("CONSTRU")
            constru = (atributos[indice_atributoConstru])'''
            constru = 'I'
            # Compruebo que el campo CONSTRU sea uno de los que nos interesa, si es sotano, terraza, piscina, suelo,etc.. no nos vale
            if constru != '-I' and constru != '-II' and constru != '-III' and constru != '-I+TZA' and constru != '-II+TZA' and constru != '-III,TZA' and constru != 'PI' and constru != 'P' and constru != 'SUELO' and constru != '-I+SS' and constru != 'POR' and constru != '-I+POR':
                valores_pixeles_dentro = 0
                contador = 0
                dentro = 0
                geom_constru = feature_constru.geometry()
                rectangulo = geom_constru.boundingBox()
                # Cojo el rectangulo del objeto de la constru y compruebo todos los puntos que hay de la capa cloud dentro de esa geometria para calcular la media

                for x in np.arange(int(rectangulo.xMinimum()), int(rectangulo.xMaximum()), 2.5):
                    for y in np.arange(int(rectangulo.yMinimum()), int(rectangulo.yMaximum()), 2.5):
                        # Crear una instancia de QgsPoint para el píxel actual
                        punto_pixel = QgsPointXY(x, y)

                        # Verificar si el punto está dentro del polígono "geom_constru"
                        if geom_constru.contains(punto_pixel):
                            dentro += 1
                            ''' convierto los puntos del sistema de coordenadas 25830 al 32633 '''

                            newPoint = self.convertPoint(32633, 25830, punto_pixel)
                            # newPoint = self.convertPoint(32633, 25830, punto_pixel)
                            # Ejecutar una consulta espacial para identificar el valor del píxel
                            resultado = provider.identify(newPoint, QgsRaster.IdentifyFormatValue)

                            # Obtener el valor del píxel
                            valor_pixel = resultado.results()[1]
                            if valor_pixel is not None and valor_pixel > 0:
                                # Agregar el valor del píxel a la lista
                                valores_pixeles_dentro += valor_pixel
                                contador += 1

                # Si un 50% de los puntos de la capa cloud esta vacio entonces no calculo la media.
                if contador > (dentro * 0.5):
                    media = valores_pixeles_dentro / dentro
                    valores_alturas.append(media)
                else:
                    valores_alturas.append(0)
            else:
                valores_alturas.append(0)
        line += "\nGuardando datos.\n"
        self.dlg.textSalida.setText(line)
        QCoreApplication.processEvents()
        self.guardarDatos(valores_alturas, selectedLayerConstru, "altura")
        line += "\nAlturas terminado...."
        self.dlg.textSalida.setText(line)
        tiempoFin = time.time()
        tiempoTotal = tiempoFin - tiempoInicio
        line += "Tiempo:" + str(tiempoTotal)
        self.dlg.textSalida.setText(line)
    '''Punto 2
    Función para el boton de simplificar las carreteras que quita cuando hay varias carreteras paralelas'''

    def simplyRoads(self):
        tiempoInicio = time.time()
        line = "Simplificando Carreteras.....\n"
        self.dlg.textSalida.setText(line)
        # Para mostrar el texto sin que termine la funcion
        QCoreApplication.processEvents()

        layers = [layer for layer in QgsProject.instance().mapLayers().values()]
        selectedLayerIndexRoads = self.dlg.comboSimply.currentIndex()
        selectedLayerRoads = layers[selectedLayerIndexRoads]


        # Creo una capa para pintar quitar las carreteras service
        layerService = QgsVectorLayer("LineString?crs=EPSG:32633", "carreterasSimplificadas", "memory")
        fields_roads = selectedLayerRoads.fields()
        layerService.dataProvider().addAttributes(fields_roads)
        layerService.updateFields()
        for roads in layers[selectedLayerIndexRoads].getFeatures():
            if roads['highway'] != 'service':
                self.addFeatureRoad(roads.geometry(), roads, layerService)

        selectedLayerRoads = self.disolveRoads(layerService, line)

        # Creo una capa para pintar las carreteras simplificadas
        layer = QgsVectorLayer("LineString?crs=EPSG:32633", "carreterasSimplificadas", "memory")
        fields_roads = selectedLayerRoads.fields()
        layer.dataProvider().addAttributes(fields_roads)
        layer.updateFields()

        intersectedRoadsID = []
        idRoad = 1
        ###Quito todas las carreteras menores de 15 metros
        for roads in selectedLayerRoads.getFeatures():
            if roads.geometry().length() < 15:
                intersectedRoadsID.append(roads.id())

        for roads in selectedLayerRoads.getFeatures():
            roadsGeom = roads.geometry()
            numberRoadsDelete = 0
            # Crea un buffer alrededor de la geometría de la carretera
            # bufferGeom = roadsGeom.singleSidedBuffer(10,5,  Qgis.BufferSide.Left, Qgis.JoinStyle.JoinStyleMiter) # join_style=JOIN_STYLE.round)
            bufferGeom = roadsGeom.buffer(23, 5, Qgis.EndCapStyle.Flat, Qgis.JoinStyle.Round,
                                          0)  # join_style=JOIN_STYLE.round)
            bufferGeom = bufferGeom.buffer(-1, 5, Qgis.EndCapStyle.Flat, Qgis.JoinStyle.Round,
                                           0)  # join_style=JOIN_STYLE.round)

            # Inicializa una lista para almacenar las distancias mínimas de los edificios a la carretera
            junctionRoads = roads["junction"]
            nameOrigin = roads["name"]

            if roads.id() not in intersectedRoadsID:
                # print ("compruebo la carretera", roads.id())
                touchIds = []
                # Si lo hago sin QgsFeature entonces al modificar la geometria de newRoad se cambia la de roads porque ambas apuntarian a la misma feature en memoria
                newRoad = QgsFeature(roads)
                for road in selectedLayerRoads.getFeatures():
                    roadGeom = road.geometry()
                    nameDestiny = road["name"]
                    junction = road["junction"]

                    ###Verifica si la geometría de la carretera intersecta con la geometría de otra carreteras
                    ###si tienen el mismo nombre, si no son la misma si no se ha añadido ya como que se intersectan y si no es una rotonda
                    if (roadGeom.intersects(bufferGeom) and nameOrigin == nameDestiny and nameDestiny != None
                            and road.id() != roads.id() and road.id() not in intersectedRoadsID
                            and roads.id() not in intersectedRoadsID and junction != "roundabout" and junctionRoads != "roundabout"):
                        # compruebo si son paralelas
                        # print("compruebo con la carretera", roads.id() ," con ", road.id())
                        intersectedRoadsID, touchIds, newRoad, numberRoadsDelete = self.parallel(roads, road,
                                                                                                 intersectedRoadsID,
                                                                                                 touchIds, newRoad,
                                                                                                 layer,
                                                                                                 numberRoadsDelete)

                if len(touchIds) >= 2:
                    # print("intersecta con varias ", roads.id(), " destino", road.id())
                    if touchIds[0].geometry().length() < touchIds[1].geometry().length():
                        intersectedRoadsID.append(touchIds[0].id())
                    else:
                        intersectedRoadsID.append(touchIds[1].id())
                    numberRoadsDelete += 1
                self.addFeatureRoad(newRoad.geometry(), newRoad, layer, idRoad, numberRoadsDelete)

                idRoad += 1
                intersectedRoadsID.append(roads.id())
        #QgsProject.instance().addMapLayer(layer)
        self.cargarLayers()
        line += "Fin simplificar Carreteras.....\n"
        self.dlg.textSalida.setText(line)
        self.divideRoad(layer, line)

        tiempoFin = time.time()
        tiempoTotal = tiempoFin - tiempoInicio
        line += "Tiempo:" + str(tiempoTotal)
        self.dlg.textSalida.setText(line)

    ''' Funcion para comprobar si dos carreteras son paralelas, o se tocan, incluyendo el id de la carretera en
    intersected_roads y si se tocan en touchIds'''

    def parallel(self, roads, road, intersectedRoadsID, touchIds, newRoad, layer, numberRoadsDelete):
        roadGeom = road.geometry()
        roadsGeom = roads.geometry()
        # Calcula la distancia entre las dos geometrías
        distanceRoads = roadGeom.distance(roadsGeom)

        roadsPointsBegin = roadGeom.asPolyline()[0]
        roadsPointsEnd = roadGeom.asPolyline()[-1]
        pointGeometry = QgsGeometry.fromPointXY(roadsPointsBegin)
        distancePoint1 = pointGeometry.distance(roads.geometry())
        pointGeometry = QgsGeometry.fromPointXY(roadsPointsEnd)
        distancePoint2 = pointGeometry.distance(roads.geometry())
        distancePoints = abs(distancePoint1 - distancePoint2)

        # print (f'distancia1 {distancePoint1} distancia 2 {distancePoint2}')
        umbralDistance = 10
        angulo = 40  # self.calculateAngle(roadsGeom, roadGeom)
        delete = False
        '''Cuando la carretera es paralela pero se toca en una esquina entonces la distanceRoads es 0'''
        if (distancePoints < umbralDistance):
            # print("distancia < umbral inicial ", roads.id(), " destino", road.id())
            intersectedRoadsID.append(road.id())
            delete = True

        '''Se usa para cuando una carretera es mas pequeña que la otra o tienes varios trozos pequeños'''
        if (distancePoints > umbralDistance and distanceRoads < umbralDistance and distanceRoads > 0):  # and not roadGeom.crosses(bufferGeom))):
            # or (distancePoints > umbral_distancia and (distancePoint1<umbral_distancia or distancePoint2<umbral_distancia))):
            # print("distancia > umbral inicial ", roads.id(), " destino", road.id())
            intersectedRoadsID.append(road.id())
            delete = True
            # self.drawBox(roadGeom.boundingBox(), layer)

        '''De todas las carreteras que estan dentro del buffer me quedo con la mas larga'''
        if delete and newRoad.geometry().length() < roadGeom.length():
            newRoad = road

        if distanceRoads == 0 and not delete:
            touchIds.append(road)
        if delete:
            numberRoadsDelete += 1

        return intersectedRoadsID, touchIds, newRoad, numberRoadsDelete

    '''Copio la caretera con su geometria y caracteristicas en una nueva layer ademas le añado el campo id'''

    def addFeatureRoad(self, roadsGeom, roads, layer, id=-1, numberRoadsDelete=-1):
        caracteristiNew = QgsFeature()
        caracteristiNew.setGeometry(QgsGeometry(roadsGeom))
        caracteristiNew.setAttributes(roads.attributes())
        # caracteristiNew.setAttribute('IdRoad', id)
        if id != -1:
            if layer.dataProvider().fieldNameIndex('IdRoad') == -1:
                # Agrega un nuevo atributo "Id" a la capa
                layer.dataProvider().addAttributes([QgsField('IdRoad', QVariant.Int)])
                layer.updateFields()
            if layer.dataProvider().fieldNameIndex('NumDelete') == -1:
                # Agrega un nuevo atributo "Id" a la capa
                layer.dataProvider().addAttributes([QgsField('NumDelete', QVariant.Int)])
                layer.updateFields()

            caracteristiNew.setAttributes(caracteristiNew.attributes() + [id] + [numberRoadsDelete])
            layer.dataProvider().addFeature(caracteristiNew)
        else:
            layer.dataProvider().addFeature(caracteristiNew)

    '''Simplificamos las carreteras llamando a la funcion disolver '''

    def disolveRoads(self, selectedLayerRoads, line):
        ''' Primero simplificamos las carreteras'''
        try:
            result = processing.run("native:dissolve",
                                    {
                                        'INPUT': selectedLayerRoads,
                                        'FIELD': ['junction', 'name'], 'SEPARATE_DISJOINT': True,
                                        'OUTPUT': 'TEMPORARY_OUTPUT'})
            selectedLayerRoads = result['OUTPUT']

            #Al usar el disolve con separate disjoint true lo que hace es que una carretera larga que este en varios fragmentos la une
            #pero si son dos paralelas que se tocan en un punto entonces las une tambien con lo que despues uso
            #multiparttosingleparts para que se separen.
            result = processing.run("native:multiparttosingleparts",
                                    {'INPUT': selectedLayerRoads,
                                     'OUTPUT': 'TEMPORARY_OUTPUT'})
            selectedLayerRoads = result['OUTPUT']

        except Exception as e:
            print ('error',e)
            line += "Error en la operación de disolución:", str(e)
            self.dlg.textSalida.setText(line)
            return
        # Obtiene la capa resultante
        # QgsProject.instance().addMapLayer(selectedLayerRoads)
        #iface.mapCanvas().refresh()

        return selectedLayerRoads

    '''Divide las carreteras en porciones de 50 metros'''
    def divideRoad(self, selectedLayerRoads, line):

        line += "Dividiendo carreteras...\n"
        self.dlg.textSalida.setText(line)
        QCoreApplication.processEvents()

        result = processing.run("native:splitlinesbylength", {
            'INPUT': selectedLayerRoads,
            'LENGTH': 50, 'OUTPUT': 'memory:'})

        selectedLayerOutput = result['OUTPUT']
        output_layer_name = selectedLayerRoads.name() + '50m'
        selectedLayerOutput.setName(output_layer_name)

        # Creo una capa para eliminar las carreteras menores de 8 metros
        layer = QgsVectorLayer("LineString?crs=EPSG:32633", "carreterasSimplificadas50mborradas", "memory")
        fields_roads = selectedLayerOutput.fields()
        layer.dataProvider().addAttributes(fields_roads)
        layer.updateFields()
        newIds = []
        newId = 0
        contador = 0
        for featureRoad in selectedLayerOutput.getFeatures():
            geometryRoad = featureRoad.geometry()
            newId += 1
            newIds.append(newId)
            self.addFeatureRoad(featureRoad.geometry(), featureRoad, layer)

        self.guardarDatos(newIds, layer, "NewId")
        line += "\nFin dividir carreteras...\n"
        self.dlg.textSalida.setText(line)
        QgsProject.instance().addMapLayer(layer)
        self.cargarLayers()

    '''
        Punto 3
        Calcula la altura media y la distancia media entre la capa edificios y la capa carreteras usando un buffer,
        ademas tambien calcula la media de las capas ndvi y ndwi que caen dentro del buffer de la carretera y si hay 
        edificios a ambos lados de la carretera
        '''
    def roadsHighsBuffer(self):
        tiempoInicio = time.time()

        line = "Calculando datos carreteras...\n"
        self.dlg.textSalida.setText(line)
        QCoreApplication.processEvents()

        layers = [layer for layer in QgsProject.instance().mapLayers().values()]
        selectedLayerIndexBuildings = self.dlg.comboBuildings.currentIndex()
        selectedLayerBuildings = layers[selectedLayerIndexBuildings]

        selectedLayerIndexRoads = self.dlg.comboRoads.currentIndex()
        selectedLayerRoads = layers[selectedLayerIndexRoads]

        selectedLayerIndexNdvi = self.dlg.comboNdvi.currentIndex()
        selectedLayerNdvi = layers[selectedLayerIndexNdvi]
        providerNdvi = selectedLayerNdvi.dataProvider()


        selectedLayerIndexNdwi2= self.dlg.comboNdwi2.currentIndex()
        selectedLayerNdwi2 = layers[selectedLayerIndexNdwi2]
        providerNdwi2 = selectedLayerNdwi2.dataProvider()

        selectedLayerIndexMDT = self.dlg.comboMDT.currentIndex()
        selectedLayerMDT = layers[selectedLayerIndexMDT]
        providerMDT = selectedLayerMDT.dataProvider()

        valoresAlturasMedias = []
        valoresDistanciasMedias = []
        windCorridor = []
        # parks = []
        ndvi = []

        ndwi2 = []
        buildingBothSides = []
        roadsMDT = []
        # Crear índices espaciales
        building_index = QgsSpatialIndex(selectedLayerBuildings)
        for roads in selectedLayerRoads.getFeatures():
            '''if roads.id() % 10 :
                print("Carretera: ", roads.id())'''
            alturaMedia = 0
            cont = 0
            roads_geom = roads.geometry()
            # Define el ancho del buffer en metros dependiendo de si la carretera es residential o no
            numDelete = int(roads["NumDelete"])
            if numDelete == 0:
                anchoBuffer = 20
            else:
                anchoBuffer = 20 + 10 * numDelete

            bufferGeom = roads_geom.buffer(anchoBuffer, 5, Qgis.EndCapStyle.Flat, Qgis.JoinStyle.Round, 0)

            intersected_building_ids = []
            # Inicializa una lista para almacenar los edificios que intersectan con el bounding box
            intersected_building = building_index.intersects(bufferGeom.boundingBox())

            # Obtener el vector de dirección de la carretera
            road_start_point = roads_geom.vertexAt(0)
            road_end_point = roads_geom.vertexAt(1)
            road_vector = QgsPoint(road_end_point.x() - road_start_point.x(), road_end_point.y() - road_start_point.y())

            # Inicializar contadores para edificios en diferentes posiciones
            oneSide = 0
            otherSide = 0

            for building_id in intersected_building:

                # for building in selectedLayerBuildings.getFeatures():
                building = selectedLayerBuildings.getFeature(building_id)
                building_geom = building.geometry()
                # Como el buinding box es muy grande compruebo si intersectan el edificio con el buffer directamente
                if building_geom.intersects(bufferGeom):

                    altura = self.valueAttribute(building, selectedLayerBuildings, "altura")
                    area = self.valueAttribute(building, selectedLayerBuildings, "value")
                    # Compruebo que el campo CONSTRU sea uno de los que nos interesa, si es sotano, terraza, piscina, suelo,etc.. no nos vale
                    if float(area) > 25 and float(altura) > 0:

                        intersected_building_ids.append(building.id())
                        alturaMedia += altura
                        cont += 1
                        # Calcular el vector entre el centroide del edificio y el punto de inicio de la carretera
                        building_centroid = building.geometry().centroid().asPoint()
                        building_vector = QgsPoint(building_centroid.x() - road_start_point.x(),
                                                   building_centroid.y() - road_start_point.y())

                        # Calcular el ángulo entre el vector de la carretera y el vector del edificio
                        # para calcular a que lado/lados de la carretera hay edificios.
                        angle = math.degrees(
                            math.atan2(road_vector.x() * building_vector.y() - road_vector.y() * building_vector.x(),
                                       road_vector.x() * building_vector.x() + road_vector.y() * building_vector.y()))
                        # Determinar la posición del edificio en relación con la carretera
                        if angle > 0:
                            oneSide += 1
                        elif angle < 0:
                            otherSide += 1
            if otherSide == 0 and oneSide == 0:
                buildingBothSides.append(0)
            elif otherSide > 0 and oneSide > 0:
                buildingBothSides.append(2)
            else:
                buildingBothSides.append(1)

            if cont == 0:
                valoresAlturasMedias.append(0)
            else:
                valoresAlturasMedias.append(alturaMedia / cont)
            # Calcula la distancia minima en metros entre los edificios y la carretera
            edificios_cercanos = [selectedLayerBuildings.getFeature(id) for id in intersected_building_ids]
            distancia_media = 0

            if len(edificios_cercanos) > 0:
                distancia_media = 2 * sum(
                    [roads_geom.distance(build.geometry()) for build in edificios_cercanos]) / len(edificios_cercanos)

            valoresDistanciasMedias.append(distancia_media)

            if distancia_media > 0:
                windCorridor.append((alturaMedia / cont) / distancia_media)
            else:
                windCorridor.append(0)


            '''Calculamos la media de los valores de ndvi y ndwi que hay dentro del buffer de la carretera'''
            dentro = 0
            valoresPixelesDentroNdvi = 0
            valoresPixelesDentroNdwi2 = 0
            contadorNdvi = 0
            contadorNdwi2 = 0

            rectangulo = bufferGeom.boundingBox()
            # Cojo el rectangulo del objeto de la constru y compruebo todos los puntos que hay de la capa cloud dentro de esa geometria para calcular la media
            # pregunto si es menor que 8 porque sino no hay ningun punto dentro

            for x in range(int(rectangulo.xMinimum()), int(rectangulo.xMaximum()), 10):
                for y in range(int(rectangulo.yMinimum()), int(rectangulo.yMaximum()), 10):

                    # Crear una instancia de QgsPoint para el píxel actual
                    punto_pixel = QgsPointXY(x, y)
                    # Verificar si el punto está dentro del polígono "geom_constru"
                    if bufferGeom.contains(punto_pixel):

                        dentro += 1
                        #convierto los puntos del sistema de coordenadas 32633 al 4326
                        newPoint = self.convertPoint(32633, 4326, punto_pixel)
                        # Ejecutar una consulta espacial para identificar el valor del píxel
                        resultadoNdvi = providerNdvi.identify(newPoint, QgsRaster.IdentifyFormatValue)
                        resultadoNdwi2 = providerNdwi2.identify(newPoint, QgsRaster.IdentifyFormatValue)
                        # Obtener el valor del píxel
                        valorPixel = resultadoNdvi.results()[1]
                        if valorPixel is not None:
                            # Agregar el valor del píxel a la lista
                            valoresPixelesDentroNdvi += valorPixel
                            contadorNdvi += 1

                        valorPixel2 = resultadoNdwi2.results()[1]
                        if valorPixel2 is not None:
                            # Agregar el valor del píxel a la lista
                            valoresPixelesDentroNdwi2 += valorPixel2
                            contadorNdwi2 += 1


            #print (f'Ndvi {valoresPixelesDentroNdvi} cont {contadorNdvi} ndwi {valoresPixelesDentroNdwi} cont {contadorNdwi} longitud {roads_geom.length()}')
            points = roads_geom.asPolyline()
            if contadorNdvi == 0  or contadorNdwi2 == 0:
                pointRoad = points[0]
                pointPixel = QgsPointXY(pointRoad.x(), pointRoad.y())
                newPoint = self.convertPoint(32633, 4326, pointPixel)
                if contadorNdvi == 0:
                    resultNDVI = providerNdvi.identify(newPoint, QgsRaster.IdentifyFormatValue)
                    ndvi.append(resultNDVI.results()[1])
                else:
                    ndvi.append(valoresPixelesDentroNdvi / contadorNdvi)

                if contadorNdwi2 == 0:
                    resultNDWI2 = providerNdwi2.identify(newPoint, QgsRaster.IdentifyFormatValue)
                    ndwi2.append(resultNDWI2.results()[1])
                else:
                    ndwi2.append(valoresPixelesDentroNdwi2 / contadorNdwi2)
            else:
                ndvi.append(valoresPixelesDentroNdvi / contadorNdvi)
                ndwi2.append(valoresPixelesDentroNdwi2 / contadorNdwi2)
            # Calculo la altura media de la carretera usando la capa MDT

            sumHighs = 0
            for i in range(len(points)):
                # Calculo la altura
                pointRoad = points[i]
                pointPixel = QgsPointXY(pointRoad.x(), pointRoad.y())
                newPoint = self.convertPoint(32633, 25830, pointPixel)
                resultMDT = providerMDT.identify(newPoint, QgsRaster.IdentifyFormatValue)
                #print(f"{roads.id()} - num {i} - {resultMDT.results()[1]}")
                if resultMDT.results()[1] != None:
                    sumHighs += resultMDT.results()[1]
                else:
                    print (f"{roads.id()} Error")

            valuePixelesMDT = sumHighs / len(points)
            roadsMDT.append(valuePixelesMDT)

        self.guardarDatos(valoresAlturasMedias, selectedLayerRoads, "AlturaMedia")
        self.guardarDatos(valoresDistanciasMedias, selectedLayerRoads, "AnchuraMedia")
        self.guardarDatos(windCorridor, selectedLayerRoads, "WindCorridor")
        self.guardarDatos(roadsMDT, selectedLayerRoads, "msnm")
        self.guardarDatos(buildingBothSides, selectedLayerRoads, "EdificiosAmbosLados")

        self.guardarDatos(ndvi, selectedLayerRoads, "ndvi")
        self.guardarDatos(ndwi2, selectedLayerRoads, "ndwi_8_3")
        self.cargarLayers()
        line += "\nFin calcular datos carreteras."
        self.dlg.textSalida.setText(line)
        tiempoFin = time.time()
        tiempoTotal = tiempoFin - tiempoInicio
        line += "Tiempo:" + str(tiempoTotal)
        self.dlg.textSalida.setText(line)

        '''Devuelve el valor de un atributo que se llama name en la capa seleccionada'''

    def valueAttribute(self, feature, layerSelected, name):
        atributos = feature.attributes()
        indice_atributo = layerSelected.fields().indexFromName(name)
        constru = (atributos[indice_atributo])
        return constru

    ''' 
    Funcion para calcular las temperaturas  nocturna y las agrega
    a la capa de carretera '''

    def calculateHot(self):
        tiempoInicio = time.time()

        layers = [layer for layer in QgsProject.instance().mapLayers().values()]
        selectedLayerIndexRoad = self.dlg.comboCarreteraCalor.currentIndex()
        selectedLayerIndexTemp = self.dlg.comboTemp.currentIndex()

        selectedLayerRoad = layers[selectedLayerIndexRoad]
        selectedLayerTemp = layers[selectedLayerIndexTemp]


        # Crear el proveedor de datos de la capa "cloud"
        providerTemp = selectedLayerTemp.dataProvider()

        # Iterar a través de las características de la capa "constru" y obtener las geometrías
        TempsDay = []

        line = "Calculando temperaturas...\n"
        self.dlg.textSalida.setText(line)
        # Para mostrar el texto sin que termine la funcion
        QCoreApplication.processEvents()

        for featureBuild in selectedLayerRoad.getFeatures():
            geometry = featureBuild.geometry()

            puntoCentral = geometry.centroid().asPoint()
            #newPoint = self.convertPoint(32633, 4326, puntoCentral)

            newPoint = self.convertPoint(32633, 4326, puntoCentral)
            result = providerTemp.identify(newPoint, QgsRaster.IdentifyFormatValue)
            
            if not result.results()[1]:
                TempsDay.append(0)
            else:
                TempsDay.append(result.results()[1])

        else:
            TempsDay.append(0)

        line += "\nGuardando datos.\n"
        self.dlg.textSalida.setText(line)
        QCoreApplication.processEvents()

        self.guardarDatos(TempsDay, selectedLayerRoad, "Temperatura")
        line += "\nTerminado guardar datos.\n"
        self.dlg.textSalida.setText(line)
        tiempoFin = time.time()
        tiempoTotal = tiempoFin - tiempoInicio
        line += "Tiempo:" + str(tiempoTotal)
        self.dlg.textSalida.setText(line)

    ''' Punto SVF
            Funcion para calcular el SVF de las carreteras'''

    def calculateSVF(self):
        tiempoInicio = time.time()

        layers = [layer for layer in QgsProject.instance().mapLayers().values()]
        selectedLayerIndexRoad = self.dlg.comboCarreteraSVF.currentIndex()
        selectedLayerIndexSVF = self.dlg.comboSVF.currentIndex()

        selectedLayerRoad = layers[selectedLayerIndexRoad]
        selectedLayerSVF = layers[selectedLayerIndexSVF]

        # Crear el proveedor de datos de la capa "svf"
        providerSVF = selectedLayerSVF.dataProvider()

        SVF = []

        line = "Calculando SVF...\n"
        self.dlg.textSalida.setText(line)
        # Para mostrar el texto sin que termine la funcion
        QCoreApplication.processEvents()

        for roads in selectedLayerRoad.getFeatures():
            geometry = roads.geometry()
            if geometry.type() == QgsWkbTypes.LineGeometry:
                if geometry.isMultipart():
                    multi_line_points = geometry.asMultiPolyline()  # Maneja geometrías multipart
                    points = []
                    for line_points in multi_line_points:
                        points.extend(line_points)
                else:
                    points = geometry.asPolyline()  # Maneja líneas simples

            sumSVF = 0
            valid_points_count = 0
            # for i in range(len(points)):
            for pointRoad in points:
                # pointRoad = points[i]
                pointPixel = QgsPointXY(pointRoad.x(), pointRoad.y())
                resultSVF = providerSVF.identify(pointPixel, QgsRaster.IdentifyFormatValue)
                # if resultSVF.isValid() and 1 in resultSVF.results():
                if resultSVF.results()[1] != None:
                    sumSVF += resultSVF.results()[1]
                    valid_points_count += 1
                else:
                    print(f"{roads.id()} Error")
            if valid_points_count > 0:
                valuePixelesSVF = sumSVF / valid_points_count
            else:
                valuePixelesSVF = -1
            SVF.append(valuePixelesSVF)


        line += "\nGuardando datos.\n"
        self.dlg.textSalida.setText(line)
        QCoreApplication.processEvents()

        self.guardarDatos(SVF, selectedLayerRoad, "SVF")
        # self.guardarDatos(SVF2, selectedLayerRoad, "SVF2")
        line += "\nTerminado guardar datos.\n"
        self.dlg.textSalida.setText(line)
        tiempoFin = time.time()
        tiempoTotal = tiempoFin - tiempoInicio
        line += "Tiempo:" + str(tiempoTotal)
        self.dlg.textSalida.setText(line)


    '''Punto 4
    Analizamos los criterios con algoritmos de multicriterio'''

    def analizarCriterios(self):
        tiempoInicio = time.time()

        line = "Iniciando analisis multicriterio..."
        self.dlg.textSalida.setText(line)
        QCoreApplication.processEvents()

        layers = [layer for layer in QgsProject.instance().mapLayers().values()]
        layerCritery = self.dlg.comboCriterio.currentIndex()
        selectedLayerCritery = layers[layerCritery]


        # para hacerlo con formulas lineales
        ndvi = [feature['ndvi'] for feature in selectedLayerCritery.getFeatures()]
        ndwi = [feature['ndwi_8_3'] for feature in selectedLayerCritery.getFeatures()]
        msnm = [feature['msnm'] for feature in selectedLayerCritery.getFeatures()]
        windCorridor = [feature['WindCorridor'] for feature in selectedLayerCritery.getFeatures()]
        svf = [feature['SVF'] for feature in selectedLayerCritery.getFeatures()]

        #El orden de los valores es:WindCorridor, Msnm, ndvi, ndwi, svf
        maxMin=[[[220,0],[1196,-2.34],[0.951,-0.071],[0.77,-0.876],[1,0.0241]],
                [[2736,0],[1085,0.283],[0.981,-0.0347],[0.559,-0.887],[1,0.116]],
                [[54.2,0],[694,0],[0.762,-0.0768],[0.697,-0.678],[1,0.0958]],
                [[80.9,0],[496,-1.81],[0.806,-0.546],[0.73,-0.0467],[1,0.093]]
                ]
        if self.dlg.comboZona.currentText() == 'Zone 1':
            maxMinZona=maxMin[0]
        elif self.dlg.comboZona.currentText() == 'Zone 2':
            maxMinZona=maxMin[1]
        elif self.dlg.comboZona.currentText() == 'Zone 3':
            maxMinZona=maxMin[2]
        else:
            maxMinZona = maxMin[3]

        windCorridorNormalized = self.normalize(windCorridor, maxMinZona[0][0], maxMinZona[0][1])
        msnmNormalized = self.normalize(msnm, maxMinZona[1][0], maxMinZona[1][1])
        ndviNormalized = self.normalize(ndvi, maxMinZona[2][0], maxMinZona[2][1])
        ndwiNormalized = self.normalize(ndwi, maxMinZona[3][0], maxMinZona[3][1])
        svfNormalized = self.normalize(svf, maxMinZona[4][0], maxMinZona[4][1])
        #Calculamos la nueva temperatura con la formula
        tempe1=[]
        tempe2=[]
        tempe3=[]
        tempe4=[]

        for i in range(len(ndvi)):
            if self.dlg.comboZona.currentText() == 'Zone 1':
                tempe1.append(19.72089 +  6.979067 *math.log(windCorridorNormalized[i] + 1) + 1.685469 * msnmNormalized[i] -3.598717 *ndviNormalized[i] -0.09370701 *ndwiNormalized[i] -0.6557551 *svfNormalized[i])                
            elif self.dlg.comboZona.currentText() == 'Zone 2':
                tempe2.append(25.38068   -2.837283 *math.log(windCorridorNormalized[i] + 1)  -3.487627 * msnmNormalized[i] -1.598327 *ndviNormalized[i] + 0.8332107 *ndwiNormalized[i] -1.318258 *svfNormalized[i])
            elif self.dlg.comboZona.currentText() == 'Zone 3':
                tempe3.append(26.64391  + 5.410117 * math.log(windCorridorNormalized[i] + 1)  -1.291481 * msnmNormalized[i] - 0.1594801 * ndviNormalized[i] + 0.1367494 * ndwiNormalized[i] -1.343117 * svfNormalized[i])
            else:
                tempe4.append(25.77171 + 3.370697 * math.log(windCorridorNormalized[i] + 1)  -1.174922 * msnmNormalized[i] + 2.089366 * ndviNormalized[i] + 0.6940802 *  ndwiNormalized[i] - 0.8269008 *svfNormalized[i])
        if self.dlg.comboZona.currentText() == 'Zone 1':
            self.guardarDatos(tempe1, selectedLayerCritery, "tempeZona1")
        elif self.dlg.comboZona.currentText() == 'Zone 2':
            self.guardarDatos(tempe2, selectedLayerCritery, "tempeZona2")
        elif self.dlg.comboZona.currentText() == 'Zone 3':
            self.guardarDatos(tempe3, selectedLayerCritery, "tempeZona3")
        else:
            self.guardarDatos(tempe4, selectedLayerCritery, "tempeZona4")


        line += "\nFin analisis multicriterio..."
        self.dlg.textSalida.setText(line)
        tiempoFin = time.time()
        tiempoTotal = tiempoFin - tiempoInicio
        line += "Tiempo:" + str(tiempoTotal)
        self.dlg.textSalida.setText(line)


    '''Punto 5
        Generar una imagen con los errores de la imagen de temperatura con la imagen interpolada de carreteras'''
    def generatImage(self):
        tiempoInicio = time.time()

        line = "Iniciando generacion imagen..."
        self.dlg.textSalida.setText(line)
        QCoreApplication.processEvents()

        layers = [layer for layer in QgsProject.instance().mapLayers().values()]
        layerTempIndex = self.dlg.comboTempError.currentIndex()
        selectedLayerTemp  = layers[layerTempIndex]
        layerInterpolationIndex = self.dlg.comboInterpolation.currentIndex()
        selectedLayerInterpolation  = layers[layerInterpolationIndex]

        # Abrir el archivo como un objeto Dataset
        temp_dataset = gdal.Open(selectedLayerTemp.dataProvider().dataSourceUri())
        temp_data = gdal_array.DatasetReadAsArray(temp_dataset)


        interpolation_dataset = gdal.Open(selectedLayerInterpolation.dataProvider().dataSourceUri())
        interpolation_data = gdal_array.DatasetReadAsArray(interpolation_dataset)

        # Obtener la información de transformación geográfica de cada capa
        temp_geotransform = temp_dataset.GetGeoTransform()
        interpolation_geotransform = interpolation_dataset.GetGeoTransform()
        temp_file_path = selectedLayerTemp.dataProvider().dataSourceUri()

        cols = interpolation_data.shape[1]
        rows = interpolation_data.shape[0]
        differenciaArray = np.zeros((rows, cols), dtype=np.float32)
        originalArray =  np.zeros((rows, cols), dtype=np.float32)
        interpoladoArray =  np.zeros((rows, cols), dtype=np.float32)
        # Crear una nueva capa para almacenar la diferencia absoluta

        # Recorrer cada punto de la capa de interpolación
        for i in range(cols):
            for j in range(rows):
                # Obtener las coordenadas geográficas del punto actual
                x = interpolation_geotransform[0] + i * interpolation_geotransform[1] + j * interpolation_geotransform[
                    2]
                y = interpolation_geotransform[3] + i * interpolation_geotransform[4] + j * interpolation_geotransform[
                    5]

                # Convertir las coordenadas geográficas a coordenadas de píxel en la capa layerTempIndex
                temp_x = int((x - temp_geotransform[0]) / temp_geotransform[1])
                temp_y = int((y - temp_geotransform[3]) / temp_geotransform[5])
                # Verificar si el punto está dentro de los límites de la capa layerTempIndex
                if 0 <= temp_x < temp_data.shape[1] and 0 <= temp_y < temp_data.shape[0]:
                    # Calcular la diferencia absoluta entre los valores de los puntos
                    dif = np.abs(interpolation_data[j, i] - temp_data[temp_y, temp_x])
                    originalArray[j, i] = temp_data[temp_y, temp_x]
                    interpoladoArray[j, i] = interpolation_data[j, i]
                    if dif > 10 or originalArray[j, i] == 0:
                        dif = 0
                    differenciaArray[j, i] = dif


        temp_layer_uri = selectedLayerTemp.dataProvider().dataSourceUri()
        temp_layer_directory = os.path.dirname(temp_layer_uri)
        #print(temp_layer_directory)
        output_path = temp_layer_directory+"/output_difference.tif"
        driver = gdal.GetDriverByName("GTiff")
        out_raster = driver.Create(output_path, cols, rows, 1, gdal.GDT_Float32)
        geotransform = interpolation_dataset.GetGeoTransform()
        out_raster.SetGeoTransform(geotransform)

        # Configurar el sistema de coordenadas (EPSG:32633)
        spatial_ref = osr.SpatialReference()
        spatial_ref.ImportFromEPSG(4326)  # Definir EPSG:32633
        out_raster.SetProjection(spatial_ref.ExportToWkt())

        out_band = out_raster.GetRasterBand(1)
        out_band.WriteArray(differenciaArray)
        # Mostrar los resultados
        line += "\nImagen generada con éxito\n"
        self.dlg.textSalida.setText(line)
        QCoreApplication.processEvents()


        #Calculamos los errores
        differenceArray = np.array(interpoladoArray)
        originalArray = np.array(originalArray)
        print("Dimensiones de original_array:", originalArray.shape)
        print("Dimensiones de difference_array:", differenceArray.shape)
        # Filtrar los valores válidos (donde los datos no son 0 ni faltantes)
        valid_mask = (originalArray > 0) & (differenceArray > 0) & ~np.isnan(originalArray) & ~np.isnan(
            differenceArray)
        print("Dimensiones de valid_mask:", valid_mask.shape)
        # Filtrar los valores válidos
        validDifference = differenceArray[valid_mask]
        validOriginal = originalArray[valid_mask]
        # Calcular RMSE (Root Mean Squared Error)
        rmse = np.sqrt(np.mean((validDifference - validOriginal) ** 2))

        # Calcular MAE (Mean Absolute Error)
        mae = np.mean(np.abs(validDifference - validOriginal))

        # Calcular MAPE (Mean Absolute Percentage Error) y manejar división por cero
        mape = np.mean(np.abs((validDifference - validOriginal) / validOriginal)) * 100

        # Imprimir los resultados
        line +=f"RMSE: {rmse} "
        line +=f"MAE: {mae} "
        line +=f"MAPE: {mape:.2f}% "
        line +=f"max original: {np.max(validOriginal)} min: {np.min(validOriginal)} "
        line +=f"max diferencia: {np.max(validDifference)} min: {np.min(validDifference)} "
        line += "Fin calculos"
        self.dlg.textSalida.setText(line)
        QCoreApplication.processEvents()
        return


    '''Funciones Genericas'''

    def normalize(self, values, maxValue, minValue):

        valores_normalizados = [(value - minValue) / (maxValue - minValue) for  value in values]
        return valores_normalizados

    def tipificar(self, data, capa):
        values = [feature[data] for feature in capa.getFeatures()]

        media = np.mean(values)
        desviacion = np.std(values)
        valores = [(value - media) / (desviacion) for  value in values]
        return valores


    '''Convierto un punto de un sistema de coordenadas a otro sistema diferente'''

    def convertPoint(self, source, destiny, point):
        # Obtén el proyecto actual para acceder a las transformaciones de coordenadas.
        project = QgsProject.instance()
        # Define las referencias de los sistemas de coordenadas de origen y destino.
        source_crs = QgsCoordinateReferenceSystem(source)
        target_crs = QgsCoordinateReferenceSystem(destiny)
        # Crea una transformación de coordenadas.
        transform = QgsCoordinateTransform(source_crs, target_crs, project)
        # Aplica la transformación al punto.
        pointNew = transform.transform(point)
        x = pointNew[0]
        y = pointNew[1]
        puntoXY = QgsPointXY(x, y)
        return puntoXY

    '''Guarda los valores en la tabla de atributos de la capa seleccionada en una nueva columna, 
        si existe la columna no la crea'''

    def guardarDatos(self, valores, selectedLayer, newColumnName):
        # Ahora, agregamos los valores de píxeles a una nueva columna en la capa "constru"
        # Obtener la lista de campos existentes en la capa
        existing_fields = selectedLayer.fields()

        # Verificar si la columna ya existe
        column_exists = any(field.name() == newColumnName for field in existing_fields)

        # Si la columna no existe, agrégala
        if not column_exists:
            tipo_columna = QVariant.Double
            nueva_columna = QgsField(newColumnName, tipo_columna)
            selectedLayer.dataProvider().addAttributes([nueva_columna])
            selectedLayer.updateFields()
        selectedLayer.startEditing()
        for index, feature in enumerate(selectedLayer.getFeatures()):
            feature[newColumnName] =float(valores[index])
            selectedLayer.updateFeature(feature)

        selectedLayer.commitChanges()
    def guardarDatosCadena(self, valores, selectedLayer, newColumnName):
        # Ahora, agregamos los valores de píxeles a una nueva columna en la capa "constru"
        # Obtener la lista de campos existentes en la capa
        existing_fields = selectedLayer.fields()

        # Verificar si la columna ya existe
        column_exists = any(field.name() == newColumnName for field in existing_fields)

        # Si la columna no existe, agrégala
        if not column_exists:
            tipo_columna = QVariant.String
            nueva_columna = QgsField(newColumnName, tipo_columna)
            selectedLayer.dataProvider().addAttributes([nueva_columna])
            selectedLayer.updateFields()
        selectedLayer.startEditing()
        for index, feature in enumerate(selectedLayer.getFeatures()):
            feature[newColumnName] =valores[index]
            selectedLayer.updateFeature(feature)

        selectedLayer.commitChanges()


#################################################################################
## MEDIDAS MITIGADORAS
#################################################################################    
    def ParametrosMediosArea(self, model,windCorridorNormalized,msnmNormalized,ndviNormalized,ndwiNormalized,svfNormalized):


        
        windCorridor_mean=np.mean(windCorridorNormalized)
        msnm_mean=np.mean(msnmNormalized)
        ndvi_mean=np.mean(ndviNormalized)
        ndwi_mean=np.mean(ndwiNormalized)
        sfv_mean=np.mean(svfNormalized)
        
        X_mean = [[windCorridor_mean,msnm_mean,ndvi_mean,ndwi_mean,sfv_mean]]
        X_mean_array = np.array(X_mean, dtype=np.float32)
        
        Temp_mean = model.predict(X_mean_array, verbose=0)

        return X_mean,Temp_mean
    
    def Mitigadoras(self, model,op,X_mean,Temp_mean,deltaT,AreaTotal):
         
        ndvi_soil=0.1 #word Susa ¿METER VIA PLUGIN PARA QUE SEA MODIFICABLE POR EL USUARIO?
        ndvi_green=0.6 #word Susa ¿METER VIA PLUGIN PARA QUE SEA MODIFICABLE POR EL USUARIO?
        
        ndwi_water=0.7 #word Susa ¿METER VIA PLUGIN PARA QUE SEA MODIFICABLE POR EL USUARIO?
        ndwi_soil=0.2 #word Susa ¿METER VIA PLUGIN PARA QUE SEA MODIFICABLE POR EL USUARIO?
         # Declaro las variables dentro de Xmean para tener los nombres
        windCorridor=X_mean[0][0]
        msnm=X_mean[0][1]
        ndvi=X_mean[0][2]
        ndwi=X_mean[0][3]
        svf=X_mean[0][4]
         
#        op: define la opción de mitigadoras, viene marcado por el boton de radio seleccionado
#        ndvi: es el ndvi medio original del area total de la IHU donde aplicar mitigadoras
#        ndwi: es el ndvi medio original del area total de la IHU donde aplicar mitigadoras
#        mwnm: es el mwnm medio original del area total de la IHU donde aplicar mitigadoras
#        windCorridor:es el windCorridor medio original del area total de la IHU donde aplicar mitigadoras
#        svf:es el svf medio original del area total de la IHU donde aplicar mitigadoras
#        Temp_mean: es la T media original del area total de la IHU donde aplicar mitigadoras
#        deltaT= es el incremento de temperatura que se quiere conseguir
        
#        NOTA: todos los valores que entran a esta función vienen normalizados
      
        # parametro que define la precision. Por ejemplo, si es 10 el ndvi se va probando de 0.1 en 0.1
        #defino el modelo IA
        
#        ruta_script = os.path.dirname(os.path.realpath(__file__))
#        ruta_modelo = os.path.join(ruta_script, nombre_modelo)
#        model = tf.keras.models.load_model(ruta_modelo)
        
        TempReduction=(deltaT/100)*Temp_mean
        print("ndvi medio",ndvi)
        if op==1: #MEDIDA MITIGADORA SOLO CESPED
            NumIteraciones = 50
            ndvi_j=0# Lsita que va a ir guardando todos los ndvi probados. j=ndvi

            ndviObj=[] #Lista que guarda todos los ndvi que cumplen con el deltaT objetivo
            print('Temperatura media ',Temp_mean)
            for i in range (0,NumIteraciones):
                                
                X_new = [[windCorridor, msnm, ndvi_j,ndwi,svf]]
                X_new_array = np.array(X_new, dtype=np.float32)
                
                T_new = model.predict(X_new_array, verbose=0)
                #T_new = 26.64391 + 5.410117 * math.log(windCorridor + 1) - 1.291481 * msnm - 0.1594801 * ndvi + 0.1367494 * ndwi - 1.343117 * svf
                if (Temp_mean-T_new)>TempReduction:
                    ndviObj.append(ndvi_j)

                ndvi_j=ndvi_j+((1.0-ndvi)/NumIteraciones) #el ndvi va de 0 a 1
            
            if len(ndviObj)==0:
                MensajeConsola='No se puede alcanzar la reducción de temperatura '+str(deltaT)+' %'
                MitigationSurface=0
                deltaTReal=0
                T_Real=Temp_mean
                
            else:
                
                ndvi_final=min(ndviObj)
                
                GreenPorcentageNew=(ndvi_final-ndvi_soil)/(ndvi_green-ndvi_soil)
                GreenPorcentageActual=(ndvi-ndvi_soil)/(ndvi_green-ndvi_soil)
                
                deltaGreenPorcentage=GreenPorcentageNew-GreenPorcentageActual
                print("GreenPorcentage", GreenPorcentageNew)
                print("ndvi_final", ndvi_final)

                MitigationSurface=deltaGreenPorcentage*AreaTotal
                MensajeConsola= 'Para alcanzar la reducción de temperatura objetivo de '+str(deltaT)+' se requiere un area de cesped nueva de '+str(MitigationSurface)+' m2'
                
                
                X_Real = [[windCorridor, msnm, ndvi_final,ndwi,svf]]
                X_Real_array = np.array(X_Real, dtype=np.float32)
                T_Real = model.predict(X_Real_array, verbose=0)
                #T_Real = 26.64391 + 5.410117 * math.log(windCorridor + 1) - 1.291481 * msnm - 0.1594801 * ndvi_final + 0.1367494 * ndwi - 1.343117 * sfv
                deltaTReal=Temp_mean-T_Real
       
        elif op==2: #MEDIDA MITIGADORA SOLO AGUA
            NumIteraciones = 50
            ndwi_j=0

            ndwiObj=[] #Lista que guarda todos los ndvi que cumplen con el deltaT objetivo
            print('Temperatura media ',Temp_mean)
           
            for i in range (0,NumIteraciones):
                                
                X_new = [[windCorridor, msnm, ndvi,ndwi_j,svf]]
                X_new_array = np.array(X_new, dtype=np.float32)
                
                T_new = model.predict(X_new_array, verbose=0)
                #T_new = 26.64391 + 5.410117 * math.log(windCorridor + 1) - 1.291481 * msnm - 0.1594801 * ndvi + 0.1367494 * ndwi - 1.343117 * svf
                if (Temp_mean-T_new)>TempReduction:
                    ndwiObj.append(ndwi_j)

                ndwi_j=ndwi_j+((1.0- 0)/NumIteraciones) #el ndvi va de 0 a 1
            
            if len(ndwiObj)==0:
                MensajeConsola='No se puede alcanzar la reducción de temperatura '+str(deltaT)+' %'
                MitigationSurface=0
                deltaTReal=0
                T_Real=Temp_mean
                
            else:
                
                ndwi_final=min(ndwiObj)
                
                WaterPorcentageNew=(ndwi_final-ndwi_soil)/(ndwi_water-ndwi_soil)
                WaterPorcentageActual=(ndwi-ndwi_soil)/(ndvi_green-ndwi_soil)
                
                deltaWaterPorcentage=WaterPorcentageNew-WaterPorcentageActual
                print("GreenPorcentage", WaterPorcentageNew)
                print("ndvi_final", ndwi_final)
                if (deltaWaterPorcentage<0):
                    MitigationSurface=0
                else:
                    MitigationSurface=deltaWaterPorcentage*AreaTotal
                MensajeConsola= 'Para alcanzar la reducción de temperatura objetivo de '+str(deltaT)+' se requiere un area de agua nueva de '+str(MitigationSurface)+' m2'
                
                X_Real = [[windCorridor, msnm, ndvi,ndwi_final,svf]]
                X_Real_array = np.array(X_Real, dtype=np.float32)
                T_Real = model.predict(X_Real_array, verbose=0)
                #T_Real = 26.64391 + 5.410117 * math.log(windCorridor + 1) - 1.291481 * msnm - 0.1594801 * ndvi_final + 0.1367494 * ndwi - 1.343117 * sfv
                deltaTReal=Temp_mean-T_Real
        
        else: #MEDIDA COMBINADA

            NumIteraciones = 10
            ndvi_j= ndvi # parimos de cero porque no sabemos asegurar la tendencia con la temperatura

            Obj=[] #Lista que guarda todos los ndvi que cumplen con el deltaT objetivo
            print('Temperatura media ',Temp_mean)
           
            for i in range (0,NumIteraciones): #Vegetacion
                    ndwi_j=0
                    for j in range(0,NumIteraciones): #Agua
                    
                                    
                        X_new = [[windCorridor, msnm, ndvi_j,ndwi_j,svf]]
                        X_new_array = np.array(X_new, dtype=np.float32)
                        
                        T_new = model.predict(X_new_array, verbose=0)
                        #T_new = 26.64391 + 5.410117 * math.log(windCorridor + 1) - 1.291481 * msnm - 0.1594801 * ndvi + 0.1367494 * ndwi - 1.343117 * svf
                        if (Temp_mean-T_new)>TempReduction:

                            Obj.append([ndvi_j,ndwi_j])
        
                        ndwi_j=ndwi_j+((1.0- 0)/NumIteraciones) #el ndvi va de 0 a 1
                    
                    ndvi_j=ndvi_j+((1.0- ndvi)/NumIteraciones)
                
            if len(Obj)==0:
                MensajeConsola='No se puede alcanzar la reducción de temperatura '+str(deltaT)+' %'
                MitigationSurface=0
                deltaTReal=0
                T_Real=Temp_mean
                
            else:
                #lo que hace es de todas las combinaciones posibles cual es la combinacion que baja mas la tempereratura
                T_mejor=1000
                for i in range(0,len(Obj)):
                    
                    X = [[windCorridor, msnm, Obj[i][0],Obj[i][1],svf]]
                    
                    X_array = np.array(X, dtype=np.float32)
                    
                    T = model.predict(X_array, verbose=0)
                    
                    if T<T_mejor:
                        
                        T_mejor=T
                        
                        ndvi_final=Obj[i][0]
                        ndwi_final=Obj[i][1]
                
                GreenPorcentageNew=(ndvi_final-ndvi_soil)/(ndvi_green-ndvi_soil)
                GreenPorcentageActual=(ndvi-ndvi_soil)/(ndvi_green-ndvi_soil)
                
                WaterPorcentageNew=(ndwi_final-ndwi_soil)/(ndwi_water-ndvi_soil)
                WaterPorcentageActual=(ndwi-ndwi_soil)/(ndwi_water-ndwi_soil)
                
                
                # !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!METER AQUI CESPED Y COMBINADO
                deltaWaterPorcentage=WaterPorcentageNew-WaterPorcentageActual
                deltaGreenPorcentage=GreenPorcentageNew-GreenPorcentageActual
                
                print("WaterPorcentage", WaterPorcentageNew)
                print("ndwi_final", ndwi_final)
                print("GreenPorcentage", GreenPorcentageNew)
                print("ndvi_final", ndvi_final)
                if (deltaWaterPorcentage>0):
                    MitigationSurface = (deltaGreenPorcentage*AreaTotal,deltaWaterPorcentage*AreaTotal)
                else:
                    MitigationSurface = (deltaGreenPorcentage * AreaTotal)
                MensajeConsola= 'Para alcanzar la reducción de temperatura objetivo de '+str(deltaT)+' se requiere un area de agua nueva de '+str(MitigationSurface)+' m2'
                
                X_Real = [[windCorridor, msnm, ndvi,ndwi_final,svf]]
                X_Real_array = np.array(X_Real, dtype=np.float32)
                T_Real = model.predict(X_Real_array, verbose=0)
                #T_Real = 26.64391 + 5.410117 * math.log(windCorridor + 1) - 1.291481 * msnm - 0.1594801 * ndvi_final + 0.1367494 * ndwi - 1.343117 * sfv
                deltaTReal=Temp_mean-T_Real
            
        
        return MitigationSurface,MensajeConsola,deltaTReal, T_Real
    
    def optimizeUHI(self):
        tiempoInicio = time.time()
        
        ndvi_soil=0.1 #word Susa ¿METER VIA PLUGIN PARA QUE SEA MODIFICABLE POR EL USUARIO?
        ndvi_green=0.6 #word Susa ¿METER VIA PLUGIN PARA QUE SEA MODIFICABLE POR EL USUARIO?
        
        ndwi_water=0.7 #word Susa ¿METER VIA PLUGIN PARA QUE SEA MODIFICABLE POR EL USUARIO?
        ndwi_suelo=0.2 #word Susa ¿METER VIA PLUGIN PARA QUE SEA MODIFICABLE POR EL USUARIO?
        
        GreenCost=6.0005 # [€/m2] word Susa ¿METER VIA PLUGIN PARA QUE SEA MODIFICABLE POR EL USUARIO?
        WaterCost=50 # [€/m2] word Susa ¿METER VIA PLUGIN PARA QUE SEA MODIFICABLE POR EL USUARIO?
        
        line = "Iniciando optimizacion..."
        self.dlg.textSalida.setText(line)
        QCoreApplication.processEvents()

        layers = [layer for layer in QgsProject.instance().mapLayers().values()]
        layerCritery = self.dlg.comboStrretOptimze.currentIndex()
        selectedLayerCritery = layers[layerCritery]
        areaCritery = self.dlg.comboArea.currentIndex()
        selectedArea = layers[areaCritery]
        spaceCritery = self.dlg.comboSpace.currentIndex()
        selectedSpace = layers[spaceCritery]
        spaceCriteryFree = self.dlg.comboSpaceFree.currentIndex()
        selectedSpaceFree = layers[spaceCriteryFree]
        # Obtener la primera entidad de la capa
                # Obtener la primera entidad de la capa
        total_area = 0
        for feature in selectedArea.getFeatures():
            total_area += feature.geometry().area()

        total_area_space = 0
        for feature in selectedSpace.getFeatures():
            total_area_space += feature.geometry().area()
        print("Area total:", total_area, " Area critery:", total_area_space)

        ndvi = [feature['ndvi'] for feature in selectedLayerCritery.getFeatures()]
        ndwi = [feature['ndwi_8_3'] for feature in selectedLayerCritery.getFeatures()]
        msnm = [feature['msnm'] for feature in selectedLayerCritery.getFeatures()]
        windCorridor = [feature['WindCorridor'] for feature in selectedLayerCritery.getFeatures()]
        svf = [feature['SVF'] for feature in selectedLayerCritery.getFeatures()]
        # distanciaOcenaos = [feature['DistanciasOceanos'] for feature in selectedLayerCritery.getFeatures()]

        # El orden de los valores es:WindCorridor, Msnm, ndvi, ndwi, svf
        maxMin = [[[220, 0], [1196, -2.34], [0.951, -0.071], [0.77, -0.876], [1, 0.0241]],
                  [[2736, 0], [1085, 0.283], [0.981, -0.0347], [0.559, -0.887], [1, 0.116]],
                  [[54.2, 0], [694, 0], [0.762, -0.0768], [0.697, -0.678], [1, 0.0958]],
                  [[80.9, 0], [496, -1.81], [0.806, -0.546], [0.73, -0.0467], [1, 0.093]]
                  ]
        if self.dlg.comboZona.currentText() == 'Zone 1':
            maxMinZona = maxMin[0]
            nombre_modelo = 'nuevo_modelo_zona1.keras'
        elif self.dlg.comboZona.currentText() == 'Zone 2':
            maxMinZona = maxMin[1]
            nombre_modelo = 'nuevo_modelo_zona2.keras'
        elif self.dlg.comboZona.currentText() == 'Zone 3':
            maxMinZona = maxMin[2]
            nombre_modelo = 'nuevo_modelo_zona3.keras'
        else:
            maxMinZona = maxMin[3]
            nombre_modelo = 'nuevo_modelo_zona4.keras'

        windCorridorNormalized = self.normalize(windCorridor, maxMinZona[0][0], maxMinZona[0][1])
        msnmNormalized = self.normalize(msnm, maxMinZona[1][0], maxMinZona[1][1])
        ndviNormalized = self.normalize(ndvi, maxMinZona[2][0], maxMinZona[2][1])
        ndwiNormalized = self.normalize(ndwi, maxMinZona[3][0], maxMinZona[3][1])
        svfNormalized = self.normalize(svf, maxMinZona[4][0], maxMinZona[4][1])

        ruta_script = os.path.dirname(os.path.realpath(__file__))
        ruta_modelo = os.path.join(ruta_script, nombre_modelo)
        model = tf.keras.models.load_model(ruta_modelo)


        areaFree = [feature['Area'] for feature in selectedSpaceFree.getFeatures()]
        tipo = [feature['Tipo'] for feature in selectedSpaceFree.getFeatures()]
        
        deltaT=0.1 # es un porcentaje de cuanto se quiere reducir la temperatura media actual. METER VIA PLUGIN
        
        for i in range(len(tipo)): 
            tipo[i] = "N"
        if self.dlg.radioGreen.isChecked(): #MEDIDA MITIGADORA CESPED
            op=1
            X_mean,Temp_mean=self.ParametrosMediosArea(model,windCorridorNormalized,msnmNormalized,ndviNormalized,ndwiNormalized,svfNormalized)
        
            AreaMitigadora,MensajeConsola,deltaTReal, TReal=self.Mitigadoras(model,op,X_mean,Temp_mean,deltaT,total_area)
            
#            metrosNDVI = AreaMitigadora
# se comprueba si el area nueva de cesped necesario supera al espacio libre
          
            if AreaMitigadora>(total_area-total_area_space): #si el area nueva supera a la disponible se cubre todo con el cesped nuevo
                metrosNDVI = total_area-total_area_space
                
                f_GreenNew=metrosNDVI/total_area
                ndvi_final=f_GreenNew*ndvi_green+(1-f_GreenNew)*ndvi_soil
                
                X_final=[[X_mean[0][0], X_mean[0][1], ndvi_final,X_mean[0][3],X_mean[0][4]]]
                X_final_array=np.array(X_final, dtype=np.float32)
                
                T_postMitigation = model.predict(X_final_array, verbose=0)
                delta_postMitigation=Temp_mean-T_postMitigation
            
            else:
                metrosNDVI = AreaMitigadora
                T_postMitigation=TReal
                delta_postMitigation=Temp_mean-T_postMitigation
            
            MitigationCost=metrosNDVI*GreenCost
#            metrosNDVI=8000
            tipo = self.calculoArea(areaFree, tipo, metrosNDVI, "G")
            print("Se seleccionó la opción green")
            self.guardarDatosCadena(tipo, selectedSpaceFree, "Tipo")
        
        elif self.dlg.radioWater.isChecked(): #MEDIDA MITIGADORA AGUA
            op=2
            X_mean,Temp_mean=self.ParametrosMediosArea(model,windCorridorNormalized,msnmNormalized,ndviNormalized,ndwiNormalized,svfNormalized)
        
            AreaMitigadora,MensajeConsola,deltaTReal, TReal=self.Mitigadoras(model,op,X_mean,Temp_mean,deltaT,total_area)
            
#            metrosNDVI = AreaMitigadora
# se comprueba si el area nueva de cesped necesario supera al espacio libre
          
            if AreaMitigadora>(total_area-total_area_space): #si el area nueva supera a la disponible se cubre todo con el cesped nuevo
                metrosNDWI = total_area-total_area_space
                
                f_WaterNew=metrosNDWI/total_area
                ndwi_final=f_WaterNew*ndwi_water+(1-f_WaterNew)*ndwi_suelo
                
                X_final=[[X_mean[0][0], X_mean[0][1], X_mean[0][3],ndwi_final,X_mean[0][4]]]
                X_final_array=np.array(X_final, dtype=np.float32)
                
                T_postMitigation = model.predict(X_final_array, verbose=0)
                delta_postMitigation=Temp_mean-T_postMitigation
            
            else:
                metrosNDWI = AreaMitigadora
                T_postMitigation=TReal
                delta_postMitigation=Temp_mean-T_postMitigation
#            metrosNDWI = 8000
            MitigationCost=metrosNDWI*WaterCost
            tipo = self.calculoArea(areaFree, tipo, metrosNDWI, "B")
            print("Se seleccionó la opción green")
            self.guardarDatosCadena(tipo, selectedSpaceFree, "Tipo")
            print("Se seleccionó la opción blue")
        
        elif self.dlg.radioBoth.isChecked():
            op = 3
            X_mean,Temp_mean=self.ParametrosMediosArea(model,windCorridorNormalized,msnmNormalized,ndviNormalized,ndwiNormalized,svfNormalized)
        
            AreaMitigadora,MensajeConsola,deltaTReal, TReal=self.Mitigadoras(model,op,X_mean,Temp_mean,deltaT,total_area)
            
                       
#            metrosNDVI = AreaMitigadora[0]
#            metrosNDWI = AreaMitigadora[1]

            if np.isscalar(AreaMitigadora):
                AreaVerde = AreaMitigadora
                AreaAgua = 0
            else:
                AreaVerde = AreaMitigadora[0]
                AreaAgua = AreaMitigadora[1]
            if (AreaVerde+AreaAgua)>(total_area-total_area_space): #si el area nueva supera a la disponible se cubre todo con el cesped nuevo
                
                if AreaVerde>(total_area-total_area_space): #Si el cesped supera al area disponible
                    if AreaVerde>AreaAgua:
                
                        metrosNDVI= (AreaVerde/AreaAgua+AreaVerde)*(total_area-total_area_space)
                        metrosNDWI =(total_area-total_area_space)-metrosNDVI
                    
                    
                    else:
                        metrosNDWI= (AreaAgua/AreaAgua+AreaVerde)*(total_area-total_area_space)
                        metrosNDVI =(total_area-total_area_space)-metrosNDWI
                        
                
                elif AreaAgua>(total_area-total_area_space): #Si el agua supera al area disponible
                    if AreaAgua>AreaVerde:
                
                        metrosNDWI= (AreaAgua/AreaAgua+AreaVerde)*(total_area-total_area_space)
                        metrosNDVI =(total_area-total_area_space)-metrosNDWI
                    
                    
                    else:
                        metrosNDVI= (AreaVerde/AreaAgua+AreaVerde)*(total_area-total_area_space)
                        metrosNDWI =(total_area-total_area_space)-metrosNDVI
                else:
                    metrosNDWI= (AreaAgua/AreaAgua+AreaVerde)*(total_area-total_area_space)
                    metrosNDVI =(total_area-total_area_space)-metrosNDWI   
#                    metrosNDWI =0.9*(total_area-total_area_space)
#                    metrosNDVI= 0.1*(total_area-total_area_space)
                
                f_WaterNew=metrosNDWI/total_area
                ndwi_final=f_WaterNew*ndwi_water+(1-f_WaterNew)*ndwi_suelo
                
                f_GreenNew=metrosNDVI/total_area
                ndvi_final=f_GreenNew*ndwi_water+(1-f_GreenNew)*ndvi_soil
                
                X_final=[[X_mean[0][0], X_mean[0][1], ndvi_final,ndwi_final,X_mean[0][4]]]
                X_final_array=np.array(X_final, dtype=np.float32)
                
                T_postMitigation = model.predict(X_final_array, verbose=0)
                delta_postMitigation=Temp_mean-T_postMitigation
            
            else:
                metrosNDVI = AreaVerde
                metrosNDWI = AreaAgua
                
                T_postMitigation=TReal
                delta_postMitigation=Temp_mean-T_postMitigation
#            metrosNDWI = 8000
            MitigationCost=metrosNDWI*WaterCost+metrosNDVI*GreenCost
            
            tipo = self.calculoArea(areaFree, tipo, metrosNDVI, "G")
            tipo = self.calculoArea(areaFree, tipo, metrosNDWI, "B")
            self.guardarDatosCadena(tipo, selectedSpaceFree, "Tipo")
            print("Se seleccionó la opción both")

        print("La Temperatura media post mitigadora: ",T_postMitigation )
        print("Reducción temperatura post mitigadora: ",delta_postMitigation )
        
        Cost="\nCoste de la acción mitigadora es de " + str(MitigationCost)+" €"
        line = "\nFinalizada optimizacion..."
        self.dlg.textSalida.setText(MensajeConsola+Cost+line)

    def calculoArea(self, areaFree, tipo, metrosNDVI, letra):
        metrosNDVIRestantes = metrosNDVI
        while metrosNDVIRestantes > 0:
            idSelected = 0
            for i in range(len(areaFree)):
                if areaFree[i] <= metrosNDVIRestantes and areaFree[i] > areaFree[idSelected] and tipo[i] == "N":
                    idSelected = i
            tipo[idSelected] = letra
            metrosNDVIRestantes -= areaFree[idSelected]

        return tipo