# -*- coding: utf-8 -*-

"""
/***************************************************************************
 TweetMyRiver
                                 A QGIS plugin
 Tweet AI Classifier
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-02-16
        copyright            : (C) 2023 by Oliu Llorente / ICRA
        email                : ollorente@icra.cat
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Oliu Llorente / ICRA'
__date__ = '2023-02-16'
__copyright__ = '(C) 2023 by Oliu Llorente / ICRA'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect

from PyQt5.QtCore import *
from PyQt5.QtGui import *
from PyQt5.QtWidgets import *
from qgis.core import *
from .Tweer_AI_Classifier_provider import Tweet_AI_classifierProvider

from processing.gui.AlgorithmDialog import AlgorithmDialog
from qgis.core import QgsApplication, QgsProcessingFeedback, QgsProcessingParameters

from .allProcess.searchpoints2 import TwitterRiverCes as tCES
from .allProcess.aitraining import AiTraining

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class Tweet_AI_classifierPlugin(object):

    def __init__(self, iface):
        self.provider = None
        self.iface = iface
        self.provider = Tweet_AI_classifierProvider()

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        QgsApplication.processingRegistry().addProvider(self.provider)

    def extraction_translation(self):
        servei = tCES()
        servei.initAlgorithm()
        servei.setProvider(self.provider)
        dlg = AlgorithmDialog(servei, parent=self.iface.mainWindow())
        dlg.show()
        # do NOT remove!!!! if you do then sip forgets the python subclass of AlgorithmDialog and you get a broken
        # dialog
        dlg.exec_()

    def classification(self):
        servei = AiTraining()
        servei.initAlgorithm()
        servei.setProvider(self.provider)
        dlg = AlgorithmDialog(servei, parent=self.iface.mainWindow())
        dlg.show()
        # do NOT remove!!!! if you do then sip forgets the python subclass of AlgorithmDialog and you get a broken
        # dialog
        dlg.exec_()

    def initGui(self):
        self.menu = QMenu("Tweet My River", self.iface.mainWindow().menuBar())
        self.action_extraction_translation = QAction("Extraction and Translation", self.iface.mainWindow())
        self.action_classification = QAction("Classification", self.iface.mainWindow())

        actions = self.iface.mainWindow().menuBar().actions()
        lastAction = actions[-1]
        self.iface.mainWindow().menuBar().insertMenu(lastAction, self.menu)
        self.menu.addAction(self.action_extraction_translation)
        self.menu.addAction(self.action_classification)

        self.action_extraction_translation.triggered.connect(self.extraction_translation)
        self.action_classification.triggered.connect(self.classification)

        self.initProcessing()


    def unload(self):
        self.menu.deleteLater()
        QgsApplication.processingRegistry().removeProvider(self.provider)
