# -*- coding: utf-8 -*-
"""
/***************************************************************************
 TrafficViewer
                                 A QGIS plugin
 allows the user to add  googlemap traffic layer with realtime traffic data as a layer.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-11-12
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Adel HADDID. Amine LARBI
        email                : adel.haddid@etu.usthb.dz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QMessageBox

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .traffic_viewer_dialog import TrafficViewerDialog
import os.path
import os # This is is needed in the pyqgis console also

from qgis.core import (
    QgsVectorLayer
)

from qgis.PyQt.QtCore import (
    QRectF,
)

from qgis.core import (
    QgsProject,
    QgsLayerTreeModel,
)

from qgis.gui import (
    QgsLayerTreeView,
)

from qgis.core import QgsRasterLayer, QgsProject

class TrafficViewer:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'TrafficViewer_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Traffic Viewer')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('TrafficViewer', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToWebMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/traffic_viewer/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Traffic Viewer'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginWebMenu(
                self.tr(u'&Traffic Viewer'),
                action)
            self.iface.removeToolBarIcon(action)

        
    def run(self, ):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = TrafficViewerDialog()
            #QMessageBox.information(self.dlg, "message0", "should only run once")
        self.dlg.spbStyle.valueChanged.connect(self.evt_trafficViewer)
        self.dlg.cmbBaseMap.currentTextChanged.connect(self.evt_trafficViewer)
        self.dlg.cmbLanguage.currentTextChanged.connect(self.evt_trafficViewer)
        self.dlg.cmbAnnotation.currentTextChanged.connect(self.evt_trafficViewer)
        self.dlg.show()
        # Run the dialog event loop
        #result = self.dlg.exec_()
        # See if OK was pressed
      
        
    
    def evt_trafficViewer(self, result):
        ispbStyle = self.dlg.spbStyle.value()
        baseMap = self.dlg.cmbBaseMap.currentText()
        language = self.dlg.cmbLanguage.currentText()
        iAnnotation = self.dlg.cmbAnnotation.currentText()
        floatStyle = float(ispbStyle)  
        result = True
        #result = self.dlg.exec_()
        if result == self.dlg.exec_() :
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
                #########################################################################
                #                                                                       #
                #                                the code part                          #
                #                       that will add data to the link                  #
                #########################################################################

                #the style will change the way the roads look , show annotations and size of the roads
                # style 1 has names written in english and native language ex : eng + jap or eng + arabic
                # style 2 only has one language shown and the roads are thicker
                # style 3 doesnt have anything but the road no name no nothing
                # any other number works just fine but to our experiance is useless to change 

            style = str(floatStyle)
            #style = input("enter style")
            # you would use the input method if the code was being run on a console that interacts with the user but since we want to use the GUI it's on comment mode
            if style == '':
                style = '3'
                #this part of the code isn't neaded anymore because the combobox is set to 3 as default  but i will leave it if someone deletes the number 
                #i will leave it at 3 as standard because it keeps only the road in a transparent mode so it can be superposed on top of other layers
            print("style is :" +style)
                #this print on top is actually useless i just did it to be able to know what is going on while writing the code 
                #actually it's good to read it in the console but we will add a QMessageBox to show all the info at the end too



                ###################################################################################################################
            """     the language will change the language of the annotations
                you can set it to whatever language you want i just added a few, i don't see the need of having anything more than englisg
                everyone speaks it and knows it, moreover it just names of places in this layer but since it's translucent you will be 
                able to use names of other layers OMS .. etc or your own layer but still here are the main ones 
                as they say in german khouas est ducatur 
                the annotation only appears in style different than 3
                and are explained up top on style part of the code no need to rewrite the comment here 
                having language as none shows it in english and native language in same time as if style = 1 even if it's = 2 """

            langue = language
            #langue = input("enter style")

            if langue != 'none' :
                style = '2'
                langue = langue
            print("langue is :" +langue)



                ########################################################################################################################

                #to show annotation in the map such as name of places and of roads, this will also show a minus mark on roads with construction ongoing
                
            annotation = iAnnotation
            #annotation = input('True' or 'false')
            if annotation == False and langue == 'none' :
                style = "3"
            if annotation == True :
                print ("to show annotation the style must change \n style automaticaly set to 2 ")
                style = '2'



                #########################################################################################################################
                #this changes the map type from any existinf map type at google
                # it basically ads a basemap from google existing ones
                # below are the existing types up to this date
                # the dark mode still doesnt have a specific letter to summon it
                # it was added only last week so i couldn't find it 
                """
                h = roads only
                m = standard roadmap
                p = terrain
                r = somehow altered roadmap
                s = satellite only
                t = terrain only
                y = hybrid

                """
            map_type = baseMap
            #map_type = input("enter style")
            if map_type == '':
                map_type = 'h'
            print("map_type is :" +map_type)

                #########################################################################
                #                                                                       #
                #                          part of the code                             #
                #                           that shows the layer                        #
                #########################################################################

                # this is the part that shows the layer in the viewer it adds the map layer as the function says
                #i you can find this code in the qgis documentation for developpers at :  https://docs.qgis.org/3.22/en/docs/pyqgis_developer_cookbook/cheat_sheet.html 
                #the import part is at the top
                # i would add a note to anyone  who may encounter this same issue as me
                # that code chunk does not open google map images that have links as :  https://mt1.google.com/vt?lyrs=h@159000000,traffic|seconds_into_week:-1&style=4&x={x}&y={y}&z={z}
                # you have to change it to be readable here's how : https://developers.google.com/maps/documentation/urls/get-started
                # so that the link will have %3D and %2 ... etc like the osm link in the exemple documentation and my project instead of the actual WMS link found on the internet
                #even in the link on the internet is reasable by the xyz tile, i guess he does the transformation automatically in fact you can use it as a converter to not do it manually
                #you input the link xyz tiler like this : https://gis.stackexchange.com/questions/295097/qgis-3-2-2-openlayers-plugin-isnt-listed-to-install/342404#342404
                # and then in then double click, in the source of this layer your will find the link ready to use and full of %3 %2 that we love - this last point took me 5 hours of intesif work to find
                # mt0 mt1 .. are servers if 0 doesnt work switch to 1 etc

            def loadXYZ(url, name):
                rasterLyr = QgsRasterLayer("type=xyz&url=" + url, name, "WMS")
                QgsProject.instance().addMapLayer(rasterLyr)
            urlWithParams = 'type=xyz&url=https://mt0.google.com/vt/lyrs%3D'+map_type+'@221097413,traffic%7Cseconds_into_week:0%26hl%3D'+langue+'%26style%3D'+style+'%26x%3D%7Bx%7D%26y%3D%7By%7D%26z%3D%7Bz%7D&zmax=18&zmin=3&crs=EPSG3857'
            loadXYZ(urlWithParams, 'Trafic_Layer')
            QMessageBox.information(self.dlg, "message0", "map loaded successfully")       

            


"""
                                                                                                    
                                                                                                    
                                                                                                    
                                                                                                    
                                                                                                    
                                                                                                    
                                                                                                    
                                                                                                    
  ..        ..****OOLL**..  ......        ......                                                    
  ......        ssOOHHHHOOaa**      ....      ..                                                    
  ......        aaOOMMMMMMMMMMww......                                                              
  ....      ,,ooHHHH####MMHHMMHHwwss,,    ....                                                      
          ..aaOO##KKKKHHHHMMMMHHHHOOaa,,  ....                                                      
      ..,,aaOO##LLoo****ssOO####HH##MMaa..                                                          
    ..ooKKMMMMHH**,,oo**,,..ss##HH####ww..                                                          
..  ,,LL####MMLL**,,****oo,,..aaMM####aa                                                            
..    aa######ww,,,,********,,..ww####oo..,,..  ......            ....    ....                      
  ..ooHH######LL**oooooo**..,,**oo####aa        ....          ..,,,,,,..                            
  ..aa########LL**wwLLLLss,,oooo,,MM##ss        ..        ..,,**ssoo****,,..                        
....ooMM######aaooOOOOHHww**wwLLoo##HH,,  ..    ..      ..,,oossaaoooooooo,,                        
,,..  LL######ssaaOOKKLLoo,,KKMMaa##MM**  ..    ..      ..**ssaaaaoo**ssss**,,..                    
  ..  aaOOOOHHssoowwaass**,,wwKKoo####aa        ..      ..,,ooaass**,,oossss**..                    
      wwKKKKOOss,,oooossoo**oooo,,MM##ss        ....    ..,,**oo****,,**ssaa**                      
      LLKKKKHH****************,,**HHOO..        ....    ....******,,,,,,ooaaoo                      
      oo##KKKKoooo**oossoo****oowwLL**....    ..          ,,ssssooaaLLooooww**                      
  ..  **##OOaassoo,,ooaaoooooo**ssaa,,....    ..        **wwKKOO,,ssLLoo**ss**                      
..    ..KK##KKaaoo**ooaaaassoo******......  ..    ......**aaLLKK,,oowwoo**oo,,..                    
,,..    oo####aaoooossaawwaaoo**..  ....    ..  ..,,..  ..**oooo****ss****oo,,                      
  ,,..  ,,MMOOsssssswwLLaassss**      ..  ....    ....  ..**oooo****oo****oo..                      
  ..  ..  oossssaawwLLLLaassss**      ..  ....          ..oossaaoo**ssoo,,,,  ..                    
,,    ..,,ss**wwwwKKLLwwaaaaoo**..  ..    ..      ..      **ssaassoossoo**..  ..                    
,,..    LLHH,,LLKKLLLLwwssaass,,,,....            ..    ..oowwwwwwoooooo**,,                        
  ,,ssOO##MMoo,,KK##MMOOaaaa**..  ,,..    ......    ..      ooss**ss**ooss      ........            
aaKKHHMM####ww..LL##MMHHOOKK**..        ..      ..........,,oossoo**,,,,ssLLoo                      
MM##########HH**..LLOOKKLLaa,,        ....      ..  ..,,ooaaaawwwwss**,,aa##aa......        ....    
MMMMMM########LL  ,,oossssaass,,                ,,,,ssKKMMOOsssswwss**,,OO##KKKKssoo,,..    ....    
MMHHHH##########**,,**oossLLHHOO**,,..        ..LLLLHH####MM**ssOOKK**ooMMOOOOMMOOKKaa**..    ..    
MM##MMMM########aa**,,,,ooaaHH##LLss....,,    aa##MM##MM##HH**KK##MMooLLMMOOKKOO##MMOOaa,,    ..    
MM####MMMM######OO**,,**aaaaOO##MMKK,,  ,,  ..OO##MM######OO,,HHMMssooHHMMMMMMHHMMMMHHww..    ..    
HHMM##MMMM########aawwKKKKaaHH####MM**  ,,..**MM##MM######KK  OOMM  ww##MMHH##HHOOHHHHww..    ,,    
MMMMMM############OOssMMHH**OO##MM##aa  ,,,,ss######MM####wwaa##HHssHH##HHMMHHMMHHHHMMww      ..    
MMMMMM##############ssLLMMssaa######aa  ....ww############LLww##HHaaMM##HHMMMMMMHHHHMMww      ..    
MMMMMM##############wwooMMLL,,MM####ww      OO############OOKK##HHwwMM##HH##MMHHHHMMMMww..    ..    
MMMMMM##########MM##HH**KKKK..OO####ww      ##############HHHH##HHKK##MMHH####HHMMMMMMww..          
MM##############MM####ooaaKK,,ww####LL    ,,####################HHHH##MMMM####MMMMMM##LL..          
################MMMM##aaooKKooooMM##KK    oo####################MM####MMMM####MMMMMM##LL..          
##################MM##LLooLLww,,OO##OO....ww##########################################LL..          
##################HH##OO**LLKK..KK##HH....KK##########################################LL..          
############MMMM####MM##ssssOOooaa####..  MM####################################MM##MMLL            
############MMMM####MM##ssssOOoooo####**..MM####################################MM##MMLL            
"""

