# -*- coding: utf-8 -*-
"""
/***************************************************************************
 TopoTijdReis
                                 A QGIS plugin
 deze pluging integreerd de functionaliteiten van de TopoTijdReis vieuwer in qgis.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-07-17
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Eric Schippers
        email                : ew.schippers@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# -*- coding: utf-8 -*-

import os.path
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QLineEdit
from PyQt5.QtWidgets import QDockWidget
from qgis.core import QgsProject, QgsRasterLayer, QgsMapThemeCollection
from qgis.gui import QgsMapCanvas
from .topotijdreis_dockwidget import SingelDockWidget, DoubelDockWidget


class TopoTijdReis:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor."""
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)

        # Locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(self.plugin_dir, 'i18n', f'Topotijdreis_{locale}.qm')
        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declaraties
        self.actions = []
        self.menu = self.tr(u'&Toptijdreis2QGIS')
        self.toolbar = self.iface.addToolBar(u'Topotijdreis')
        self.toolbar.setObjectName(u'Topotijdreis')

        self.project = QgsProject.instance()
        self.layertreeroot = self.project.layerTreeRoot()
        self.pluginIsActive = False
        self.active_mode = None
        self.dockwidget = None
        self.double_dockwidget = None
        self.secondCanvas = None
        self.connected_project_signals = False

        #conect project signalen
        self.project.writeProject.connect(self.onProjectSave)
        self.project.readProject.connect(self.onProjectLoad)
        self.project.cleared.connect(self.onClosePlugin)


    def tr(self, message):
        """Vertaling ophalen."""
        return QCoreApplication.translate('Topotijdreis', message)

    def add_action(self, icon_path, text, callback, enabled_flag=True,
                   add_to_menu=True, add_to_toolbar=True, status_tip=None,
                   whats_this=None, parent=None):
        """Ad action to the toolbar/menu."""
        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip:
            action.setStatusTip(status_tip)
        if whats_this:
            action.setWhatsThis(whats_this)
        if add_to_toolbar:
            self.toolbar.addAction(action)
        if add_to_menu:
            self.iface.addPluginToWebMenu(self.menu, action)

        self.actions.append(action)
        return action

    def initGui(self):
        """Menu en toolbar icoon aanmaken in QGIS."""
        icon_path = os.path.join(self.plugin_dir, 'icon.png')
        self.add_action(
            icon_path,
            text=self.tr(u'Topotijdreis'),
            callback=self.run_singel,
            parent=self.iface.mainWindow()
        )
        self.add_action(
            icon_path,
            text=self.tr(u'Vergelijken'),
            callback=self.run_double,
            add_to_toolbar=False,
            parent=self.iface.mainWindow()
        )

        self.toolbar_search = QLineEdit()

        self.toolbar_search.setMaximumWidth(150)
        self.toolbar_search.setAlignment(Qt.AlignmentFlag.AlignLeft)
        self.toolbar_search.setPlaceholderText(self.tr('Zoek jaar in Topotijdreis'))
        self.toolbar.addWidget(self.toolbar_search)
        self.toolbar_search.returnPressed.connect(self.on_search_year)

    def unload(self):
        """Plugin verwijderen uit QGIS UI."""
        for action in self.actions:
            self.iface.removePluginWebMenu(self.tr(u'&TopTijdReis2QGIS'), action)
            self.iface.removeToolBarIcon(action)
        del self.toolbar
        del self.toolbar_search

    def onClosePlugin(self):
        """Opruimen bij sluiten van de plugin."""

        # remove layers on close plugin
        for lyr in self.project.mapLayers().values():
            if lyr.name().startswith("Topotijdreis") or lyr.name().startswith("Luchtfototijdreis"):
                self.project.removeMapLayer(lyr.id())

        for name in ['Topotijdreis', 'Topotijdreis_hoofdcanvas', 'Topotijdreis_tweedecanvas']:
            group = self.layertreeroot.findGroup(name)
            if group:
                parent = group.parent()
                if parent:
                    parent.removeChildNode(group)

        if getattr(self, "active_mode", None) == "double":
            # disconnect the signels
            if self.connected_project_signals:
                try:
                    self.project.layerRemoved.disconnect(self.on_layers_tree_event)
                    self.project.layersAdded.disconnect(self.on_layers_tree_event)
                    self.layertreeroot.visibilityChanged.disconnect(self.on_layers_tree_event)
                    self.layertreeroot.layerOrderChanged.connect(self.on_layers_tree_event)
                except TypeError:
                    pass
                self.connected_project_signals = False

            if self.double_dockwidget:
                self.iface.removeDockWidget(self.double_dockwidget)
                self.double_dockwidget.deleteLater()
                self.double_dockwidget = None

            # close the second map canvas
            if self.secondCanvas:
                self.iface.closeMapCanvas('Topotijdreis 2e kaartweergave')
                self.secondCanvas = None
            self.project.mapThemeCollection().removeMapTheme("Thema_tweedecanvas")

        if self.dockwidget is not None:
            try:
                self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)
            except TypeError:
                pass
        self.pluginIsActive = False
        self.active_mode = None

    def onProjectLoad(self):

        # Single / double dockwidget
        active, ok = self.project.readBoolEntry("topotijdreis", "active", False)
        if not ok or not active:
            return

        mode, _ = self.project.readEntry("topotijdreis", "mode", None)
        dock_area, _ = self.project.readNumEntry("topotijdreis", "dock_area", int(Qt.RightDockWidgetArea))

        if mode == "single":
            year, _ = self.project.readNumEntry("topotijdreis", "year", 0)
            self.run_singel(on_load=True)
            if year > 0:
                self.dockwidget.slider.setValue(year)
            self.iface.addDockWidget(Qt.DockWidgetArea(dock_area), self.dockwidget)

        elif mode == "double":
            year_main, _ = self.project.readNumEntry("topotijdreis", "year_main", 0)
            year_second, _ = self.project.readNumEntry("topotijdreis", "year_second", 0)
            self.run_double(on_load=True)
            self.iface.addDockWidget(Qt.DockWidgetArea(dock_area), self.double_dockwidget)
            if year_main > 0:
                self.double_dockwidget.slider_main.setValue(year_main)
            if year_second > 0:
                self.double_dockwidget.slider_second.setValue(year_second)
    def onProjectSave(self):

        self.project.writeEntry("topotijdreis", "active", self.pluginIsActive)
        self.project.writeEntry("topotijdreis", "mode", self.active_mode)

        if self.active_mode == 'singel':
            area = int(self.iface.mainWindow().dockWidgetArea(self.dockwidget))
            self.project.writeEntry("topotijdreis", "dock_area", area)
            self.project.writeEntry(
                "topotijdreis",
                "year",
                self.dockwidget.slider.value()
            )

        if self.active_mode == 'double':
            area = int(self.iface.mainWindow().dockWidgetArea(self.double_dockwidget))
            self.project.writeEntry("topotijdreis", "dock_area", area)
            self.project.writeEntry(
                "topotijdreis",
                "year_main",
                self.double_dockwidget.slider_main.value()
            )
            self.project.writeEntry(
                "topotijdreis",
                "year_second",
                self.double_dockwidget.slider_second.value()
            )

    def on_search_year(self):
        """Wordt aangeroepen wanneer gebruiker op Enter drukt in de zoekbalk."""
        text = self.toolbar_search.text().strip()
        if not text.isdigit():
            self.iface.messageBar().pushWarning("Topotijdreis", "Voer een geldig jaartal in.")
            return
        year = int(text)
        try:
            self.update_topotijdreis(year, "Topo")
            self.toolbar_search.clear()
        except Exception as e:
            self.iface.messageBar().pushWarning("Topotijdreis", f"Fout bij laden: {e}")

    def on_layers_tree_event(self, *args):
        self.update_theme("Thema_tweedecanvas", "Topotijdreis_hoofdcanvas")

    def selected_year(self):
        return self.dockwidget.slider.value()

    def update_theme(self, theme_name, exclude_group_name=None):
        theme_collection = self.project.mapThemeCollection()
        theme_record = QgsMapThemeCollection.MapThemeRecord()

        def collect_group_layers(group_node):
            ids = []
            for child in group_node.children():
                if child.nodeType() == child.NodeLayer:
                    ids.append(child.layerId())
                elif child.nodeType() == child.NodeGroup:
                    ids.extend(collect_group_layers(child))
            return ids

        # add all layer to the theme except the layer in the exclude group
        excluded_ids = []
        if exclude_group_name:
            exclude_group = self.layertreeroot.findGroup(exclude_group_name)
            if exclude_group:
                excluded_ids = collect_group_layers(exclude_group)

        for layer in self.project.mapLayers().values():
            if layer.id() not in excluded_ids:
                lr = QgsMapThemeCollection.MapThemeLayerRecord(layer)

                node = self.layertreeroot.findLayer(layer.id())
                lr.isVisible = node.isVisible() if node else False
                theme_record.addLayerRecord(lr)

        # add theme or update
        if theme_name in theme_collection.mapThemes():
            theme_collection.update(theme_name, theme_record)
        else:
            theme_collection.insert(theme_name, theme_record)

    def update_topotijdreis(self, year, combobox_setting, layer_group=None):

        # construct WMS and WMTS url for topotijdreis layers
        if combobox_setting == 'Topo':
            layer_name = f"Topotijdreis {year}"
            url = (
                "https://tiles.arcgis.com/tiles/nSZVuSZjHpEZZbRo/"
                f"arcgis/rest/services/Historische_tijdreis_{year}/MapServer/"
                "WMTS/1.0.0/WMTSCapabilities.xml"
            )
            layer = QgsRasterLayer(url, layer_name)
        else:
            layer_name = f"Luchtfototijdreis {year}"

            if year < 2016:
                # Manual expetions
                if year == 2012:
                    url = ("https://tiles.arcgis.com/tiles/nSZVuSZjHpEZZbRo/arcgis/rest/services/LuchtfotoNL50cm_2012/"
                           "MapServer/WMTS/1.0.0/WMTSCapabilities.xml?cacheKey=b69a3ea4c7c9a0e0")
                elif year == 2013:
                    url = ("https://tiles.arcgis.com/tiles/nSZVuSZjHpEZZbRo/arcgis/rest/services/LuchtfotoNL50cm_2013/"
                           "MapServer/WMTS/1.0.0/WMTSCapabilities.xml?cacheKey=949eabfae59c37f4")
                elif year == 2014:
                    url = ("https://tiles.arcgis.com/tiles/nSZVuSZjHpEZZbRo/arcgis/rest/services/LuchtfotoNL_50_cm_2014/"
                           "MapServer/WMTS/1.0.0/WMTSCapabilities.xml?cacheKey=849efb46bb1e2b46")
                elif year == 2015:
                    url = ("https://tiles.arcgis.com/tiles/nSZVuSZjHpEZZbRo/arcgis/rest/services/LuchtfotoNL_2015_50_cm/"
                           "MapServer/WMTS/1.0.0/WMTSCapabilities.xml?cacheKey=86e61627ea70c2be")
                else:
                    url = (f"https://tiles.arcgis.com/tiles/nSZVuSZjHpEZZbRo/arcgis/rest/services/Luchtfoto_{year}"
                           "/MapServer/WMTS/1.0.0/WMTSCapabilities.xml")

                layer = QgsRasterLayer(url, layer_name)
            else:
                url = (
                    "contextualWMSLegend=0"
                    "&crs=EPSG:28992"
                    "&dpiMode=7"
                    "&format=image/jpeg"
                    f"&layers={year}_orthoHR"
                    "&styles="
                    "&tilePixelRatio=0"
                    "&url=https://service.pdok.nl/hwh/luchtfotorgb/wms/v1_0?"
                )
                layer = QgsRasterLayer(url, layer_name, 'wms')

                if not layer.isValid():
                    url = (
                        "contextualWMSLegend=0"
                        "&crs=EPSG:28992"
                        "&dpiMode=7"
                        "&format=image/jpeg"
                        f"&layers={year}_ortho25"
                        "&styles="
                        "&tilePixelRatio=0"
                        "&url=https://service.pdok.nl/hwh/luchtfotorgb/wms/v1_0?"
                    )
                layer = QgsRasterLayer(url, layer_name, 'wms')

        if not layer.isValid():
            self.iface.messageBar().pushWarning("Topotijdreis", f"Laag ongeldig: {year}")
            return

        # remove existing topotijdreis layer and ad a new one
        if layer_group:
            layers_to_remove = list(layer_group.findLayers())
            for child in layers_to_remove:
                name = child.name().lower()
                if name.startswith("topotijdreis") or name.startswith("luchtfototijdreis"):
                    self.project.removeMapLayer(child.layerId())

        if layer_group:
            self.project.addMapLayer(layer, False)
            layer_group.insertLayer(0, layer)
        else:
            self.project.addMapLayer(layer, True)


    def run_singel(self, on_load=False):
        self.active_mode = "single"
        self.iface.mapCanvas().refresh()

        if on_load is False:
            layer_group = self.project.layerTreeRoot().insertGroup(1, 'Topotijdreis')
        else:
            layer_group = self.layertreeroot.findGroup('Topotijdreis')

        if not self.pluginIsActive:
            self.pluginIsActive = True

            if self.dockwidget is None:
                self.dockwidget = SingelDockWidget()

            self.dockwidget.closingPlugin.connect(self.onClosePlugin)

            # Connect slider and spinbox
            self.dockwidget.spinBox.valueChanged.connect(self.dockwidget.slider.setValue)

            # Connect signal to function
            self.dockwidget.jaarGewijzigd.connect(
                lambda jaar: self.update_topotijdreis(
                    jaar,
                    self.dockwidget.comboBox.currentText(),
                    self.project.layerTreeRoot().findGroup('Topotijdreis')
                )
            )
            self.dockwidget.comboBox.currentTextChanged.connect(
                lambda: self.update_topotijdreis(
                    self.selected_year(),
                    self.dockwidget.comboBox.currentText(),
                    self.project.layerTreeRoot().findGroup('Topotijdreis')
                )
            )

            if on_load is False:
                self.iface.addDockWidget(Qt.RightDockWidgetArea, self.dockwidget)
                self.dockwidget.show()
                self.update_topotijdreis(self.selected_year(), self.dockwidget.comboBox.currentText(), layer_group)

    def run_double(self, on_load=False):
        self.active_mode = "double"
        self.iface.mapCanvas().refresh()


        # add second canvas
        if on_load is False:
            self.secondCanvas = self.iface.createNewMapCanvas('Topotijdreis 2e kaartweergave')
            self.secondCanvas.show()
            topo_group = self.project.layerTreeRoot().insertGroup(1, 'Topotijdreis')
            main_group = topo_group.addGroup('Topotijdreis_hoofdcanvas')
            second_group = topo_group.addGroup('Topotijdreis_tweedecanvas')
        else:
            if self.secondCanvas is None:
                for dw in self.iface.mainWindow().findChildren(QDockWidget):
                    if dw.windowTitle() == "Topotijdreis 2e kaartweergave":
                        canvases = dw.findChildren(QgsMapCanvas)
                        if canvases:
                            self.secondCanvas = canvases[0]

        if not self.pluginIsActive:
            self.pluginIsActive = True

            combobox_setting = self.dockwidget.comboBox.currentText() if self.dockwidget else "Topo"

            # double dockwidget and conect singnals
            self.double_dockwidget = DoubelDockWidget()
            self.double_dockwidget.closingPlugin.connect(self.onClosePlugin)


            self.double_dockwidget.spinBox_main.valueChanged.connect(self.double_dockwidget.slider_main.setValue)
            self.double_dockwidget.spinBox_second.valueChanged.connect(self.double_dockwidget.slider_second.setValue)

            # Connect slider signal voor maindcanvas
            self.double_dockwidget.jaarGewijzigd_main.connect(
                lambda jaar: (
                    self.update_topotijdreis(
                        jaar,
                        self.double_dockwidget.comboBox.currentText(),
                        self.project.layerTreeRoot().findGroup("Topotijdreis_hoofdcanvas")
                    )
                )
            )

            # Connect slider signal for second canvas
            self.double_dockwidget.jaarGewijzigd_second.connect(
                lambda jaar: (
                    self.update_topotijdreis(
                        jaar,
                        self.double_dockwidget.comboBox.currentText(),
                        self.project.layerTreeRoot().findGroup("Topotijdreis_tweedecanvas")
                    )
                )
            )

            if not self.connected_project_signals:
                self.project.layerRemoved.connect(self.on_layers_tree_event)
                self.project.layersAdded.connect(self.on_layers_tree_event)
                self.layertreeroot.visibilityChanged.connect(self.on_layers_tree_event)
                self.layertreeroot.layerOrderChanged.connect(self.on_layers_tree_event)
                self.connected_project_signals = True

            # add dockwidget
            if on_load is False:
                self.iface.addDockWidget(Qt.RightDockWidgetArea, self.double_dockwidget)
                self.double_dockwidget.show()

                self.update_topotijdreis(self.double_dockwidget.slider_main.value(), combobox_setting, main_group)
                self.update_topotijdreis(self.double_dockwidget.slider_second.value(), combobox_setting, second_group)

                self.update_theme("Thema_tweedecanvas", "Topotijdreis_hoofdcanvas")
                self.secondCanvas.setTheme("Thema_tweedecanvas")
