# -*- coding: utf-8 -*-
"""
/***************************************************************************
 TopoTijdReisDockWidget
                                 A QGIS plugin
 deze pluging integreerd de functionaliteiten van de TopoTijdReis vieuwer in qgis.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-07-17
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Eric Schippers
        email                : ew.schippers@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import QtWidgets, uic
from qgis.PyQt.QtCore import pyqtSignal
from PyQt5.QtWidgets import QSlider, QToolTip, QLabel
from PyQt5.QtCore import Qt
from datetime import datetime

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'topotijdreis_dockwidget_singel.ui'))
FORM_CLASS_DOUBLE, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'topotijdreis_dockwidget_double.ui'))

max_year = datetime.now().year - 1


class CommonDockLogic:

    def update_slider_and_spinbox(self, slider,spinbox,combobox_value):

        slider.setMaximum(max_year)
        if combobox_value == 'Topo':
            slider.setMinimum(1815)
            slider.setTickInterval(5)
            spinbox.setMinimum(1815)
        else:
            slider.setMinimum(2006)
            slider.setTickInterval(1)
            spinbox.setMinimum(2006)

        # Synchroniseer slider en spinbox
        slider.valueChanged.connect(spinbox.setValue)
        spinbox.valueChanged.connect(slider.setValue)

    def update_slider_labels(self, slider,labelContainer, combobox_value):
        layout = labelContainer.layout()
        layout.setContentsMargins(0, 0, 0, 0)
        layout.setSpacing(0)

        while layout.count():
            item = layout.takeAt(0)
            widget = item.widget()
            if widget:
                widget.deleteLater()

        if combobox_value == "Topo":
            years = [1816] + list(range(1850, max_year, 50)) + [max_year]
            years = sorted(set(years))
            previous_year = 1815

            for i, year in enumerate(reversed(years)):
                diff = previous_year - year if i > 0 else max_year - year
                if diff > 0:
                    layout.addStretch(diff)
                label = QLabel(str(year))
                label.setAlignment(Qt.AlignRight | Qt.AlignVCenter)
                layout.addWidget(label)
                previous_year = year

            if previous_year > 1815:
                layout.addStretch(previous_year - 1815)
        else:
            for year in reversed(range(2006, max_year + 1)):
                label = QLabel(str(year))
                label.setAlignment(Qt.AlignCenter)
                layout.addWidget(label)

        label.setStyleSheet("min-width: 30px; font-size: 12px;")




class SingelDockWidget(QtWidgets.QDockWidget, FORM_CLASS, CommonDockLogic):

    closingPlugin = pyqtSignal()
    jaarGewijzigd = pyqtSignal(int)

    def __init__(self, parent=None):
        """Constructor."""
        super(SingelDockWidget, self).__init__(parent)
        self.setupUi(self)

        # populate combobox
        self.comboBox.addItems(["Topo", "Luchtfoto"])
        combobox_setting = self.comboBox.currentText()

        # connect event
        self.comboBox.currentTextChanged.connect(
            lambda val: (
                self.update_slider_and_spinbox(self.slider, self.spinBox, val),
                self.update_slider_labels(self.slider, self.labelContainer, val)
            )
        )

        self.slider.setMaximum(max_year)
        self.slider.setValue(max_year)
        self.slider.setMinimum(1815)
        self.slider.setTickInterval(10)

        self.spinBox.setMaximum(max_year)
        self.spinBox.setValue(max_year)
        self.spinBox.setMinimum(1815)

        self.update_slider_labels(self.slider, self.labelContainer,combobox_setting )

        # Synchroniseer slider en spinbox
        self.slider.valueChanged.connect(self.spinBox.setValue)
        self.spinBox.valueChanged.connect(self.slider.setValue)

        # Emit signaal on slider value change
        self.slider.sliderReleased.connect(lambda: self.jaarGewijzigd.emit(self.slider.value()))
        self.spinBox.editingFinished.connect(lambda: self.jaarGewijzigd.emit(self.spinBox.value()))

    def closeEvent(self, event):
        self.closingPlugin.emit()
        event.accept()

class DoubelDockWidget(QtWidgets.QDockWidget, FORM_CLASS_DOUBLE, CommonDockLogic):

    closingPlugin = pyqtSignal()
    jaarGewijzigd_main = pyqtSignal(int)
    jaarGewijzigd_second = pyqtSignal(int)

    def __init__(self, parent=None):
        super().__init__(parent)
        self.setupUi(self)

        # populate combobox
        self.comboBox.addItems(["Topo", "Luchtfoto"])
        combobox_setting = self.comboBox.currentText()

        # Connect combobox to both sliders
        self.comboBox.currentTextChanged.connect(
            lambda val: (
                self.update_slider_and_spinbox(self.slider_main, self.spinBox_main, val),
                self.update_slider_and_spinbox(self.slider_second, self.spinBox_second, val),
                self.update_slider_labels(self.slider_main, self.labelContainer, val)
            )
        )

        for slider, spinBox in [(self.slider_main, self.spinBox_main),(self.slider_second, self.spinBox_second)]:
            slider.setMaximum(max_year)
            slider.setValue(max_year)
            slider.setMinimum(1815)
            slider.setTickInterval(10)

            spinBox.setMaximum(max_year)
            spinBox.setValue(max_year)
            spinBox.setMinimum(1815)

        self.update_slider_labels(self.slider_main, self.labelContainer,combobox_setting )

        self.slider_main.valueChanged.connect(self.spinBox_main.setValue)
        self.spinBox_main.valueChanged.connect(self.slider_main.setValue)
        self.slider_second.valueChanged.connect(self.spinBox_second.setValue)
        self.spinBox_second.valueChanged.connect(self.slider_second.setValue)

        # Emit signaal on slider value change
        self.slider_main.sliderReleased.connect(lambda: self.jaarGewijzigd_main.emit(self.slider_main.value()))
        self.spinBox_main.editingFinished.connect(lambda: self.jaarGewijzigd_main.emit(self.spinBox_main.value()))

        self.slider_second.sliderReleased.connect(lambda: self.jaarGewijzigd_second.emit(self.slider_second.value()))
        self.spinBox_second.editingFinished.connect(lambda: self.jaarGewijzigd_second.emit(self.spinBox_second.value()))

    def closeEvent(self, event):
        self.closingPlugin.emit()
        event.accept()