# -*- coding: utf-8 -*-
"""
/***************************************************************************
 TopoNum
                                 A QGIS plugin
 Calcualtes SOI Toposheets numbers from layers. 
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-01-04
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Shailesh Chaure
        email                : chauresk@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication, QVariant    
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QAction, QProgressBar
from qgis.core import *
from qgis.utils import iface
from qgis.PyQt import QtGui
from qgis.gui import QgsMessageBar
# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .topo_num_dialog import TopoNumDialog
import os.path

start_index=[32,37,42,51,60,69,75,80,89,98]
WGSAlpha=['C','D','E','F','G','H','I','J','K','L']

global maptype

global scaleID
global sheetw
global sheeth
global sheetsForLyrExt
global SheetIdByScale
global layer


def degDec2dms(dec):
        deg=int(dec)
        temp=dec-deg
        temp=temp*60
        minute=int(temp)
        sec=temp-minute
        sec=int(round((sec*60),0))	
        return deg,minute,sec
        
def DMS2DD(d,m,s):
        dd=d+(float(m)/60)+(float(s)/3600)
        return dd
               
def dmstosec(d,m,s):
        seconds=(d*3600)+(m*60)+round(s,0)
        return seconds

def sectodeg(t):
        decimal=float(t)/3600
        a,b,c=degDec2dms(decimal)
        return a,b,c

def CalculateExtentInTermsOfSheet(inptLyr):  
        global sheetw
        global sheeth
        inptLyrExt=inptLyr.extent()
        a,b,c=degDec2dms(inptLyrExt.xMinimum())
        minlongs=dmstosec(a,b,c)
        a,b,c=degDec2dms(inptLyrExt.xMaximum())
        maxlongs=dmstosec(a,b,c)
        a,b,c=degDec2dms(inptLyrExt.yMinimum())
        minlats=dmstosec(a,b,c)
        a,b,c=degDec2dms(inptLyrExt.yMaximum())
        maxlats=dmstosec(a,b,c)
        if minlongs % sheetw !=0: 
            while (minlongs % sheetw)!=0:
                minlongs=minlongs-1
        else:
            minlongs=minlongs-sheetw
       
        if maxlongs%sheetw !=0:
            while (maxlongs % sheetw)!=0:
                maxlongs=maxlongs+1
        else:
            maxlongs=maxlongs+sheetw
       
        if minlats%sheeth !=0:
            while (minlats% sheeth)!=0:
                minlats=minlats-1
        else: 
            minlats=minlats-sheeth

        if maxlats % sheeth !=0:
            while (maxlats % sheeth)!=0:
                maxlats=maxlats+1
        else:
            maxlats=maxlats+sheeth
        return minlongs,maxlongs,minlats,maxlats
      
def validSheet(lt_deg,ln_deg):
        valid=True
        if lt_deg<20:
            if ln_deg<72:
                valid=False
            if (ln_deg>=88)and(ln_deg<92):
                valid=False
        if lt_deg<16:
            if (ln_deg>=84)and(ln_deg<92):
                valid=False;
        if (ln_deg<64)or(ln_deg>=100):
                valid=False
        if (lt_deg<4)or(lt_deg>=40):
                valid=False
        if ((ln_deg>=88)and(ln_deg<92))and(lt_deg<21):
                valid=False
        return valid
     
    
def CalculateOldSheetNum(lat_deg,lat_min,lat_sec,long_deg,long_min,long_sec):
      
        sn=" "
        global scaleID
      
        def Indexno1():
            n=(long_deg // 4)-16
            n=start_index[n]+((39-lat_deg)// 4)
            s=str(n)
            return s
          
        def Indexno2():
            n=(long_deg-(long_deg // 4)*4)*4+((lat_deg // 4)*4)+4-lat_deg-1
            s1=chr(65+n)
            return (Indexno1()+s1)	
          
        def Indexno3():
            if lat_min>=30:
                s1='N'
            else:
                s1='S'
            if long_min>=30:
                s1=s1+'E'
            else:
                s1=s1+'W'
            return(Indexno2()+'/'+s1)
          
        def Indexno4():
            n=(long_min//15)*4+(59-lat_min) //15+1
            s1=str(n)
            return(Indexno2()+'/'+s1)	
          
        def Indexno5():
            n=(lat_min*60)+lat_sec  	
            while (n>=900): 
                n=n-900
            if(n>=450):
                s1='N' 
            else:
                s1='S'
            n=(long_min*60)+long_sec  
            while (n>=900): 
                n=n-900
            if(n>=450):
                s1=s1+'E' 
            else: 
                s1=s1+'W'
            return(Indexno4()+'/'+s1)
        
        if validSheet(lat_deg,long_deg):    
            if(scaleID==1):
                sn=Indexno1() 
            if(scaleID==2):
                sn=Indexno2() 
            if(scaleID==3):
                sn=Indexno3()
            if(scaleID==4):
                sn=Indexno4() 
            if(scaleID==5):
                sn=Indexno5() 
        else:
            sn='#'
        return sn
        
def CalcWGS84_Sheetno(lt_deg,lt_min,lt_sec,ln_deg,ln_min,ln_sec):
        global scaleID
        def Indexno1():
            n=((lt_deg-8) // 4)
            n1=((ln_deg-66) // 6)+42
            return WGSAlpha[n]+str(n1)

        def Indexno2():
            n=(ln_deg-(ln_deg // 6)*6)
            n1=3-(lt_deg-(lt_deg // 4)*4)
            s1=chr(65+n+(n1*6))
            return Indexno1()+s1 

        def Indexno4():
            n=(ln_min // 15)*4+(59-lt_min) // 15+1
            s1=str(int(n))
            if len(s1)==1:
                s1='0'+s1
            return Indexno2()+s1 

        def Indexno5():
            n=lt_min*60+lt_sec
            while n>=900:
                n=n-900
            if n>=450:
                s1='N' 
            else:
                s1='S'
            n=ln_min*60+ln_sec
            while n>=900:
                n=n-900
            if n>=450:
                s1=s1+'E'
            else:
                s1=s1+'W'
            return Indexno4()+'/'+s1 
  
        def Indexno6():
            x=ln_min // 15
            y=lt_min // 15
            n=((ln_min-(x*15)) // 3)
            n1=4-((lt_min-(y*15)) // 3)
            s1=chr(65+n+(n1*5))
            return Indexno4()+s1
 
        def Indexno7():
            ltmin=lt_min % 3
            n=((ltmin*60)+lt_sec) // 36
            n=5-n
            lnmin=ln_min % 3
            n1=((lnmin*60)+ln_sec) // 36
            n=n+(n1*5)
            s1=str(n)
            if len(s1)==1: 
                s1='0'+s1
            return Indexno6()+s1  

        if validSheet(lt_deg,ln_deg):
            if(scaleID==1):
                sn=Indexno1() 
            if(scaleID==2):
                sn=Indexno2() 
            if(scaleID==3):
                sn=Indexno4()
            if(scaleID==4):
                sn=Indexno5()
            if(scaleID==5):
                sn=Indexno6()
            if(scaleID==6):
                 sn=Indexno7()
        else:
            sn='#'
        return sn


def CalculateSheet(sheetTypeID,s_lats,s_longs,Xg,Yg):
        global layer
        laty=s_lats
        id=0
        poly = QgsFeature()
        for i in range(0,Yg):
            longx=s_longs
         
            for j in range(0,Xg):		
                Blt_deg,Blt_min,Blt_sec=sectodeg(laty) # Bottom latitude
                Lln_deg,Lln_min,Lln_sec=sectodeg(longx) # Left longitude
                tlaty=laty+sheeth
                Tlt_deg,Tlt_min,Tlt_sec=sectodeg(tlaty) # Top latitude
                rlongx=longx+sheetw
                Rln_deg,Rln_min,Rln_sec=sectodeg(rlongx) # Right longitude
                xmin=DMS2DD(Lln_deg,Lln_min,Lln_sec)
                ymin=DMS2DD(Blt_deg,Blt_min,Blt_sec)
                xmax=DMS2DD(Rln_deg,Rln_min,Rln_sec)
                ymax=DMS2DD(Tlt_deg,Tlt_min,Tlt_sec)
                if sheetTypeID==1:
                    Sheetnum=CalculateOldSheetNum(Blt_deg,Blt_min,Blt_sec,Lln_deg,Lln_min,Lln_sec)
                else:
                    Sheetnum=CalcWGS84_Sheetno(Blt_deg,Blt_min,Blt_sec,Lln_deg,Lln_min,Lln_sec)
                points = [QgsPointXY(xmin,ymin),QgsPointXY(xmin,ymax),QgsPointXY(xmax,ymax),QgsPointXY(xmax,ymin),QgsPointXY(xmin,ymin)]
                poly.setGeometry(QgsGeometry.fromPolygonXY([points]))
                poly.setAttributes([id,Sheetnum,0])
                id=id+1
              
                layer.dataProvider().addFeatures([poly])
                longx=longx+sheetw	
            laty=laty+sheeth
            
def setSymbolForOutputLayer():
            #my_classes = {1:('green','Intersects with features'),
            #0: ('yellow','Does not Intersects with features')}   
            
            my_classes = {1:('#8BEB2A','Intersects with features'),
            0: ('#F6FE04','Does not Intersects with features')}               
               
            categories = []
            for class_value, (symbol_property, label_text) in my_classes.items():
                    # get default symbol for this geometry type
                    symbol = QgsSymbol.defaultSymbol(layer.geometryType())
                    symbol.setColor(QtGui.QColor(symbol_property))
                    symbol.setOpacity(0.25)
                    # create a category with these properties
                    category = QgsRendererCategory(class_value,symbol, label_text)
                    categories.append(category)
            mi_rend = QgsCategorizedSymbolRenderer('IntersectFeature', categories) 
            if mi_rend is not None:
                    layer.setRenderer(mi_rend)
            layer.triggerRepaint()
            
            
def writeLabels():
        for layer in QgsProject.instance().mapLayers().values():
            layer_settings  = QgsPalLayerSettings()
            text_format = QgsTextFormat()
            
            text_format.setSize(12)

            buffer_settings = QgsTextBufferSettings()
            buffer_settings.setEnabled(True)
            buffer_settings.setSize(0.10)
            buffer_settings.setColor(QtGui.QColor("black"))
                
            layer_settings.setFormat(text_format)

            layer_settings.fieldName = "SheetNo"
            layer_settings.placement = 4

            layer_settings.enabled = True

            layer_settings = QgsVectorLayerSimpleLabeling(layer_settings)
            layer.setLabelsEnabled(True)
            layer.setLabeling(layer_settings)
            layer.triggerRepaint()
            
            
def CheckIntersectionWithFeatures(inptLyr):
         # check intersection of selected layer feature with sheets
         fieldIdx=layer.dataProvider().fields().indexFromName('IntersectFeature')
         updateMap = {}
         count = inptLyr.featureCount()
         n=0
         for f in inptLyr.getFeatures():
             percent=n / float(count) * 100
             for a in layer.getFeatures():
                 if a.geometry().intersects(f.geometry()):
                     updateMap[a.id()] = { fieldIdx:1 }
                
                 iface.mainWindow().statusBar().showMessage("Processed {} %".format(int(percent)))
                 n=n+1
         layer.dataProvider().changeAttributeValues(updateMap)

def setScaleFactor(sheetType,sclid):
        sfx1={1:14400,2:3600,3:1800,4:900,5:450}
        sfx2={1:21600,2:3600,3:900,4:450,5:180,6:36} 
        if sheetType==1:
            fx=sfx1[sclid]
            # if sclid==1:
                # fx=14400
            # if sclid==2:
                # fx=3600
            # if sclid==3:
                # fx=1800
            # if sclid==4:
                # fx=900        
            # if sclid==5:
                # fx=450
            fy=fx     
        #sfx2={1:21600,2:3600,3:900,4:450,5:180,6:36} 
        if sheetType==2: 
            fx=sfx2[sclid]
            # if sclid==1:
                # fx=21600
                # fy=14400
            # if sclid==2:
                # fx=3600
            # if sclid==3:
                # fx=900
            # if sclid==4:
                # fx=450        
            # if sclid==5:
                # fx=180
            # if sclid==6:
                # fx=36
            if sclid==1:
                fy=14440
            else:
                fy=fx
        return fx,fy


class TopoNum:
    """QGIS Plugin Implementation."""
    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'TopoNum_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&SOI Toposheets Number Calculator')
        self.items = {1:['1:1M','1:250,000','1:125,000','1:50,000','1:25,000'],2:['1:1M','1:250,000','1:50,000','1:25,000']}
        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        #maptype=1
        self.first_start = None
        

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('TopoNum', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """
       
        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        icon_path = ':/plugins/TopoNum/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'SOI Toposheets Number Calculator'),
            callback=self.run,
            parent=self.iface.mainWindow())
        # will be set False in run()
        self.first_start = True
       
    
    def getVectorLayer(self):
        """Gets vector layer specified in combo box"""
        layer = None
        layername = self.dlg.cb_layer.currentText()
        for lyr in QgsProject.instance().mapLayers().values():
            if lyr.name() == layername:
                layer = lyr
                break
        return layer
            

    def load_vectors(self):
        layercount=0
        self.dlg.cb_layer.clear()
        layers = [layer for layer in QgsProject.instance().mapLayers().values()]
        vector_layers=[]
        for layer in layers:
           
            if layer.crs().authid() == 'EPSG:4326':
                vector_layers.append(layer.name())
                layercount=layercount+1
        self.dlg.cb_layer.addItems(vector_layers)
        return layercount
       

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&SOI Toposheets Number Calculator'),
                action)
            self.iface.removeToolBarIcon(action)
            
    def btnstate(self,b):
        global maptype
        global SheetIdByScale
        if b.text() == "Old - India and Adjoining Countries Series Maps":
            if b.isChecked() == True:
                maptype=1
                SheetIdByScale=['1M','250K','125K','50K','25K']
            else:
                maptype=2
                SheetIdByScale=['1M','250K','50K','25K']
        
        self.dlg.scaleComboBox.clear()
        self.dlg.scaleComboBox.addItems(self.items[maptype])
                
    def chkbxstate(self,b):
        global sheetsForLyrExt
        if b.isChecked() == True:
            sheetsForLyrExt=True
        else:
            sheetsForLyrExt=False
       
   
    def run(self):
        """Run method that performs all the real work"""
        global maptype
        global sheetsForLyrExt
        global SheetIdByScale
        global layer
        global poly
        total_vector_layers=0
       
        SheetIdByScale=['1M','250K','125K','50K','25K']
       
        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = TopoNumDialog()
            maptype=1
            sheetsForLyrExt=False
            self.dlg.scaleComboBox.addItems(self.items[maptype])
            self.dlg.radioButton_1.toggled.connect(lambda:self.btnstate(self.dlg.radioButton_1))
            self.dlg.radioButton_2.toggled.connect(lambda:self.btnstate(self.dlg.radioButton_2))
            self.dlg.cbUseLyrExt.stateChanged.connect(lambda:self.chkbxstate(self.dlg.cbUseLyrExt))
           
        # show the dialog
        self.dlg.show()
        total_vector_layers=self.load_vectors()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            global scaleID
            global sheetw
            global sheeth
            global inputLayer
            if total_vector_layers>0:
                scaleID=self.dlg.scaleComboBox.currentIndex()+1
                sheetw,sheeth=setScaleFactor(maptype,scaleID)
                inputLayer=self.getVectorLayer()
                slongs,elongs,slats,elats=CalculateExtentInTermsOfSheet(inputLayer)
                Xgrids=int(elongs-slongs)//sheetw # // is used for modular division
                Ygrids=int(elats-slats)//sheeth
             
                # Create a memory layer for Toposheet polygons
              
                layer = QgsVectorLayer("Polygon?crs=EPSG:4326",SheetIdByScale[scaleID-1]+ "_TopoSheets", "memory")
                layer.dataProvider().addAttributes([QgsField("id",QVariant.Int),QgsField("SheetNo",QVariant.String),QgsField("IntersectFeature",QVariant.String)])
                layer.updateFields()
              
                CalculateSheet(maptype,slats,slongs,Xgrids,Ygrids)
             
                CheckIntersectionWithFeatures(inputLayer)
             
                QgsProject.instance().addMapLayer(layer)
           
                if sheetsForLyrExt==False:
                    features = layer.getFeatures()
                    for feat in features:
                        attrs = feat.attributes()
                        if attrs[2]==0:
                            fid=attrs[0]
                            layer.dataProvider().deleteFeatures([fid+1])
                                
                                

                setSymbolForOutputLayer()
                writeLabels()
                result=False
                self.first_start = True
            else:
                self.dlg.cb_layer.clear()
                iface.messageBar().pushMessage("Error", "No layers loaded, Load layer with Geographic Corrdinates", level=Qgis.Critical)
            pass

