# -*- coding: utf-8 -*-

"""
***************************************************************************
*   Korto19 07.07.2022                                                                      *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""
from PyQt5.QtCore import *
from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProject,
                       QgsMapLayerType,
                       QgsProcessingParameterMultipleLayers,
                       QgsFields,
                       QgsField,
                       QgsFeature,
                       QgsFeatureRequest,
                       
                       QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingException,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink)
from qgis import processing
import datetime

#questo per l'icona dell'algoritmo di processing
import os
import inspect
from qgis.PyQt.QtGui import QIcon

class LayerFieldsDetailList(QgsProcessingAlgorithm):
    """
    This is an example algorithm that takes a vector layer and
    creates a new identical one.

    It is meant to be used as an example of how to create your own
    algorithms and explain methods and variables used to do it. An
    algorithm like this will be available in all elements, and there
    is not need for additional work.

    All Processing algorithms should extend the QgsProcessingAlgorithm
    class.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    INPUT = 'INPUT'
    OUTPUT = 'OUTPUT'

    def tr(self, string):
        """
        Returns a translatable string with the self.tr() function.
        """
        return QCoreApplication.translate('Processing', string)

    #icona dell'algoritmo di processing
    def icon(self):
        #cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        #icon = QIcon(os.path.join(os.path.join(cmd_folder, 'icon.png')))
        icon = QIcon(":images/themes/default/mSourceFields.svg")
        return icon
        
    def createInstance(self):
        return LayerFieldsDetailList()

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'LayerFieldsDetailList'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr('Layer Fields Detail List')

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return ''

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return ''

    def shortHelpString(self):
        """
        Returns a localised short helper string for the algorithm. This string
        should provide a basic description about what the algorithm does and the
        parameters and outputs associated with it..
        """
        header = '''
            <img src=":images/themes/default/mSourceFields.svg" width="50" height="50" style="float:right">
        '''
        return self.tr( header + "This algorithm create a temporary table with selected layer fields detail list \
                        \n Questo algoritmo crea una tabella temporanea con i dettagli dei campi dei layer selezionati")

    def initAlgorithm(self, config=None):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        # We add the input vector features source. It can have any kind of
        # geometry.
        self.addParameter(
            QgsProcessingParameterMultipleLayers(
                self.INPUT,
                self.tr('Select Layers for list'),
                layerType = QgsProcessing.TypeVectorAnyGeometry,
                defaultValue = None
            )
        )

        # We add a feature sink in which to store our processed features (this
        # usually takes the form of a newly created vector layer when the
        # algorithm is run in QGIS).
        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.OUTPUT,
                self.tr('Layer_Fields_Detail_ List ' + str(datetime.datetime.now().strftime("%d-%m-%Y %H:%M:%S")))
            )
        )

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """

        # Retrieve the feature source and sink. The 'dest_id' variable is used
        # to uniquely identify the feature sink, and must be included in the
        # dictionary returned by the processAlgorithm function.
        source = self.parameterAsLayerList(
            parameters,
            self.INPUT,
            context
        )
        #print(source[0].name())
        # If source was not found, throw an exception to indicate that the algorithm
        # encountered a fatal error. The exception text can be any string, but in this
        # case we use the pre-built invalidSourceError method to return a standard
        # helper text for when a source cannot be evaluated
        if source is None:
            raise QgsProcessingException(self.invalidSourceError(parameters, self.INPUT))
        
        fields = QgsFields()
        fields.append(QgsField("Layer_Name", QVariant.String))
        fields.append(QgsField("Layer_Crs", QVariant.String))
        fields.append(QgsField("Layer_Fields_Count", QVariant.Int))
        fields.append(QgsField("Layer_Field_Id", QVariant.Int))
        fields.append(QgsField("Field_Name", QVariant.String))
        fields.append(QgsField("Field_Type", QVariant.String))
        fields.append(QgsField("Field_Alias", QVariant.String))
        fields.append(QgsField("Field_Length", QVariant.Int))
        fields.append(QgsField("Field_Precision", QVariant.Int))
        fields.append(QgsField("Field_Comment", QVariant.String))
        fields.append(QgsField("Field_UniqueVal", QVariant.Int))
        fields.append(QgsField("Field_NullVal", QVariant.Int))
        fields.append(QgsField("Field_NotNullVal", QVariant.Int))

        
        (sink, dest_id) = self.parameterAsSink(
            parameters,
            self.OUTPUT,
            context, fields
        )
        
        # If sink was not created, throw an exception to indicate that the algorithm
        # encountered a fatal error. The exception text can be any string, but in this
        # case we use the pre-built invalidSinkError method to return a standard
        # helper text for when a sink cannot be evaluated
        if sink is None:
            raise QgsProcessingException(self.invalidSinkError(parameters, self.OUTPUT))
        
        f = QgsFeature()
        
        for lyr in source:
            if lyr.type() != QgsMapLayerType.RasterLayer:
                for lyr_field in lyr.fields():
                    
                    idx = lyr.fields().indexOf(lyr_field.name())
                    u_values = len(lyr.uniqueValues(idx))

                    expression = lyr_field.name() + ' is NULL'
                    request = QgsFeatureRequest().setFilterExpression(expression)
                    n_values = len(list(lyr.getFeatures(request)))
                    
                    expression = lyr_field.name() + ' is not NULL'
                    request = QgsFeatureRequest().setFilterExpression(expression)
                    nn_values = len(list(lyr.getFeatures(request)))

                    
                    f.setAttributes([lyr.name(),
                        lyr.crs().authid(),
                        lyr.fields().count(),
                        lyr.fields().indexFromName(lyr_field.name()),
                        lyr_field.name(),
                        lyr_field.displayType(),
                        lyr_field.alias(),
                        lyr_field.length(),
                        lyr_field.precision(),
                        lyr_field.comment(),
                        u_values,
                        n_values,
                        nn_values])
                    sink.addFeature(f, QgsFeatureSink.FastInsert)

        return {self.OUTPUT: dest_id}
