# タイル境界道路接続 (Tile Boundary Road Connector)

## 日本語
国土地理院ベクトルタイル等の道路ラインをフィーチャ化した際に発生しやすい「タイル境界での分断」を対象に、**近接する端点同士を検出してスナップし、接続性を回復**するQGISプラグインである。  
本プラグインは Processing ツールとして提供する。

### 使い方（推奨）
- 入力レイヤはメートル系CRS（例：EPSG:3857 など）を推奨する
- 探索許容距離：1〜3 m から試行する
- 角度許容差：0（無効）で開始し、誤接続がある場合に 15〜30°で絞る
- 属性一致（motorway, rdCtg 等）と lvOrder 一致を有効にすると誤接続を減らせる

### GEOS関連オプション
- makeValid：可能な範囲で入力ジオメトリを修復する
- GEOS変換不可はスキップ：GEOS演算に渡せないフィーチャを除外し、エラー出力（ポイント）に記録する

## English
This QGIS plugin restores connectivity of road lines that are split at tile boundaries (e.g., when vector tiles are converted to line features).  
It detects nearby endpoints and snaps them to reconnect the network. The tool is provided as a Processing algorithm.

### Recommended usage
- Use a projected CRS in meters (e.g., EPSG:3857)
- Tolerance: start with 1–3 m
- Angle tolerance: start with 0 (disabled); tighten to 15–30° if false connections occur
- Enabling attribute match (e.g., motorway, rdCtg) and lvOrder match reduces false connections

### GEOS options
- makeValid: attempts to repair invalid geometries when possible
- Skip GEOS failures: skips features that cannot be processed by GEOS operations and logs them to the issues point layer

## Author
GISPHN (Ryo Horiike) — ryo.horiike@naramed-u.ac.jp
