# -*- coding: utf-8 -*-

from qgis.PyQt import QtCore, QtGui, QtWidgets
from qgis.core import QgsProject, QgsApplication, QgsTask, QgsProcessing, QgsRasterLayer, QgsPointCloudLayer
from qgis import processing
from .picker import Param

import os, traceback
from functools import partial


class Patcher(QtCore.QObject):
    def __init__(self, plugin):
        super().__init__()
        self.plugin = plugin
        self.param = plugin.picker.param
        self.task_manager = QgsApplication.taskManager()
        self.tasks = {}
        self.idTask = 0
        
    def newId(self):
        self.idTask += 1
        return self.idTask    
        
    def launch(self):
        
        group = QgsProject.instance().layerTreeRoot().findGroup(self.param.get('groupName'))
        if not group:
            print("no group")
            return
        lst = list(map(lambda x: x.layer(), group.children()))
        lst_gdal, lst_pdal = [],[]
        for x in group.children():
            try: l = x.layer()
            except: continue
            if isinstance(l, QgsRasterLayer):
                lst_gdal.append(l)
            if isinstance(l, QgsPointCloudLayer):
                lst_pdal.append(l)
        if len(lst_gdal)>0:
            id = self.newId()
            self.tasks[id] = tpTask("Assemble raster", partial(self.run, 'gdal', lst_gdal))
            self.tasks[id].provider = 'gdal'
            self.tasks[id].executed.connect(self.end)
            self.task_manager.addTask(self.tasks[id])
        
        if len(lst_pdal)>0:
            id = self.newId()
            self.tasks[id] = tpTask("Assemble point cloud", partial(self.run, 'pdal', lst_pdal))
            self.tasks[id].provider = 'pdal'
            self.tasks[id].executed.connect(self.end)
            self.task_manager.addTask(self.tasks[id])
        
    def run(self, provider, lst):
        if provider=='gdal':
            alg_params = {
                'DATA_TYPE': 5,  # Float32
                'EXTRA': '',
                'INPUT': lst,
                'NODATA_INPUT': None,
                'NODATA_OUTPUT': None,
                'OPTIONS': '',
                'PCT': False,
                'SEPARATE': False,
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            alg = processing.run('gdal:merge', alg_params)
            return alg['OUTPUT']
        
        if provider=='pdal':
            alg_params = {
                'FILTER_EXPRESSION': '',
                'FILTER_EXTENT': None,
                'LAYERS': lst,
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            alg = processing.run('pdal:merge', alg_params)
            return alg['OUTPUT']
        
        
        
        # alg_params = {
            # 'INPUT': lst,
            # 'ADD_ALPHA': False,
            # 'ASSIGN_CRS': None,
            # 'EXTRA': '',
            # 'PROJ_DIFFERENCE': False,
            # 'RESAMPLING': 0,  
            # 'RESOLUTION': 0,  
            # 'SEPARATE': False,
            # 'SRC_NODATA': '',
            # 'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        # }
        # alg = processing.run('gdal:buildvirtualraster', alg_params)
        
        # alg_params = {
            # 'COPY_SUBDATASETS': False,
            # 'DATA_TYPE': 0,  # Utiliser le type de donnée de la couche en entrée
            # 'EXTRA': '',
            # 'INPUT': alg['OUTPUT'],
            # 'NODATA': None,
            # 'OPTIONS': '',
            # 'TARGET_CRS': None,
            # 'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        # }
        # alg = processing.run('gdal:translate', alg_params)
        


        # alg_params = {
            # 'LAYERS': lst,
            # 'BOUNDARY': False,
            # 'OVERVIEW': False,
            # 'STATISTICS': False,
            # 'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        # }
        # alg = processing.run('pdal:virtualpointcloud', alg_params)
        # return alg['OUTPUT']


    def end(self, ok, task):
        if ok:
            if task.provider=='gdal':
                try: self.plugin.iface.addRasterLayer(task.result, "Assemble", 'gdal')
                except: pass
            if task.provider=='pdal':
                try: self.plugin.iface.addPointCloudLayer(task.result, "Assemble", 'pdal')
                except:
                    try: self.plugin.iface.addPointCloudLayer(task.result, "Assemble", 'copc')
                    except: pass
            


        
class tpTask(QgsTask):
    executed = QtCore.pyqtSignal(bool, QtCore.QVariant)
    def __init__(self, name = "", function=None):
        super().__init__(name, QgsTask.CanCancel)
        self.function = function
        self.name = name
  
    def run(self):
        try:            
            if self.function:
                self.result = self.function()
            self.executed.emit(True, self)
            return True
        except Exception as e:
            self.error = traceback.format_exc()
            self.executed.emit(False, self)
            return False
    
    def cancel(self):
        super().cancel()
        
       