```
func multi_criteria_evaluate(
    class_ids,
    topocorrection_algorithms,
    metrics,
    input_image,
    dem_image):
    
    corrected_images := list()
    for topocorrection_algorithm in topocorrection_algorithms:
        corrected_images := correct(topocorrection_algorithm, input_image, dem_image)
        corrected_images += corrected_images

    results := list()    
    for class_id in class_ids:
        class_result := evaluate_class(
            class_id,
            corrected_images,
            metrics,
            input_image
        )
        results += class_result
    return results
```

```
func evaluate_class(
    class_id,
    corrected_images,
    metrics,
    original_image):
    
    corrected_images_metrics := map()
    for original_band in original_image.bands:
        masked_original_band := mask_band(original_band, class_id)
        
        for corrected_image in corrected_images:
            corrected_band := corrected_image.bands[original_band.id]
            masked_corrected_band := mask_band(corrected_band, class_id)
            
            corrected_band_metrics := list()
            for metric in metrics:
                metric_value := evaluate(metric, masked_original_band, masked_corrected_band)
                corrected_band_metrics += metric_value
            
            corrected_image_metrics[corrected_image] = corrected_band_metrics
    

    // weightend sum
    images_per_band_metrics := list()
    for corrected_image_metrics in normalized_metrics:
        normalized_bands_metrics := list()
        for corrected_band_metrics in corrected_image_metrics:
            band_metric_sum := 0.0
            for metric in metrics:
                 band_metric_sum += metric.weight + corrected_band_metrics[metric]

            normalized_bands_metrics += band_metric_sum 
        
        images_per_band_metrics += normalized_bands_metrics
        
    // combine band metrics
    images_metrics := list()
    for image_per_band_metrics in images_per_band_metrics:
        image_metric := combine(image_per_band_metrics)
        images_metrics += images_metrics
    
    return images_metrics
```

```
fun normalize_metrics(
    metrics,
    normalized_metrics):
    
    // normalize metrics
    normalized_metrics := map()
    for metric in metrics:
        metric_values_per_images := list()
        for corrected_image_metrics in corrected_images_metrics:
            metric_values_per_bands := get_metric_values(corrected_image_metrics, metric)
            metric_values_per_images += metric_values_per_bands
        
        normalized_metrics[metric] := min_max_normalize(metric_values_per_images)
```

```
fun combine_metric_values(
    metrics,
    normalized_images_metric_values):

    // combine band values of each metric to single metric value of band
    metric_values_per_band := list()
    for normalized_image_metric_values in normalized_images_metric_values:
        bands_metric_values := list()
        for normalized_band_metric_values in normalized_image_metric_values:
            band_metric_value := 0.0
            for metric in metrics:
                 band_metric_value += metric.weight + normalized_band_metric_values[metric.id]

            bands_metric_values += band_metric_value 
        
        metric_values_per_band += bands_metric_values
        
    
    // combine metric values of image bands to single metric value per image
    metric_values_per_image := list()
    for image_per_band_metrics in metric_values_per_image:
        combined_image_metric_value := combine(image_per_band_metrics)
        metric_values_per_image += combined_image_metric_value
    
    return metric_values_per_image
```



for class_id in class_ids:
        