set -euo pipefail

PLUGIN="TerraLink"
ROOT="$(cd "$(dirname "${BASH_SOURCE[0]}")/.." && pwd)"
cd "$ROOT"

META_PATH="$ROOT/metadata.txt"
if [ ! -f "$META_PATH" ]; then
  echo "ERROR: metadata.txt not found at repo root: $META_PATH"
  exit 1
fi

VER="$(python3 - <<PY
for line in open("metadata.txt", encoding="utf-8"):
    if line.lower().startswith("version="):
        print(line.split("=",1)[1].strip())
        break
else:
    raise SystemExit("version not found in metadata.txt")
PY
)"

OUTDIR="$HOME/Downloads/${PLUGIN}_v${VER}"
ZIP="$OUTDIR/${PLUGIN}.zip"
STAGE="$(mktemp -d)"

mkdir -p "$OUTDIR"

rsync -a --delete \
  --exclude ".git" \
  --exclude ".gitignore" \
  --exclude "__pycache__" \
  --exclude "*.pyc" \
  --exclude "__MACOSX" \
  --exclude ".DS_Store" \
  --exclude "scripts" \
  "$ROOT/" "$STAGE/${PLUGIN}/"

FORBIDDEN_REGEX='(^|/)(\.git(/|$)|\.gitignore$|__pycache__(/|$)|.*\.pyc$|__MACOSX(/|$)|\.DS_Store$)'

if find "$STAGE/${PLUGIN}" -print | grep -E "$FORBIDDEN_REGEX" >/dev/null; then
  echo "ERROR: Forbidden files detected in staged package. Aborting."
  find "$STAGE/${PLUGIN}" -print | grep -E "$FORBIDDEN_REGEX"
  exit 1
fi

(cd "$STAGE" && zip -r "$ZIP" "$PLUGIN" >/dev/null)

if unzip -l "$ZIP" | grep -E "$FORBIDDEN_REGEX" >/dev/null; then
  echo "ERROR: Forbidden files detected inside ZIP. Aborting."
  unzip -l "$ZIP" | grep -E "$FORBIDDEN_REGEX"
  exit 1
fi

rm -rf "$STAGE"
echo "OK: Created clean package at $ZIP"
