# -*- coding: utf-8 -*-

"""
/***************************************************************************
 TAFtoCSV
                                 A QGIS plugin
 Converte file TAF in CSV
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-05-20
        copyright            : (C) 2021 by Giulio Fattori
        email                : giulio.fattori@tin.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Giulio Fattori'
__date__ = '2021-05-20'
__copyright__ = '(C) 2021 by Giulio Fattori'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from PyQt5.QtCore import QCoreApplication, QVariant
from qgis.core import (QgsVectorLayer,
                       QgsProcessing,
                       QgsProcessingParameterField,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFile,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFileDestination)
import re
import subprocess			 

#assegnazione dei nomi delle colonne
taf_col_name = ['TAF_ROW','Cod_Belf','Sez','Foglio','All','Fiduciale','Particella','Monografia',
                'Nord','Est','Attend','Foglio_Orig','All_Fg_Orig','Fiduc_Orig',
                'Data_Agg','Causale_Agg','Monogr_Alt','Attend_Alt','Quota']
#creazione matrice decodifica                
taf_trc_split = [['Cod_Belf',4],['Sez',1],['Foglio',4],['All',1],['Fiduciale',4],
                ['Particella',11],['Monografia',70],['Nord',12],['Est',12],['Attend',2],
                ['Foglio_Orig',4],['All_Fg_Orig',1],['Fiduc_Orig',4],['Data_Agg',6],
                ['Causale_Agg',15],['Monogr_Alt',70],['Attend_Alt',2],['Quota',12]]

#questo per l'icona dell'algoritmo di processing
import os
import inspect
from qgis.PyQt.QtGui import QIcon

class TAFtoCSVAlgorithm(QgsProcessingAlgorithm):
    """
    Saves the attributes of a TAF file to a CSV file
    """
    
    INPUT  = 'INPUT'
    OUTPUT = 'OUTPUT'
    SELEZ  = 'SELEZ'
    
    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return TAFtoCSVAlgorithm()
    
    def name(self):
        return 'TAF to csv'

    def displayName(self):
        return self.tr('TAF to CSV')
    
    #icona dell'algoritmo di processing
    def icon(self):
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'ae.png')))
        return icon

    def group(self):
        return self.tr('')

    def groupId(self):
        return ''

    def shortHelpString(self):
        """
        Returns a localised short helper string for the algorithm. This string
        should provide a basic description about what the algorithm does and the
        parameters and outputs associated with it..
        """
        return self.tr("Converte una Tabella attuale dei punti fiduciali (Taf) dell' Agenzia delle Entrate\
                        in un file csv aggiungendo le opportune intestazioni\n\
                        <mark style='color:blue'><strong>OPZIONI</strong></mark>\n\
                        <mark style='color:black'>Possibile selezione dei campi nell'apposito menu'"
                    )

    def initAlgorithm(self, config=None):

        self.addParameter(
            QgsProcessingParameterFile(
                self.INPUT,
                'Input TAF file',
                behavior=QgsProcessingParameterFile.File, fileFilter='TAF Files (*.taf)'
            )
        )

        self.addParameter(
            QgsProcessingParameterField(
                self.SELEZ,
                self.tr('Selezionare i campi desiderati'),
                allowMultiple = True,
                defaultValue = taf_col_name,
                parentLayerParameterName = None
            )
        )

        # We add a file output of type CSV.
        self.addParameter(
            QgsProcessingParameterFileDestination(
                self.OUTPUT,
                self.tr('Output CSV file'),
                'TAF files (*.csv)'
            )
        )

    def processAlgorithm(self, parameters, context, feedback):

        def copy2clip(txt):
            cmd='echo '+ txt + '|clip'
            return subprocess.check_call(cmd, shell=True)

        taf_file = self.parameterAsFile(parameters, self.INPUT, context)
        csv      = self.parameterAsFileOutput(parameters, self.OUTPUT, context)
        selez    = self.parameterAsMatrix(parameters, self.SELEZ, context)
         
        #collect selected fields
        var_constr_split = '^'
        for elem in taf_trc_split:
            if elem[0] in selez:
                var_constr_split = var_constr_split + "(.{" + str(elem[1]) + "}).{1}"
            else:
                var_constr_split = var_constr_split + ".{" + str(elem[1]) + "}.{1}"
            if 'Cod_Belf' in elem[0]:
                var_constr_split = var_constr_split[0:len(var_constr_split)-4]

        var_constr_split = var_constr_split[0:len(var_constr_split)-4] + '$'
  
        open_taf = open(taf_file, 'r', errors = 'ignore')
        taf_lines = open_taf.readlines()
              
        # Compute the number of steps to display within the progress bar and
        # get lines number from source
        total = 100.0 / len(taf_lines) if len(taf_lines) else 0

        #set line counter
        count = 0

        with open(csv, 'w') as output_file:
            # write csv header
            line = ','.join(col_name for col_name in selez) + '\n'
            output_file.write(line)
            
            # Strips an save for newline character
            for line in taf_lines:
                
                count += 1
                taf_line_split = re.split(var_constr_split, line)

                # Stop the algorithm if cancel button has been clicked
                if feedback.isCanceled():
                    break

                # Add a feature in the sink
                line = str(count) + ','.join((col_x.strip()).replace(",","-") for col_x in taf_line_split) + '\n'
                output_file.write(line)

                # Update the progress bar
                feedback.setProgress(int(count * total))
        
        open_taf.close()
        
        feedback.pushInfo("Elaborati " + str(count) + " records")
        copy2clip(csv)

        return {self.OUTPUT: csv}