# 🧭 SwipeMaster — Advanced Swipe Tool for QGIS

**SwipeMaster** is an advanced QGIS plugin that allows users to **interactively compare two map layers** by smoothly swiping one over another.  
It provides a beautiful floating control panel, customizable swipe direction, and advanced control over line color, thickness, and opacity.

---

## ✨ Key Features

- 🔄 **Real-time layer swiping** — interactively compare layers with a draggable swipe line  
- 🧭 **Four swipe directions** — Right, Left, Top, and Bottom  
- 🎨 **Customizable visuals** — adjust line color, opacity, and thickness  
- 🌫️ **Layer transparency control** — define opacity for the hidden layer area  
- 🪟 **Floating control panel** — always-on-top, movable, compact, and modern UI  
- 🧰 **Easy activation/deactivation** — one-click start/stop button  
- 🧠 **Automatic layer detection** — lists all loaded layers for quick selection  

---

## 🖥️ Interface Overview

The plugin opens a compact floating panel that includes:

| Control | Description |
|----------|--------------|
| 🗺️ Layer Selector | Choose the layer to apply swipe on |
| ↔️ Direction | Select swipe direction (Right, Left, Top, Bottom) |
| 🎨 Color | Choose swipe line color |
| 📏 Thickness | Choose swipe line width (1–10 px) |
| 💧 Line Opacity | Adjust line transparency (0–100%) |
| 🌫️ Layer Opacity | Adjust hidden layer opacity |
| ▶️ Start | Activate the swipe tool |
| ❌ Close | Deactivate and close panel |
| ⏸️ Status | Shows current tool state |

---

## 📸 Preview

*(Add your screenshot or demo GIF here — e.g. `swipemaster.png`)*

---

## ⚙️ Installation

### Option 1 — Manual Installation
1. Download or clone this repository:
   ```bash
git clone https://github.com/MostafaShiyari/SwipeMaster.git
