# StreetSmart QGIS Plugin - Release Notes

## Version v3.2.6.120.2 (May 2025)

### Breaking Changes
- Python version compatibility is now strictly limited to Python 3.6, 3.9, and 3.12
- Users on unsupported Python versions will need to switch to a compatible QGIS version


### New Features
- **Updated StreetSmart APi version 24.13**
  - Fixes a bug in the messages that are displaying while doing a measurement in oblique
  - Fix a bug that was preventing VIEWER_REMOVED event to be triggered when close a viewer
  - We now support WFS 2.0.0
  - CrossSection points can be dragged to change position
  - Address Labels layer added for Belgium configuration


- **Automatic Attribute Form Display**
  - After creating a feature, attribute form now automatically appears
  - Can be enabled/disabled through plugin settings
  - User preferences are preserved between sessions

- **Enhanced Projection System Validation**
  - Added automatic checks for projection mismatches between project and layers
  - Warning messages with clear guidance when inconsistencies are detected
  - Option to proceed despite projection differences

### Improvements
- **Python Version Management**
  - Added version compatibility checking
  - Clear warning messages for unsupported versions
  - Automatic detection of QGIS Python environment

- **CEFPython Integration**
  - Improved installation process
  - Automatic version selection based on Python version
  - Better error handling during installation
  - Support for offline installation scenarios

- **DLL Management**
  - Automatic detection of missing DLLs
  - Automated copying of required DLLs from QGIS bin directory
  - User notifications for DLL-related actions

### Bug Fixes
- Fixed feature creation issues in mixed projection environments
- Resolved DLL loading errors in certain QGIS configurations
- Improved error handling during CEFPython installation
- Fixed attribute form display in specific layer types

### Technical Requirements
- QGIS 3.20 to 3.40.4 LTS
- Python 3.6, 3.9, or 3.12
- Windows operating system

### Installation Notes
1. Backup your existing plugin configuration before upgrading
2. Uninstall previous version
3. Install new version through QGIS Plugin Manager
4. Restart QGIS after installation

### Known Issues
- Some features may require specific QGIS versions
- Projection transformations might affect measurement accuracy
- Manual DLL copying may be required in certain environments

### Deprecations
- Support for Python versions other than 3.6, 3.9, and 3.12 has been removed
- Legacy projection handling methods are deprecated

### Bugs

- Fixed toggle compass button
- Fixed an issue where some ImageId's could not be opened through an API call
- Fixed a bug that wrongly changed the color of a height measurement
- Fixed a bug where some buttons were not visible/functional After a UI update

For detailed documentation and support, please visit our documentation page or contact support.

---
**Note**: This release includes significant changes to Python version compatibility. Please ensure your QGIS installation meets the requirements before upgrading.