# -*- coding: utf-8 -*-

# Form implementation generated from reading ui file '.\src\ui-paramWindow.ui'
#
# Created by: PyQt5 UI code generator 5.15.1
#
# WARNING: Any manual changes made to this file will be lost when pyuic5 is
# run again.  Do not edit this file unless you know what you are doing.


from qgis.PyQt import QtCore, QtGui, QtWidgets
import json, sys, os
from .ui_graphicsWindow import Ui_graphicsWindow 


class Ui_editParamWindow(object):
    def setupUi(self, editParamWindow):
        editParamWindow.setObjectName("editParamWindow")
        editParamWindow.resize(428, 402)
        self.centralwidget = QtWidgets.QWidget(editParamWindow)
        self.centralwidget.setObjectName("centralwidget")
        self.groupBoxPen = QtWidgets.QGroupBox(self.centralwidget)
        self.groupBoxPen.setGeometry(QtCore.QRect(210, 20, 181, 161))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.groupBoxPen.setFont(font)
        self.groupBoxPen.setObjectName("groupBoxPen")
        self.comboBoxColor = QtWidgets.QComboBox(self.groupBoxPen)
        self.comboBoxColor.setGeometry(QtCore.QRect(100, 30, 69, 22))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.comboBoxColor.setFont(font)
        self.comboBoxColor.setObjectName("comboBoxColor")
        self.comboBoxColor.addItem("")
        self.comboBoxColor.addItem("")
        self.comboBoxColor.addItem("")
        self.comboBoxColor.addItem("")
        self.comboBoxColor.addItem("")
        self.comboBoxColor.addItem("")
        self.spinBoxPenWidth = QtWidgets.QSpinBox(self.groupBoxPen)
        self.spinBoxPenWidth.setGeometry(QtCore.QRect(130, 60, 42, 22))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.spinBoxPenWidth.setFont(font)
        self.spinBoxPenWidth.setMinimum(1)
        self.spinBoxPenWidth.setMaximum(15)
        self.spinBoxPenWidth.setProperty("value", 4)
        self.spinBoxPenWidth.setObjectName("spinBoxPenWidth")
        self.label_3 = QtWidgets.QLabel(self.groupBoxPen)
        self.label_3.setGeometry(QtCore.QRect(20, 30, 51, 16))
        self.label_3.setObjectName("label_3")
        self.label_5 = QtWidgets.QLabel(self.groupBoxPen)
        self.label_5.setGeometry(QtCore.QRect(20, 60, 101, 16))
        self.label_5.setObjectName("label_5")
        self.label = QtWidgets.QLabel(self.groupBoxPen)
        self.label.setEnabled(False)
        self.label.setGeometry(QtCore.QRect(20, 90, 101, 16))
        self.label.setObjectName("label")
        self.spinBoxAltitude = QtWidgets.QSpinBox(self.groupBoxPen)
        self.spinBoxAltitude.setEnabled(False)
        self.spinBoxAltitude.setGeometry(QtCore.QRect(130, 90, 42, 22))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.spinBoxAltitude.setFont(font)
        self.spinBoxAltitude.setSingleStep(5)
        self.spinBoxAltitude.setObjectName("spinBoxAltitude")
        self.radioButtonMerge = QtWidgets.QRadioButton(self.groupBoxPen)
        self.radioButtonMerge.setEnabled(False)
        self.radioButtonMerge.setGeometry(QtCore.QRect(20, 120, 121, 17))
        font = QtGui.QFont()
        font.setPointSize(8)
        font.setBold(True)
        font.setWeight(75)
        self.radioButtonMerge.setFont(font)
        self.radioButtonMerge.setChecked(True)
        self.radioButtonMerge.setObjectName("radioButtonMerge")
        self.radioButtonAuto = QtWidgets.QRadioButton(self.groupBoxPen)
        self.radioButtonAuto.setEnabled(False)
        self.radioButtonAuto.setGeometry(QtCore.QRect(20, 140, 131, 17))
        font = QtGui.QFont()
        font.setPointSize(8)
        font.setBold(True)
        font.setWeight(75)
        self.radioButtonAuto.setFont(font)
        self.radioButtonAuto.setObjectName("radioButtonAuto")
        self.groupBoxScreen = QtWidgets.QGroupBox(self.centralwidget)
        self.groupBoxScreen.setGeometry(QtCore.QRect(30, 40, 171, 121))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.groupBoxScreen.setFont(font)
        self.groupBoxScreen.setObjectName("groupBoxScreen")
        self.label_8 = QtWidgets.QLabel(self.groupBoxScreen)
        self.label_8.setGeometry(QtCore.QRect(20, 30, 51, 16))
        self.label_8.setObjectName("label_8")
        self.label_9 = QtWidgets.QLabel(self.groupBoxScreen)
        self.label_9.setGeometry(QtCore.QRect(20, 60, 47, 13))
        self.label_9.setObjectName("label_9")
        self.spinBoxScreenLeft = QtWidgets.QSpinBox(self.groupBoxScreen)
        self.spinBoxScreenLeft.setGeometry(QtCore.QRect(70, 30, 42, 22))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.spinBoxScreenLeft.setFont(font)
        self.spinBoxScreenLeft.setMaximum(10)
        self.spinBoxScreenLeft.setObjectName("spinBoxScreenLeft")
        self.spinBoxScreenRight = QtWidgets.QSpinBox(self.groupBoxScreen)
        self.spinBoxScreenRight.setGeometry(QtCore.QRect(70, 60, 42, 22))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.spinBoxScreenRight.setFont(font)
        self.spinBoxScreenRight.setMaximum(10)
        self.spinBoxScreenRight.setObjectName("spinBoxScreenRight")
        self.pushButtonShow = QtWidgets.QPushButton(self.groupBoxScreen)
        self.pushButtonShow.setGeometry(QtCore.QRect(120, 40, 41, 23))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.pushButtonShow.setFont(font)
        self.pushButtonShow.setCheckable(True)
        self.pushButtonShow.setObjectName("pushButtonShow")
        self.checkBoxFlip = QtWidgets.QCheckBox(self.groupBoxScreen)
        self.checkBoxFlip.setGeometry(QtCore.QRect(20, 90, 141, 20))
        self.checkBoxFlip.setObjectName("checkBoxFlip")
        self.groupBox = QtWidgets.QGroupBox(self.centralwidget)
        self.groupBox.setGeometry(QtCore.QRect(30, 190, 341, 121))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.groupBox.setFont(font)
        self.groupBox.setObjectName("groupBox")
        self.lineEditZoom = QtWidgets.QLineEdit(self.groupBox)
        self.lineEditZoom.setGeometry(QtCore.QRect(180, 30, 61, 20))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.lineEditZoom.setFont(font)
        self.lineEditZoom.setReadOnly(True)
        self.lineEditZoom.setObjectName("lineEditZoom")
        self.lineEditMoveLong = QtWidgets.QLineEdit(self.groupBox)
        self.lineEditMoveLong.setGeometry(QtCore.QRect(180, 60, 61, 20))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.lineEditMoveLong.setFont(font)
        self.lineEditMoveLong.setReadOnly(True)
        self.lineEditMoveLong.setObjectName("lineEditMoveLong")
        self.lineEditDrawCut = QtWidgets.QLineEdit(self.groupBox)
        self.lineEditDrawCut.setGeometry(QtCore.QRect(180, 90, 61, 20))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.lineEditDrawCut.setFont(font)
        self.lineEditDrawCut.setReadOnly(True)
        self.lineEditDrawCut.setObjectName("lineEditDrawCut")
        self.label_2 = QtWidgets.QLabel(self.groupBox)
        self.label_2.setGeometry(QtCore.QRect(10, 30, 47, 13))
        self.label_2.setObjectName("label_2")
        self.label_4 = QtWidgets.QLabel(self.groupBox)
        self.label_4.setGeometry(QtCore.QRect(10, 60, 151, 16))
        self.label_4.setObjectName("label_4")
        self.label_11 = QtWidgets.QLabel(self.groupBox)
        self.label_11.setGeometry(QtCore.QRect(10, 90, 171, 16))
        self.label_11.setObjectName("label_11")
        self.toolButtonEditZoom = QtWidgets.QToolButton(self.groupBox)
        self.toolButtonEditZoom.setGeometry(QtCore.QRect(260, 30, 51, 19))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.toolButtonEditZoom.setFont(font)
        self.toolButtonEditZoom.setCheckable(True)
        self.toolButtonEditZoom.setObjectName("toolButtonEditZoom")
        self.toolButtonEditLong = QtWidgets.QToolButton(self.groupBox)
        self.toolButtonEditLong.setGeometry(QtCore.QRect(260, 60, 51, 19))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.toolButtonEditLong.setFont(font)
        self.toolButtonEditLong.setCheckable(True)
        self.toolButtonEditLong.setObjectName("toolButtonEditLong")
        self.toolButtonDrawCut = QtWidgets.QToolButton(self.groupBox)
        self.toolButtonDrawCut.setGeometry(QtCore.QRect(260, 90, 51, 19))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.toolButtonDrawCut.setFont(font)
        self.toolButtonDrawCut.setCheckable(True)
        self.toolButtonDrawCut.setObjectName("toolButtonDrawCut")
        self.pushButtonCancel = QtWidgets.QPushButton(self.centralwidget)
        self.pushButtonCancel.setGeometry(QtCore.QRect(320, 320, 75, 23))
        self.pushButtonCancel.setObjectName("pushButtonCancel")
        self.pushButtonAccept = QtWidgets.QPushButton(self.centralwidget)
        self.pushButtonAccept.setGeometry(QtCore.QRect(240, 320, 75, 23))
        self.pushButtonAccept.setObjectName("pushButtonAccept")
        editParamWindow.setCentralWidget(self.centralwidget)
        self.menubar = QtWidgets.QMenuBar(editParamWindow)
        self.menubar.setGeometry(QtCore.QRect(0, 0, 428, 21))
        self.menubar.setObjectName("menubar")
        editParamWindow.setMenuBar(self.menubar)
        self.statusbar = QtWidgets.QStatusBar(editParamWindow)
        self.statusbar.setObjectName("statusbar")
        editParamWindow.setStatusBar(self.statusbar)

        self.retranslateUi(editParamWindow)
        QtCore.QMetaObject.connectSlotsByName(editParamWindow)

    def retranslateUi(self, editParamWindow):
        _translate = QtCore.QCoreApplication.translate
        editParamWindow.setWindowTitle(_translate("editParamWindow", "Modification des paramètres"))
        self.groupBoxPen.setTitle(_translate("editParamWindow", "Paramètres du dessin"))
        self.comboBoxColor.setAccessibleName(_translate("editParamWindow", "Color"))
        self.comboBoxColor.setItemText(0, _translate("editParamWindow", "Cyan"))
        self.comboBoxColor.setItemText(1, _translate("editParamWindow", "Blue"))
        self.comboBoxColor.setItemText(2, _translate("editParamWindow", "Red"))
        self.comboBoxColor.setItemText(3, _translate("editParamWindow", "Magenta"))
        self.comboBoxColor.setItemText(4, _translate("editParamWindow", "Yellow"))
        self.comboBoxColor.setItemText(5, _translate("editParamWindow", "Black"))
        self.spinBoxPenWidth.setAccessibleName(_translate("editParamWindow", "PenWidth"))
        self.label_3.setText(_translate("editParamWindow", "Couleur :"))
        self.label_5.setText(_translate("editParamWindow", "Taille des traits :"))
        self.label.setText(_translate("editParamWindow", "Altitude ajoutée :"))
        self.spinBoxAltitude.setAccessibleName(_translate("editParamWindow", "AddAltitude"))
        self.radioButtonMerge.setText(_translate("editParamWindow", "Merge Polygon"))
        self.radioButtonAuto.setText(_translate("editParamWindow", "Automatic Polygon "))
        self.groupBoxScreen.setTitle(_translate("editParamWindow", "Choix des écrans"))
        self.label_8.setText(_translate("editParamWindow", "Bas : "))
        self.label_9.setText(_translate("editParamWindow", "Haut : "))
        self.spinBoxScreenLeft.setAccessibleName(_translate("editParamWindow", "ScreenLeft"))
        self.spinBoxScreenRight.setAccessibleName(_translate("editParamWindow", "ScreenRight"))
        self.pushButtonShow.setText(_translate("editParamWindow", "Show"))
        self.checkBoxFlip.setAccessibleName(_translate("editParamWindow", "Flip"))
        self.checkBoxFlip.setText(_translate("editParamWindow", "Retirer l\'effet miroir"))
        self.groupBox.setTitle(_translate("editParamWindow", "Raccourcis clavier"))
        self.lineEditZoom.setAccessibleName(_translate("editParamWindow", "BindZoom"))
        self.lineEditZoom.setText(_translate("editParamWindow", "CTRL"))
        self.lineEditMoveLong.setAccessibleName(_translate("editParamWindow", "BindLong"))
        self.lineEditMoveLong.setText(_translate("editParamWindow", "SHIFT"))
        self.lineEditDrawCut.setAccessibleName(_translate("editParamWindow", "BindDraw"))
        self.lineEditDrawCut.setText(_translate("editParamWindow", "1"))
        self.label_2.setText(_translate("editParamWindow", "Zoom :"))
        self.label_4.setText(_translate("editParamWindow", "Déplacement Longitude :"))
        self.label_11.setText(_translate("editParamWindow", "Changer Dessiner/Découper :"))
        self.toolButtonEditZoom.setText(_translate("editParamWindow", "Modifier"))
        self.toolButtonEditLong.setText(_translate("editParamWindow", "Modifier"))
        self.toolButtonDrawCut.setText(_translate("editParamWindow", "Modifier"))
        self.pushButtonCancel.setText(_translate("editParamWindow", "Annuler"))
        self.pushButtonAccept.setText(_translate("editParamWindow", "OK"))

        
class paramWindow(QtWidgets.QMainWindow):
    def __init__(self) :
        QtWidgets.QMainWindow.__init__(self)
        self.ui = Ui_editParamWindow()
        self.ui.setupUi(self)
        self.paramList = {}
        self.listGraphWinObj = []
        for item in dir(self.ui) :
            attr = getattr(self.ui, item)
            try : 
                paramName = attr.accessibleName() 
                if paramName :
                    self.paramList[paramName] = attr 
            except : pass

        self.JSONPath = os.path.join(os.path.dirname(os.path.realpath(__file__)),'paramStoring.json')
        self.currentNoValidKey = []
        self.setFromJSON()
        self.ui.pushButtonAccept.clicked.connect(self.acceptClickAction)
        self.ui.pushButtonCancel.clicked.connect(self.cancelClickAction)
        self.ui.toolButtonEditZoom.toggled.connect(lambda: self.editKeyToggle(True,self.ui.toolButtonEditZoom, self.ui.lineEditZoom, 'BindZoom'))
        self.ui.toolButtonEditLong.toggled.connect(lambda: self.editKeyToggle(True,self.ui.toolButtonEditLong, self.ui.lineEditMoveLong, 'BindLong'))
        self.ui.toolButtonDrawCut.toggled.connect(lambda: self.editKeyToggle(True,self.ui.toolButtonDrawCut, self.ui.lineEditDrawCut, 'BindDraw'))

        self.ui.pushButtonShow.toggled.connect(self.actionShowScreenNumber)
        #self.ui.pushButtonShow.released.connect(self.releaseShowScreenNumber)

    def setFromJSON(self):
        with open(self.JSONPath) as f : 
            dictParam = json.load(f)
            
        for key, value in self.paramList.items() :
            if type(value) == QtWidgets.QLineEdit :
                if int(dictParam[key]) == QtCore.Qt.Key_Control:
                    value.setText('Ctrl')
                elif int(dictParam[key]) == QtCore.Qt.Key_Shift :
                    value.setText('Shift')
                else :
                    keyboard = int(dictParam[key])
                    value.setText(QtGui.QKeySequence(keyboard).toString())
                self.currentNoValidKey.append(int(dictParam[key]))
            elif type(value) == QtWidgets.QSpinBox :
                value.setValue(int(dictParam[key]))
            elif type(value) == QtWidgets.QComboBox :
                value.setCurrentText(dictParam[key])
            elif type(value) == QtWidgets.QCheckBox : 
                value.setCheckState(int(dictParam[key]))
        
        self.currentDictParam = dictParam
    
    def saveToJSON(self) :
        JSON2Save = {}
        for key, value in self.paramList.items() :
            if type(value) == QtWidgets.QLineEdit :
                if value.text() == 'Ctrl' :
                    JSON2Save[key] = str(QtCore.Qt.Key_Control)
                elif value.text() == 'Shift' :
                    JSON2Save[key] = str(QtCore.Qt.Key_Shift)
                else :
                    keyID = QtGui.QKeySequence().fromString(value.text())
                    JSON2Save[key] = str(keyID[0])
            
            elif type(value) == QtWidgets.QSpinBox :
                JSON2Save[key] = str(value.value())
            elif type(value) == QtWidgets.QComboBox :
                JSON2Save[key] = value.currentText()
            elif type(value) == QtWidgets.QCheckBox: 
                JSON2Save[key] = str(value.checkState())   

        for outParam in ['LastPath','LastName','LastX','LastY','LastZ','ScaleX','ScaleY','MNTPath'] : 
            JSON2Save[outParam] = self.currentDictParam[outParam]
        with open(self.JSONPath, 'w') as f : 
            json.dump(JSON2Save, f)
        self.currentDictParam = JSON2Save        


    def acceptClickAction(self):
        self.saveToJSON()
        self.cancelClickAction()
    
    def cancelClickAction(self):
        self.ui.pushButtonShow.setChecked(False)
        #self.actionShowScreenNumber(0)
        self.close()
    
    def editKeyToggle(self, status, toolButton, lineEdit, name):
        if status :
            self.currentToolButton = toolButton
            self.currentLineEdit = lineEdit
            self.currentName = name
            self.grabKeyboard()
            self.keyPressEvent = self.keybingPressEvent

    def keybingPressEvent(self, event):
        nonValid = self.currentNoValidKey + [QtCore.Qt.Key_Alt, QtCore.Qt.Key_Escape]
        if event.key() in nonValid : 
            self.currentToolButton.setChecked(False)
            return
        
        elif event.key() == QtCore.Qt.Key_Control : self.currentLineEdit.setText('Ctrl')
        elif event.key() == QtCore.Qt.Key_Shift : self.currentLineEdit.setText('Shift')
        else : self.currentLineEdit.setText(QtGui.QKeySequence(event.key()).toString())

        self.currentNoValidKey.remove(int(self.currentDictParam[self.currentName]))
        self.currentNoValidKey.append(event.key())
        self.currentToolButton.setChecked(False)
        self.releaseKeyboard()
        self.keyPressEvent = QtWidgets.QMainWindow.keyPressEvent

    def actionShowScreenNumber(self,val) :
        if val > 0 : 
            self.listGraphWinObj = []
            for i in range(QtWidgets.QApplication.desktop().screenCount()) :

                screenGeo = QtWidgets.QApplication.desktop().screenGeometry(i)
                center = (int(screenGeo.width()/2), int(screenGeo.height()/2))
                #rect = QtCore.QRect(center[0]-50,center[1]-50,center[0]+50,center[1]+50)
                rect = QtCore.QRect(0,0,125,175)
                graphWin = graphicsWindow("Numéro de l'écran")
                graphWin.resize(125,175)
                graphWin.ui.graphicsView.setGeometry(rect)
                graphWin.move(QtCore.QPoint(screenGeo.x()+center[0]-50,screenGeo.y()+center[1]-50))                
                
                
                scene = QtWidgets.QGraphicsScene()
                font = QtGui.QFont('Times',80)
                rect = QtCore.QRectF(0,0,125,175)
                scene.setSceneRect(rect)
                scene.addText(str(i),font) 
                graphWin.ui.graphicsView.setScene(scene)
                
                graphWin.ui.graphicsView.show()
                graphWin.show()
                
                self.listGraphWinObj.append(graphWin)
            


    #def releaseShowScreenNumber(self) : 
        else :
            for graphWin in self.listGraphWinObj :
                graphWin.close()
        
class graphicsWindow(QtWidgets.QMainWindow): 
    def __init__(self, nom):
        QtWidgets.QMainWindow.__init__(self)
        self.ui = Ui_graphicsWindow()
        self.ui.setupUi(self, nom)


if __name__ == "__main__":
    app = QtWidgets.QApplication(sys.argv)
    b = paramWindow()
    b.show()
    sys.exit(app.exec_())