# -*- coding: utf-8 -*-

# Form implementation generated from reading ui file '.\src\ui-optionWindow.ui'
#
# Created by: PyQt5 UI code generator 5.15.1
#
# WARNING: Any manual changes made to this file will be lost when pyuic5 is
# run again.  Do not edit this file unless you know what you are doing.

from qgis.PyQt import QtCore, QtGui, QtWidgets
from qgis.PyQt.QtCore import pyqtSignal
import os
from qgis.utils import iface
from qgis.core import QgsMapLayerType, QgsWkbTypes
from . import resources
from .ui_getVectorLayer import getVectorLayerCustomList

class Ui_StereoDockWidget(object):
    def setupUi(self, StereoDockWidget):
        StereoDockWidget.setObjectName("StereoDockWidget")
        StereoDockWidget.resize(434, 305)
        StereoDockWidget.setMinimumSize(QtCore.QSize(165, 300))
        self.dockWidgetContents = QtWidgets.QWidget()
        self.dockWidgetContents.setObjectName("dockWidgetContents")
        self.groupBoxMainPath = dropedit(self.dockWidgetContents)
        self.groupBoxMainPath.setGeometry(QtCore.QRect(20, 10, 401, 51))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.groupBoxMainPath.setFont(font)
        self.groupBoxMainPath.setObjectName("groupBoxMainPath")
        self.importLineProject = QtWidgets.QLineEdit(self.groupBoxMainPath)
        self.importLineProject.setGeometry(QtCore.QRect(40, 20, 311, 20))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.importLineProject.setFont(font)
        self.importLineProject.setText("")
        self.importLineProject.setReadOnly(True)
        self.importLineProject.setObjectName("importLineProject")
        self.importToolProject = QtWidgets.QToolButton(self.groupBoxMainPath)
        self.importToolProject.setGeometry(QtCore.QRect(350, 20, 25, 19))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.importToolProject.setFont(font)
        self.importToolProject.setObjectName("importToolProject")
        self.pushButtonShowIDList = QtWidgets.QPushButton(self.dockWidgetContents)
        self.pushButtonShowIDList.setEnabled(False)
        self.pushButtonShowIDList.setGeometry(QtCore.QRect(290, 100, 101, 23))
        self.pushButtonShowIDList.setObjectName("pushButtonShowIDList")
        self.enhanceButton = QtWidgets.QPushButton(self.dockWidgetContents)
        self.enhanceButton.setEnabled(False)
        self.enhanceButton.setGeometry(QtCore.QRect(260, 140, 71, 23))
        self.enhanceButton.setCheckable(False)
        self.enhanceButton.setObjectName("enhanceButton")
        self.pushButtonShowPicture = QtWidgets.QPushButton(self.dockWidgetContents)
        self.pushButtonShowPicture.setEnabled(False)
        self.pushButtonShowPicture.setGeometry(QtCore.QRect(30, 235, 71, 23))
        font = QtGui.QFont()
        font.setPointSize(8)
        font.setBold(False)
        font.setWeight(50)
        self.pushButtonShowPicture.setFont(font)
        self.pushButtonShowPicture.setObjectName("pushButtonShowPicture")
        self.importLineVectorLayer = QtWidgets.QLineEdit(self.dockWidgetContents)
        self.importLineVectorLayer.setEnabled(True)
        self.importLineVectorLayer.setGeometry(QtCore.QRect(100, 155, 141, 20))
        font = QtGui.QFont()
        font.setPointSize(8)
        font.setBold(False)
        font.setWeight(50)
        self.importLineVectorLayer.setFont(font)
        self.importLineVectorLayer.setText("")
        self.importLineVectorLayer.setReadOnly(True)
        self.importLineVectorLayer.setObjectName("importLineVectorLayer")
        self.label_11 = QtWidgets.QLabel(self.dockWidgetContents)
        self.label_11.setGeometry(QtCore.QRect(10, 155, 91, 16))
        self.label_11.setObjectName("label_11")
        self.groupBoxMNT = dropEventMNT(self.dockWidgetContents)
        self.groupBoxMNT.setGeometry(QtCore.QRect(210, 180, 201, 91))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.groupBoxMNT.setFont(font)
        self.groupBoxMNT.setObjectName("groupBoxMNT")
        self.radioButtonDraw = QtWidgets.QRadioButton(self.groupBoxMNT)
        self.radioButtonDraw.setEnabled(False)
        self.radioButtonDraw.setGeometry(QtCore.QRect(20, 45, 71, 17))
        font = QtGui.QFont()
        font.setPointSize(8)
        font.setBold(False)
        font.setWeight(50)
        self.radioButtonDraw.setFont(font)
        self.radioButtonDraw.setChecked(True)
        self.radioButtonDraw.setObjectName("radioButtonDraw")
        self.radioButtonCut = QtWidgets.QRadioButton(self.groupBoxMNT)
        self.radioButtonCut.setEnabled(False)
        self.radioButtonCut.setGeometry(QtCore.QRect(20, 65, 81, 17))
        font = QtGui.QFont()
        font.setPointSize(8)
        font.setBold(False)
        font.setWeight(50)
        self.radioButtonCut.setFont(font)
        self.radioButtonCut.setObjectName("radioButtonCut")
        self.importToolMNT = QtWidgets.QToolButton(self.groupBoxMNT)
        self.importToolMNT.setGeometry(QtCore.QRect(170, 20, 25, 19))
        font = QtGui.QFont()
        font.setPointSize(8)
        font.setBold(False)
        font.setWeight(50)
        self.importToolMNT.setFont(font)
        self.importToolMNT.setObjectName("importToolMNT")
        self.importLineMNT = QtWidgets.QLineEdit(self.groupBoxMNT)
        self.importLineMNT.setGeometry(QtCore.QRect(10, 20, 161, 20))
        font = QtGui.QFont()
        font.setPointSize(8)
        font.setBold(False)
        font.setWeight(50)
        self.importLineMNT.setFont(font)
        self.importLineMNT.setText("")
        self.importLineMNT.setReadOnly(True)
        self.importLineMNT.setObjectName("importLineMNT")
        self.pushButtonRemoveMNT = QtWidgets.QPushButton(self.groupBoxMNT)
        self.pushButtonRemoveMNT.setEnabled(False)
        self.pushButtonRemoveMNT.setGeometry(QtCore.QRect(100, 50, 91, 23))
        font = QtGui.QFont()
        font.setPointSize(8)
        font.setBold(False)
        font.setWeight(50)
        self.pushButtonRemoveMNT.setFont(font)
        self.pushButtonRemoveMNT.setObjectName("pushButtonRemoveMNT")
        self.pushButtonOpenParam = QtWidgets.QPushButton(self.dockWidgetContents)
        self.pushButtonOpenParam.setGeometry(QtCore.QRect(340, 140, 71, 23))
        self.pushButtonOpenParam.setStyleSheet("background-color: rgb(255, 255, 127);")
        self.pushButtonOpenParam.setObjectName("pushButtonOpenParam")
        self.labelRightName = QtWidgets.QLabel(self.dockWidgetContents)
        self.labelRightName.setGeometry(QtCore.QRect(110, 100, 141, 16))
        self.labelRightName.setText("")
        self.labelRightName.setObjectName("labelRightName")
        self.labelLeftName = QtWidgets.QLabel(self.dockWidgetContents)
        self.labelLeftName.setGeometry(QtCore.QRect(110, 70, 141, 20))
        self.labelLeftName.setText("")
        self.labelLeftName.setObjectName("labelLeftName")
        self.label = QtWidgets.QLabel(self.dockWidgetContents)
        self.label.setGeometry(QtCore.QRect(10, 70, 101, 16))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.label.setFont(font)
        self.label.setObjectName("label")
        self.label_2 = QtWidgets.QLabel(self.dockWidgetContents)
        self.label_2.setGeometry(QtCore.QRect(10, 100, 101, 16))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.label_2.setFont(font)
        self.label_2.setObjectName("label_2")
        self.pushButtonCloseWindow = QtWidgets.QPushButton(self.dockWidgetContents)
        self.pushButtonCloseWindow.setEnabled(False)
        self.pushButtonCloseWindow.setGeometry(QtCore.QRect(110, 235, 71, 23))
        font = QtGui.QFont()
        font.setPointSize(8)
        font.setBold(False)
        font.setWeight(50)
        self.pushButtonCloseWindow.setFont(font)
        self.pushButtonCloseWindow.setObjectName("pushButtonCloseWindow")
        self.pushButtonFindBestPair = QtWidgets.QPushButton(self.dockWidgetContents)
        self.pushButtonFindBestPair.setEnabled(False)
        self.pushButtonFindBestPair.setGeometry(QtCore.QRect(290, 70, 101, 23))
        self.pushButtonFindBestPair.setObjectName("pushButtonFindBestPair")
        self.label_5 = QtWidgets.QLabel(self.dockWidgetContents)
        self.label_5.setGeometry(QtCore.QRect(40, 190, 141, 16))
        font = QtGui.QFont()
        font.setPointSize(10)
        font.setBold(True)
        font.setWeight(75)
        self.label_5.setFont(font)
        self.label_5.setObjectName("label_5")
        self.labelAltitude = QtWidgets.QLabel(self.dockWidgetContents)
        self.labelAltitude.setGeometry(QtCore.QRect(60, 210, 81, 16))
        self.labelAltitude.setObjectName("labelAltitude")
        self.pushButtonAffVecteur = QtWidgets.QPushButton(self.dockWidgetContents)
        self.pushButtonAffVecteur.setGeometry(QtCore.QRect(30, 125, 181, 23))
        self.pushButtonAffVecteur.setObjectName("pushButtonAffVecteur")
        StereoDockWidget.setWidget(self.dockWidgetContents)

        self.retranslateUi(StereoDockWidget)
        QtCore.QMetaObject.connectSlotsByName(StereoDockWidget)

    def retranslateUi(self, StereoDockWidget):
        _translate = QtCore.QCoreApplication.translate
        StereoDockWidget.setWindowTitle(_translate("StereoDockWidget", "StereoPhoto"))
        self.groupBoxMainPath.setTitle(_translate("StereoDockWidget", "Chemin vers les photos"))
        self.importToolProject.setText(_translate("StereoDockWidget", "..."))
        self.pushButtonShowIDList.setText(_translate("StereoDockWidget", "Parcourir la liste"))
        self.enhanceButton.setText(_translate("StereoDockWidget", "Rehausser"))
        self.pushButtonShowPicture.setText(_translate("StereoDockWidget", "Naviguer"))
        self.label_11.setText(_translate("StereoDockWidget", "Couche en édition"))
        self.groupBoxMNT.setTitle(_translate("StereoDockWidget", "Modèle numérique de terrrain"))
        self.radioButtonDraw.setText(_translate("StereoDockWidget", "Dessiner"))
        self.radioButtonCut.setText(_translate("StereoDockWidget", "Découper"))
        self.importToolMNT.setText(_translate("StereoDockWidget", "..."))
        self.pushButtonRemoveMNT.setText(_translate("StereoDockWidget", "Retirer le modèle"))
        self.pushButtonOpenParam.setText(_translate("StereoDockWidget", "Paramètres"))
        self.label.setText(_translate("StereoDockWidget", "Image Gauche :"))
        self.label_2.setText(_translate("StereoDockWidget", "Image Droite :"))
        self.pushButtonCloseWindow.setText(_translate("StereoDockWidget", "Fermer"))
        self.pushButtonFindBestPair.setText(_translate("StereoDockWidget", "Trouver la paire"))
        self.label_5.setText(_translate("StereoDockWidget", "Altitude du curseur"))
        self.labelAltitude.setText(_translate("StereoDockWidget", "100.000000000"))
        self.pushButtonAffVecteur.setText(_translate("StereoDockWidget", "Gestion des couches vectorielles"))

        

class dropEventMNT(QtWidgets.QGroupBox): 
    validMNT = pyqtSignal()
    def __init__(self, parent=None):
        QtWidgets.QGroupBox.__init__(self, parent)
        self.setAcceptDrops(True)

    def dragEnterEvent(self, event):
        event.accept()
        
    def dropEvent(self, event):
        fileURL = event.mimeData().urls()[0].toString()
        try :
            fileName = fileURL.split('file:///')[1]
        except :
            fileName = fileURL.split('file:')[1]
        
        
        if fileName.split('.')[-1] in ['tif','vrt'] :
            self.MNTPath = fileName
            self.MNTName = os.path.basename(fileName)
            self.validMNT.emit()
        else : 
            self.MNTPath = ''
            self.MNTName = ''

class dropedit(QtWidgets.QGroupBox):   

    def __init__(self, parent=None):
        super(dropedit, self).__init__(parent)
        self.setAcceptDrops(True)

    def dragEnterEvent(self, event):
        event.accept()
        
    def dropEvent(self, event):
        fileURL = event.mimeData().urls()[0].toString()
        try :
            fileName = fileURL.split('file:///')[1]
        except :
            fileName = fileURL.split('file:')[1]
        if os.path.isdir(fileName):
            for child in self.children(): 
                if child.metaObject().className() == "QLineEdit":
                    child.setText(fileName)

class optionWindow(QtWidgets.QDockWidget): 
    closeWindow = pyqtSignal()
    keyPressed = pyqtSignal(QtGui.QKeyEvent)
    def __init__(self, iface):
        QtWidgets.QMainWindow.__init__(self, iface.mainWindow())
        self.ui = Ui_StereoDockWidget()
        self.ui.setupUi(self)
        self.ui.importToolProject.clicked.connect(self.showImportDirectory)
        self.ui.pushButtonAffVecteur.clicked.connect(self.showImportVector)
        self.ui.importToolMNT.clicked.connect(self.showImportMNT)
        self.ui.groupBoxMNT.validMNT.connect(self.dropImportMNT)
        self.ui.pushButtonRemoveMNT.clicked.connect(self.removeImportMNT)
        self.vLayer = None
        self.vectorWindow = getVectorLayerCustomList()
        self.projectPath = os.environ["USERPROFILE"]
        self.mntLocation = os.environ["USERPROFILE"]
        #self.currentMNTPath = ''

    def showImportDirectory(self) :
        fname = QtWidgets.QFileDialog.getExistingDirectory(self, 'Importer un dossier de photos aériennes',self.projectPath)
        if fname: self.ui.importLineProject.setText(fname)

            
    #Ouvre une fenêtre de Qt pour choisir la couche de polygones
    def showImportVector(self):
        self.dictLayerName = {}
        for item in iface.mapCanvas().layers():
            if item.type() == QgsMapLayerType.VectorLayer and item.geometryType() in [QgsWkbTypes.PolygonGeometry, QgsWkbTypes.PointGeometry,QgsWkbTypes.LineGeometry]: 
                self.dictLayerName[item.name()] = item
        
        if self.dictLayerName : 
            self.vectorWindow.setItem(self.dictLayerName)
            self.vectorWindow.show()
            self.vectorWindow.raise_()
            self.vectorWindow.ui.buttonBox.accepted.connect(self.importVectorAccept)
            self.vectorWindow.ui.buttonBox.rejected.connect(self.importVectorCancel)

        else :
            #No Current VectorLayer
            return

    #Création de l'objet qui réprésente la couche vectorielle
    def importVectorAccept(self):
        self.vectorToShow = {}
        for i in range(self.vectorWindow.ui.tableWidget.rowCount()) : 
            afficher = self.vectorWindow.ui.tableWidget.cellWidget(i,0)
            nomCouche = self.vectorWindow.ui.tableWidget.item(i,1).text()
            couleur = self.vectorWindow.ui.tableWidget.cellWidget(i,2).property("color")
            utiliser3D = self.vectorWindow.ui.tableWidget.cellWidget(i,3).isChecked()
            if afficher.isChecked() : self.vectorToShow[nomCouche] = [couleur,utiliser3D]

        currentRow = self.vectorWindow.ui.tableWidget.currentRow()
        currentVectors = list(self.vectorToShow.keys())
        if len(currentVectors) > 0 : 
            if currentRow == -1  : editLayer = ''
            else : editLayer = self.vectorWindow.ui.tableWidget.item(currentRow,1).text()
            self.vLayerName = editLayer if editLayer in currentVectors else currentVectors[0]  
            #self.vLayerName = self.vectorWindow.ui.tableWidget.itemWidget(self.vectorWindow.ui.listWidget.selectedItems()[0]).label.text()
            self.vLayer = self.dictLayerName[self.vLayerName]
            self.ui.importLineVectorLayer.setText(self.vLayerName)
        self.vectorWindow.close()

    def importVectorCancel(self):
        self.vectorWindow.close()

    def showImportMNT(self):
        fname = QtWidgets.QFileDialog.getOpenFileName(self, 'Importer un modèle numérique de terrain', self.mntLocation, 'MNT (*.tif *.vrt)')[0]
        if fname:
            self.currentMNTPath = fname
            nameMNT = os.path.basename(fname)
            self.mntLocation = os.path.dirname(fname)
            self.ui.radioButtonCut.setEnabled(True)
            self.ui.radioButtonDraw.setEnabled(True)
            self.ui.pushButtonRemoveMNT.setEnabled(True)
            self.ui.importLineMNT.setText(nameMNT)
        else : 
            self.currentMNTPath = ''
            self.ui.radioButtonCut.setEnabled(False)
            self.ui.radioButtonDraw.setEnabled(False)
            self.ui.pushButtonRemoveMNT.setEnabled(False)
    
    def dropImportMNT(self):
        self.currentMNTPath = self.ui.groupBoxMNT.MNTPath
        self.mntLocation = os.path.dirname(self.currentMNTPath)
        self.ui.importLineMNT.setText(self.ui.groupBoxMNT.MNTName)
        self.ui.radioButtonCut.setEnabled(True)
        self.ui.radioButtonDraw.setEnabled(True)
        self.ui.pushButtonRemoveMNT.setEnabled(True)
    
    def removeImportMNT(self) : 
        self.currentMNTPath = ''
        self.ui.radioButtonCut.setEnabled(False)
        self.ui.radioButtonDraw.setEnabled(False)
        self.ui.pushButtonRemoveMNT.setEnabled(False)
        self.ui.importLineMNT.setText("")

    def closeEvent(self,event):
        self.closeWindow.emit()

    #Fonction appelé lorsqu'une touche du clavier est appuyée
    def keyPressEvent(self, event):
        self.keyPressed.emit(event)

    def keyReleaseEvent(self, event):
        self.keyPressed.emit(event)
        