# -*- coding: utf-8 -*-

"""
/***************************************************************************
 StationOffset
                                 A QGIS plugin
 This plugin computes the station and offset of points along polylines and exports those values to csv for other applications
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-05-17
        copyright            : (C) 2023 by Tailwater Limited
        email                : applications@tailwaterlimited.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Tailwater Limited'
__date__ = '2023-09-13'
__copyright__ = '(C) 2023 by Tailwater Limited'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication
from qgis.PyQt.QtCore import QUrl
from qgis.PyQt.QtCore import QUrlQuery

from qgis.core import (QgsProcessing,
                       QgsProcessingAlgorithm,
                       QgsProcessingFeedback,
                       QgsProcessingParameters,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterField,
                       QgsProcessingParameterString,
                       QgsProject,
                       QgsGeometry,
                       edit
                       )

import math

class StationCalculatorAlgorithm(QgsProcessingAlgorithm):
    """
    This algorithm imports a PNEZD file
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    INPUTXS = 'XS_FILE'
    INPUTCL = 'CL_FILE'
    PRESTRING = ''
    INPUTATTRIBUTFIELD = 'name'
    
    def initAlgorithm(self, config):
        """
        There is 1 input file for this algorithm the PNEZD text file. This file is formatted as a comma separated file in Point Number, Northing,
        Easting, Elevation, Description format.
        """

        self.addParameter(QgsProcessingParameterFeatureSource(
            self.INPUTXS,
            self.tr('Polylines (Cross-Section Alignment Lines)'),
            types=[QgsProcessing.SourceType.TypeVectorLine],
            defaultValue=None))

        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.INPUTCL,
                self.tr('Polylines (Center Line Alignment)'),
                types=[QgsProcessing.SourceType.TypeVectorLine],
                defaultValue=None))

        self.addParameter(QgsProcessingParameterField(
            self.INPUTATTRIBUTFIELD,
            self.tr('Attribute to put in stationing (text field)'),
            defaultValue=None,
            parentLayerParameterName=self.INPUTXS,
            type=QgsProcessingParameterField.DataType.String,
            allowMultiple=False))

        self.addParameter(QgsProcessingParameterString(
            self.PRESTRING,
            self.tr('String to append before station ie XS '),
            defaultValue=None,
            multiLine=False,
            optional=True))

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        
        """
        results = {}
        outputs = {}

        nameAttributeFieldName = self.parameterAsFields(parameters, self.INPUTATTRIBUTFIELD,context)[0]
        preString = self.parameterAsString(parameters, self.PRESTRING, context)

        xsLayer = self.parameterAsVectorLayer(parameters,self.INPUTXS,context)
        clLayer = self.parameterAsVectorLayer(parameters, self.INPUTCL, context)

        #For right now we will only get the first feature. After we could look to see if we don't intersect and try a different feature?
        clFeature = next(clLayer.getFeatures())
        clGeometry = clFeature.geometry()

        xsLayer.startEditing()

        xsLayerFields = xsLayer.fields()
        nameIdx = xsLayerFields.indexFromName(nameAttributeFieldName)
        feedback.pushInfo("Field Index " + str(nameIdx))

        for xsFeature in xsLayer.getFeatures():
                
            """Find Intersection get a point
            """
            xsGeometry = xsFeature.geometry()
            intersectionPoint = xsGeometry.intersection(clGeometry)

            if(intersectionPoint.isNull()):
                xsLayer.changeAttributeValue(xsFeature.id(), nameIdx,"No Intersection")
                feedback.pushInfo("No intersection found?")
            else:
                station = clGeometry.lineLocatePoint(intersectionPoint)
                attributeValue = preString + '{:.0f}'.format(station)
                xsLayer.changeAttributeValue(xsFeature.id(), nameIdx,attributeValue)
                feedback.pushInfo("Attribute set " + attributeValue)
            """Locate point along line if a point is found
            """
        xsLayer.commitChanges()
        xsLayer.updateFields()

        return {}

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'xsstationnamingtool'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr("Cross-Section Naming Tool")

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr('Stream Tools')

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'streamtools'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return StationCalculatorAlgorithm()

    def helpString(self):
        return "This process returns a string value that includes the user supplied prefix along with the station from the centerline."
