# -*- coding: utf-8 -*-
"""
/***************************************************************************
 SortLayers
                                 A QGIS plugin
 Sorts layers in Layers Panel alphabetically
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-03-10
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Mikhail Minin
        email                : m.minin@jacobs-university.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.core    import QgsProject
from qgis.PyQt.QtCore import QSettings, QTranslator, qVersion, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QMenu

# Initialize Qt resources from file resources.py
from .resources import *
import os.path


class SortLayers:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'SortLayers_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menuLayer = self.iface.mainWindow().menuBar().findChild(QMenu, 'mLayerMenu')
        self.menu = self.tr(u'&Sort Layers')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'SortLayers')
        self.toolbar.setObjectName(u'SortLayers')

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('SortLayers', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            # Customize the iface method if you want to add to a specific
            # menu (for example iface.addToVectorMenu):
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def create_action(self, icon_path, text, callback):
        """Create new action to add to the menu"""
        action = QAction(QIcon(icon_path), text, self.iface.mainWindow())
        action.triggered.connect( callback   )
        action.setEnabled(        True       )
        self.toolbar.addAction(   action     )
        self.menuLayer.addAction( action     )
        self.actions.append(      action     )

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        self.create_action(
            icon_path = ':/plugins/sort_layers/iconAZ.png',
            text      = u'Sort Layers: A=>Z',
            callback  = self.run)
        self.create_action(
            icon_path = ':/plugins/sort_layers/iconZA.png',
            text      = u'Sort Layers: Z=>A',
            callback  = lambda: self.run(True))


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Sort Layers'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar


    def run(self, backward=False):
        """Run method that actually sorts layers"""
        root = QgsProject.instance().layerTreeRoot()
        LayerNamesEnumDict=lambda listCh: {listCh[q[0]].name()+str(q[0]):q[1]
                                           for q in enumerate(listCh)}
        mLNED     = LayerNamesEnumDict(root.children())
        mLNEDkeys = list(mLNED.keys())
        mLNEDkeys.sort()
        mLNEDsorted = [mLNED[k].clone() for k in mLNEDkeys]
        if backward: mLNEDsorted=mLNEDsorted[::-1]
        root.insertChildNodes(0,mLNEDsorted)
        for n in mLNED.values(): root.removeChildNode(n)
