# -*- coding: utf-8 -*-
"""
/***************************************************************************
 NissinMap
                                 A QGIS plugin
 This plugin is used to load the daily new map provided by Siwei Earth Company.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-09-08
        git sha              : $Format:%H$
        copyright            : (C) 2020 by SiweiEarth
        email                : Ellison_YZ@163.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os
import numpy as np
import datetime
import hashlib
from osgeo import gdal
import math
import qgis
from .pyshp import shapefile
import requests
from PyQt5.QtWidgets import QMessageBox, QFileDialog, QTableWidgetItem, QHeaderView, QLineEdit, QCheckBox, \
    QListWidgetItem
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
import PyQt5.QtWidgets as qw
from qgis.utils import iface
from .satellite import ComboCheckBox
from qgis.core import (
    QgsCoordinateReferenceSystem,
    QgsCoordinateTransform,
    QgsProject,
    QgsPointXY,
)

# Initialize Qt resources from file resources.py
from .resources import *
import string
# Import the code for the dialog
from .nissinmap_dialog import NissinMapDialog
from .nissinmap_checkMap import CheckMap
from .nissinmap_register import Register
import os.path

re = {}

list = []

sat_dict = {"高分一号":10000401,"高分一号B星":10000801,"高分一号C星":10000901,"高分一号D星":10001101,"高分六号":10001201,"资源三号02星":10000601,"高分二号":10000501,
            "CB04A":10001401, "资源一号E星":10001501,"资源一号F星":10001601,"高分七号":10001701,"资源三号03星":10001301}

class NissinMap():
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'SiweiEarth_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&SiweiEarth')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        self.payload = ''

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('SiweiEarth', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/nissinmap/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'SiweiEarth'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&SiweiEarth'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = NissinMapDialog()
            self.dlg.login_button.clicked.connect(self.display)
            self.dlg.register_2.clicked.connect(self.register)
            self.dlg.exit_button.clicked.connect(self.close)
            self.dlg.pwd_lineEdit.setEchoMode(QLineEdit.Password)
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass

    def get_mod5(self, s):
        md5 = hashlib.md5()
        md5.update(s.encode('utf-8'))
        return md5.hexdigest()

    def province_confirm(self):
        province = self.rgs.province.currentText()
        city_ls = cities[province]
        self.rgs.city.clear()
        self.rgs.city.addItems(city_ls)
        return province

    def city_confirm(self):
        city = self.rgs.city.currentText()
        city = str(city)
        return city

    def job_confirm(self):
        job = self.rgs.city.currentText()
        job = str(job)
        return job


    def extra_info_confirmed(self):
        province = self.rgs.province.currentText()
        city = self.rgs.city.currentText()
        job = self.rgs.job_select.currentText()
        click_info = province + city + job
        print(click_info)

    def build_json(self):
        self.payload = "{\"language\":\"ENUS\",\"timezone\":\"Asia/Shanghai\",\"name\":" + "\"" + self.rgs.user_lineEdit_2.text() + "\""
        self.payload += ",\"cellphone\":" + "\"" + self.rgs.user_lineEdit_2.text() + "\"," + "\"account\":" + "\"sw_" + self.rgs.user_lineEdit_2.text() + "\","
        self.payload += "\"business\":" + "\"" + self.rgs.job_select.currentText() + "\","
        if (self.rgs.province.currentText() != '') and (self.rgs.city.currentText() != ''):
            self.payload += "\"location\":" + "\"" + self.rgs.province.currentText() + "," + self.rgs.city.currentText() + "\","
            self.payload += "\"address\":" + "\"" + self.rgs.province.currentText() + "," + self.rgs.city.currentText() + "\","
        else:
            self.payload += "\"location\":" + "\"\","
            self.payload += "\"address\":" + "\"\","

        password = self.get_mod5(self.rgs.pwd_lineEdit.text())
        self.payload += "\"src_type\":5,\"password\":" + "\"" + password + "\"}"

    def phone_number_check(self):
        if (len(self.rgs.user_lineEdit_2.text()) != 11) or (self.rgs.user_lineEdit_2.text()[:3] not in ['133','181','186','134','135','136','137','138','139','147',
                                                                                                        '150','151','152','157','158','159','178','182','183','184',
                                                                                                        '187','188','198','130','131','132','155','156','166','185','186','145',
                                                                                                        '176','153','177','173','180','181','189','199','165','170','171']):
            QMessageBox.warning(self.rgs, "警告", "请输入正确的手机号！")
            return 0
        else:
            return 1

    def password_check(self):
        if len(self.rgs.pwd_lineEdit.text()) < 6:
            QMessageBox.warning(self.rgs, "警告", "密码不能少于6个字符！")
            return 0
        else:
            check_number = 0
            alphabets = string.ascii_letters
            lower = string.ascii_lowercase
            upper = string.ascii_uppercase
            special_characters = ['!','@','#','$','%','^','&','*','(',')','_','-','+','=','[',']',
                                  '{','}','\\','|',':',';','"','\'','<',',','>','.','?','/','`','~']

            for i in range(len(self.rgs.pwd_lineEdit.text())):
                if self.rgs.pwd_lineEdit.text()[i] in lower:
                    check_number += 1
                    break
            for i in range(len(self.rgs.pwd_lineEdit.text())):
                if self.rgs.pwd_lineEdit.text()[i] in upper:
                    check_number += 1
                    break
            for i in range(len(self.rgs.pwd_lineEdit.text())):
                if self.rgs.pwd_lineEdit.text()[i].isnumeric():
                    check_number += 1
                    break
            for i in range(len(self.rgs.pwd_lineEdit.text())):
                if self.rgs.pwd_lineEdit.text()[i] in special_characters:
                    check_number += 1
                    break

            if check_number < 3:
                QMessageBox.warning(self.rgs, "警告", "密码至少包含数字/大写/小写/字符三种！")
                return 0
            else:
                return 1

    def password_confirm(self):
        if self.rgs.pwd_lineEdit_2.text() != self.rgs.pwd_lineEdit.text():
            QMessageBox.warning(self.rgs, "警告", "两次输入密码不一致！")
            return 0
        else:
            return 1

    def send_verify(self):
        url = "https://swapi.siweiearth.com/siweiearth/sj_user/v6/api/user_register?op=send_register_ver_code&reciever="
        url += self.rgs.user_lineEdit_2.text()
        response_ver = requests.get(url)

    def new_register(self):
        if self.check_all() == 1:
            url = "https://swapi.siweiearth.com/siweiearth/sj_user/v6/api/user_register?ver_code="
            url += self.rgs.user_lineEdit_3.text()
            response = requests.post(url, data = self.payload.encode("utf-8"))
            if response.json()['status']=="$SUCCESS":
                QMessageBox.warning(self.rgs, "四维地球", '注册成功！')
            else:
                QMessageBox.warning(self.rgs, "四维地球", response.json()['message'])

    def check_all(self):
        check_results = self.password_check()
        if check_results==0:
            return 0
        else:
            check_results1 = self.password_confirm()
            if check_results1==0:
                return 0
            else:
                return 1


    def set_echo_pwd(self):
        if self.rgs.checkBox.isChecked():
            self.rgs.pwd_lineEdit.setEchoMode(QLineEdit.Normal)
            self.rgs.pwd_lineEdit_2.setEchoMode(QLineEdit.Normal)
        else:
            self.rgs.pwd_lineEdit.setEchoMode(QLineEdit.Password)
            self.rgs.pwd_lineEdit_2.setEchoMode(QLineEdit.Password)


    def back_login(self):
        self.rgs.close()
        self.run()

    def register(self):
        self.rgs = Register()
        self.dlg.close()
        self.rgs.pwd_lineEdit.setEchoMode(QLineEdit.Password)
        self.rgs.pwd_lineEdit_2.setEchoMode(QLineEdit.Password)
        self.rgs.province.addItems(["","北京市","天津市","河北省","黑龙江省","吉林省",
                                     "辽宁省","内蒙古自治区","山西省","上海市","江苏省",
                                     "浙江省","安徽省","福建省","江西省","山东省",
                                     "河南省","湖北省","湖南省","广东省","广西壮族自治区",
                                     "海南省","重庆市","四川省","贵州省","云南省","西藏自治区",
                                     "陕西省","甘肃省","青海省","宁夏回族自治区","新疆维吾尔自治区",
                                     "台湾省","香港特别行政区","澳门特别行政区"])
        self.rgs.job_select.addItems(["", "计算机软件","计算机硬件","计算机服务(系统、数据服务、维修)","通信/电信/网络设备","通信/电信运营、增值服务","互联网/电子商务","网络游戏",
                                    "电子技术/半导体/集成电路","仪器仪表/工业自动化","政府/公共事业","非营利组织","农/林/牧/渔","多元化业务集团公司","石油/化工/矿产/地址",
                                    "采掘业/冶炼","电气/电力/水利","新能源","原材料和加工","环保","交通/运输/物流","航天/航空",
                                    "餐饮业","酒店/旅游","娱乐/休闲/体育","美容/保健","生活服务","专业服务(咨询、人力资源、财会)","外包服务","检测，认证","法律","教育/培训/院校",
                                    "学术/科研","房地产","建筑/建材/工程","家居/室内设计/装潢","物业管理/商业中心","中介服务","租赁服务","广告","公关/市场推广/会展","影视/媒体/艺术/文化传播",
                                    "文字媒体/出版","印刷/包装/造纸","制药/生物工程","医疗/护理/卫生","医疗设备/器械","贸易/进出口","批发/零售","快速消费品(食品、饮料、化妆品)",
                                    "服装/纺织/皮革","家具/家电/玩具/礼品","奢侈品/收藏品/工艺品/珠宝","办公用品及设备","机械/设备/重工","汽车","汽车零部件","会计/审计",
                                    "金融/投资/证券","银行","保险","信托/担保/拍卖/典当"])
        # self.rgs.pushButton_2.clicked.connect(self.phone_number_check)
        self.rgs.province.currentIndexChanged.connect(self.province_confirm)
        self.rgs.city.currentIndexChanged.connect(self.city_confirm)
        self.rgs.job_select.currentIndexChanged.connect(self.job_confirm)
        self.rgs.checkBox.stateChanged.connect(self.set_echo_pwd)
        # self.rgs.pushButton.clicked.connect(self.extra_info_confirmed)
        self.rgs.get_check_code.clicked.connect(self.send_verify)
        self.rgs.get_check_code.clicked.connect(self.phone_number_check)

        # self.rgs.register_button.clicked.connect(self.check_all)

        self.rgs.register_button.clicked.connect(self.build_json)
        self.rgs.register_button.clicked.connect(self.check_payload)
        self.rgs.register_button.clicked.connect(self.new_register)

        self.rgs.show()
        self.rgs.back_login.clicked.connect(self.back_login)

    def check_payload(self):
        print(self.payload)


    def display(self):
        username = self.dlg.user_lineEdit.text()
        password = self.dlg.pwd_lineEdit.text()
        if username == "" or password == "":
            QMessageBox.warning(self.dlg, "警告", "账号密码不可以为空，请输入！")
            return
        real_password = self.get_mod5(username + "_" + self.get_mod5(password))
        # print(real_password)
        url_login = "https://swapi.siweiearth.com/siweiearth/sj_user/v6/api/login"
        data = {'user_name': username, 'password': real_password}
        response = requests.post(url_login, json=data)
        if response.json()["status"] == "$SUCCESS":
            re['mgt_token'] = response.json()["result"]["ak"]
            self.load_basemap()
            self.check()
        else:
            QMessageBox.warning(self.dlg, "警告", "账户或密码错误，请重新输入！")

    def close(self):
        self.dlg.close()

    def load_basemap(self):
        url_base = "https://swapi.siweiearth.com/sj_raster/v6/wmts/tile/10000201/3?ak="
        #url_sec  = "%26product_id%3D102%26Service%3DWMTS%26Request%3DGetCapabilities"
        url = url_base + re['mgt_token']
        iface.addRasterLayer(url,"SiweiEarth Basemap")

    def check(self):
        self.che = CheckMap()
        self.dlg.close()
        self.che.tableWidget.setColumnCount(3)
        self.che.tableWidget.setHorizontalHeaderLabels(('影像信息','影像日期','云盖率'))
        self.che.tableWidget.horizontalHeader().setSectionResizeMode(QHeaderView.Stretch)  # 使表宽度自适应
        self.che.tableWidget.horizontalHeader().setSectionResizeMode(0, QHeaderView.Interactive)
        self.che.tableWidget.horizontalHeader().setSectionResizeMode(1, QHeaderView.Interactive)
        self.che.spinBox.setReadOnly(True)
        self.che.dateEdit_fromtime.setDate(QtCore.QDate.currentDate().addYears(-2))
        self.che.dateEdit_totime.setDate(QtCore.QDate.currentDate())
        self.che.dateEdit_fromtime.setReadOnly(True)
        self.che.dateEdit_totime.setReadOnly(True)
        self.che.spinBox.lineEdit().setStyleSheet('color: rgb(220,220,220); background-color: rgb(220,220,220);')
        self.che.dateEdit_totime.lineEdit().setStyleSheet('color: rgb(220,220,220); background-color: rgb(220,220,220);')
        self.che.dateEdit_fromtime.lineEdit().setStyleSheet('color: rgb(220,220,220); background-color: rgb(220,220,220);')
        self.che.checkBox_cloud.stateChanged.connect(self.changeCloud)
        self.che.checkBox_time.stateChanged.connect(self.changeTime)
        self.upload_info
        self.che.pushButton_customize.clicked.connect(self.load_datafile)
        self.che.pushButton_default.clicked.connect(self.search)
        self.che.pushButton_add.clicked.connect(self.addMap)
        self.che.show()

    def load_datafile(self):
        dir_path = os.getcwd()
        files, filetype = QFileDialog.getOpenFileName(None,"选择一个shp文件", './',"Shp Files (*.shp)")
        if files != '':
            sf = shapefile.Reader(files)
            if len(sf.shapes()) == 1:
                points = sf.shapes()[0].points
                x_ls = []
                y_ls = []
                point_list = []
                temp_Points = []
                for x, y in points:
                    x_ls.append(x)
                    y_ls.append(y)
                    xarray = np.array(x_ls)
                    yarray = np.array(y_ls)
                    X_min = xarray.min()
                    Y_min = yarray.min()
                    X_max = xarray.max()
                    Y_max = yarray.max()
                    dic = {"x": x, "y": y}
                    point = [x,y]
                    temp_Points.append(point)
                    point_list.append(dic)
                print(point_list)
                length = len(temp_Points)
                SS = temp_Points[0][1] * (temp_Points[length - 1][0] - temp_Points[1][0])
                for i in range(1, length):
                    SS += temp_Points[i][1] * (temp_Points[i - 1][0] - temp_Points[(i + 1) % length][0])
                area = round(math.fabs(SS / 2) * 9101160000.085981, 6)
                if area <= 2e10:
                    default_start_time = "2023-1-1 00:00:00"  # default start time 2023-01-01
                    current_time = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')

                    url_map = "https://swapi.siweiearth.com/sj_raster/v6/api/image_query?op=select_agg_day&ak="
                    url_map = url_map + re['mgt_token']
                    if self.che.checkBox_time.isChecked():
                        start_time = self.che.dateEdit_fromtime.date().toString(Qt.ISODate)
                        end_time = self.che.dateEdit_totime.date().toString(Qt.ISODate)
                        jsondata = "{\"start_time\": \"" + start_time + "\",\"end_time\": \"" + current_time + "\","
                    else:
                        jsondata = "{\"start_time\": \"" + default_start_time + "\",\"end_time\": \"" + current_time + "\","
                    # jsondata = "{\"start_time\": \"" + start_time + "\",\"end_time\": \"" + current_time + "\","
                    jsondata += "\"type_i\":[\"1101\"],\"projection\":\"EPSG:4326\",\"boundary\":{\"coordinates\":"
                    extent = "[[[" + str(X_min) + "," + str(Y_max) + "]" + "," + "[" + str(X_min) + "," + str(Y_min) + "]" + "," + "[" + str(X_max) + "," + str(Y_min) + "]" + "," + "[" + str(X_max) + "," + str(Y_max) + "]" + "," + "[" + str(X_min) + "," + str(Y_max) + "]" + "]],"
                    jsondata += extent
                    jsondata += "\"type\":\"Polygon\"},\"sort\":\"image_time\",\"area_cover_max\":1,\"area_cover_min\":0,\"min_solar_azimuth\":0,\"max_solar_azimuth\":360,\"min_solar_elevation\":-90,\"max_solar_elevation\":90,\"gcj02\":1}"

                    # ==================== Check the results ====================
                    file = open("D:\\json.txt", "w")
                    file.write(jsondata)
                    file.close()
                    # ==================== Check the results ====================

                    response = requests.post(url_map, data=jsondata)  # request the results based on the json.

                    item_list = []
                    index = 0
                    for data in response.json()["result"]["item_list"]:
                        index += 1
                        image_url = data["item_list"][0]["image_url"].split('/')[-1]
                        dic = (data["item_list"][0]["data_id"], image_url, data["item_list"][0]["cloud_cover"],
                               data["item_list"][0]["image_time"], data["item_list"][0]["sat_id"])
                        item_list.append(dic)

                    # 卫星控制
                    print(item_list)
                    sat_select_list = self.upload_info()
                    print(sat_select_list)
                    id_list = []
                    for item in sat_select_list:
                        try:
                            id_list = id_list + [sat_dict[item]]
                        except KeyError as e:
                            pass
                    print(id_list)
                    sat_filter = []
                    for item in item_list:
                        if int(item[-1]) in id_list:
                            sat_filter.append(item)

                    print(sat_filter)
                    # 查询云量控制
                    if self.che.checkBox_cloud.isChecked():
                        cloud_filter = []
                        cloud_max_value = self.che.spinBox.value()
                        for item in sat_filter:
                            if int(item[2]) < cloud_max_value:
                                cloud_filter.append(item)
                        filter_result = cloud_filter
                    else:
                        filter_result = sat_filter

                    if len(filter_result) > 0:
                        self.che.tableWidget.setRowCount(len(filter_result))
                        for index, result in zip(range(len(filter_result)), filter_result):
                            col_2 = QTableWidgetItem(result[3])
                            col_3 = QTableWidgetItem(str(result[2]))
                            col_1 = QTableWidgetItem(result[1])
                            col_1.setCheckState(QtCore.Qt.Unchecked)
                            col_1.id_ = result[0]
                            self.che.tableWidget.setItem(index, 0, col_1)
                            self.che.tableWidget.setItem(index, 1, col_2)
                            self.che.tableWidget.setItem(index, 2, col_3)
                            self.che.tableWidget.update()
                    else:
                        self.che.tableWidget.setRowCount(0)
                        QMessageBox.warning(self.che, "警告", "当前查询结果为空，请筛选卫星后重新进行查询")
                else:
                    QMessageBox.warning(self.che, "警告", "该shp文件无效，应保证shp文件中多边形的面积小于2万平方公里")
            else:
                QMessageBox.warning(self.che, "警告", "该shp文件无效，应保证读取的shp文件中只含有一个多边形")
        else:
            QMessageBox.warning(self.che, "警告", "未选择有效shp文件，请重新选择")

    def search(self):
        canvas = qgis.utils.iface.mapCanvas()
        #canvas.setMapUnits(2)
        scale = canvas.scale()
        if scale < 200000:
            coordinate = str(canvas.extent())
            coordinate = coordinate.split(':')[1].split('>')[0].split(',')
            co1 = coordinate[0].split(' ')
            co2 = coordinate[1].split(' ')

            # change EPSG:3857 to EPSG:4326
            crsSrc = QgsCoordinateReferenceSystem("EPSG:3857")
            crsDest = QgsCoordinateReferenceSystem("EPSG:4326")
            transformContext = QgsProject.instance().transformContext()
            xform = QgsCoordinateTransform(crsSrc,crsDest, transformContext)
            ul = xform.transform(QgsPointXY(float(co1[1]), float(co2[2])))
            lr = xform.transform(QgsPointXY(float(co2[1]), float(co1[2])))
            xMin = ul[0]
            xMax = lr[0]
            yMin = lr[1]
            yMax = ul[1]

            current_time = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
            last_year = str(int(current_time[:4])-1)
            default_start_time = last_year + current_time[4:]
            url_map = "https://swapi.siweiearth.com/sj_raster/v6/api/image_query?op=select_agg_day&ak="
            url_map = url_map + re['mgt_token']
            # 根据查询条件构建查询json字符串
            # 查询时间控制
            if self.che.checkBox_time.isChecked():
                start_time = self.che.dateEdit_fromtime.date().toString(Qt.ISODate)
                end_time = self.che.dateEdit_totime.date().toString(Qt.ISODate)
                jsondata = "{\"start_time\": \"" + start_time + "\",\"end_time\": \"" + current_time + "\","
            else:
                jsondata = "{\"start_time\": \"" + default_start_time + "\",\"end_time\": \"" + current_time + "\","
            #jsondata = "{\"start_time\": \"" + start_time + "\",\"end_time\": \"" + current_time + "\","
            jsondata += "\"type_i\":[\"1101\"],\"projection\":\"EPSG:4326\",\"boundary\":{\"coordinates\":"
            extent = "[[[" + str(xMin) + "," + str(yMax) + "]" + "," + "[" + str(xMin) + "," + str(yMin) + "]" + "," + "[" + str(xMax) + "," + str(yMin) + "]" + "," + "[" + str(xMax) + "," + str(yMax) + "]" + "," + "[" + str(xMin) + "," + str(yMax) + "]" + "]],"
            jsondata += extent
            jsondata += "\"type\":\"Polygon\"},\"sort\":\"image_time\",\"area_cover_max\":1,\"area_cover_min\":0,\"min_solar_azimuth\":0,\"max_solar_azimuth\":360,\"min_solar_elevation\":-90,\"max_solar_elevation\":90,\"gcj02\":1}"
            # ==================== Check the results ====================
            file = open("D:\\json.txt", "w")
            file.write(jsondata)
            file.close()
            # ==================== Check the results ====================

            response = requests.post(url_map, data=jsondata)        # request the results based on the json.

            # ==================== Check the results ====================
            file = open("D:\\record.txt", "a")
            file.write(response.text)
            file.close()
            # ==================== Check the results ====================
            item_list = []
            index = 0
            for data in response.json()["result"]["item_list"]:
                index += 1
                image_url = data["item_list"][0]["image_url"].split('/')[-1]
                dic = (data["item_list"][0]["data_id"], image_url, data["item_list"][0]["cloud_cover"], data["item_list"][0]["image_time"], data["item_list"][0]["sat_id"])
                item_list.append(dic)

            # 卫星控制
            print(item_list)
            sat_select_list = self.upload_info()
            print(sat_select_list)
            id_list = []
            for item in sat_select_list:
                try:
                    id_list = id_list + [sat_dict[item]]
                except KeyError as e:
                    pass
            print(id_list)
            sat_filter = []
            for item in item_list:
                if int(item[-1]) in id_list:
                    sat_filter.append(item)

            print(sat_filter)
            # 查询云量控制
            if self.che.checkBox_cloud.isChecked():
                cloud_filter = []
                cloud_max_value = self.che.spinBox.value()
                for item in sat_filter:
                    if int(item[2]) < cloud_max_value:
                        cloud_filter.append(item)
                filter_result = cloud_filter
            else:
                filter_result = sat_filter

            if len(filter_result) > 0:
                self.che.tableWidget.setRowCount(len(filter_result))
                for index, result in zip(range(len(filter_result)), filter_result):
                    col_2 = QTableWidgetItem(result[3])
                    col_3 = QTableWidgetItem(str(result[2]))
                    col_1 = QTableWidgetItem(result[1])
                    col_1.setCheckState(QtCore.Qt.Unchecked)
                    col_1.id_ = result[0]
                    self.che.tableWidget.setItem(index, 0, col_1)
                    self.che.tableWidget.setItem(index, 1, col_2)
                    self.che.tableWidget.setItem(index, 2, col_3)
                    self.che.tableWidget.update()
            else:
                self.che.tableWidget.setRowCount(0)
                QMessageBox.warning(self.che, "警告", "当前查询结果为空，请筛选卫星后重新进行查询")
        else:
            QMessageBox.warning(self.che, "警告", "当前比例尺(1:" + str(int(scale)) +")不符合要求，要求比例尺大于1:200000")


    def addMap(self):
        flag = 0
        for index in range(self.che.tableWidget.rowCount()):
            if self.che.tableWidget.item(index, 0).checkState():
                flag += 1
                data_id = self.che.tableWidget.item(index, 0).id_
                url_base = "https://swapi.siweiearth.com/sj_raster/v6/wmts/image_list_tile_mg/system?ak="
                url_base += re['mgt_token']
                url_base += "&image_list="
                url_base += str(data_id)
                url_base += "&srs=EPSG:4326"
                url_base += "&product_id=101&Service=WMTS&Request=GetCapabilities"
                url_base += "&Format=image/png"
                print(url_base)
                raster = iface.addRasterLayer(url_base, self.che.tableWidget.item(index, 0).text())

        if flag == 0:
            QMessageBox.warning(self.che, "警告", "请选择影像信息！")

    def changeCloud(self):
        if self.che.checkBox_cloud.isChecked():
            self.che.spinBox.setReadOnly(False)
            self.che.spinBox.lineEdit().setStyleSheet('color: black; background-color: white;')
        else:
            self.che.spinBox.setReadOnly(True)
            self.che.spinBox.lineEdit().setStyleSheet('color: rgb(220,220,220); background-color: rgb(220,220,220);')

    def changeTime(self):
        if self.che.checkBox_time.isChecked():
            self.che.dateEdit_fromtime.setReadOnly(False)
            self.che.dateEdit_fromtime.lineEdit().setStyleSheet('color: black; background-color: white;')
            self.che.dateEdit_totime.setReadOnly(False)
            self.che.dateEdit_totime.lineEdit().setStyleSheet('color: black; background-color: white;')
        else:
            self.che.dateEdit_fromtime.setReadOnly(True)
            self.che.dateEdit_fromtime.lineEdit().setStyleSheet('color: rgb(220,220,220); background-color: rgb(220,220,220);')
            self.che.dateEdit_totime.setReadOnly(True)
            self.che.dateEdit_totime.lineEdit().setStyleSheet('color: rgb(220,220,220); background-color: rgb(220,220,220);')

    def upload_info(self):
        if self.che.checkBox_SelectAll.isChecked():
            sat_list = ["高分一号", "高分一号B星", "高分一号C星",
                        "高分一号D星", "高分六号", "资源三号02星",
                        "资源三号03星", "CB04A", "资源一号E星", "资源一号F星"]
        else:
            sat_list = []
            if self.che.checkBox_GF1.isChecked():
                sat_list.append("高分一号")
            if self.che.checkBox_GF2.isChecked():
                sat_list.append("高分二号")
            if self.che.checkBox_GF1B.isChecked():
                sat_list.append("高分一号B星")
            if self.che.checkBox_GF1C.isChecked():
                sat_list.append("高分一号C星")
            if self.che.checkBox_GF1D.isChecked():
                sat_list.append("高分一号D星")
            if self.che.checkBox_GF6.isChecked():
                sat_list.append("高分六号")
            if self.che.checkBox_GF7.isChecked():
                sat_list.append("高分七号")
            if self.che.checkBox_ZY302.isChecked():
                sat_list.append("资源三号02星")
            if self.che.checkBox_ZY303.isChecked():
                sat_list.append("资源三号03星")
            if self.che.checkBox_CB04.isChecked():
                sat_list.append("CB04星")
            if self.che.checkBox_ZY1E.isChecked():
                sat_list.append("资源一号E星")
            if self.che.checkBox_ZY1F.isChecked():
                sat_list.append("资源一号F星")

        return sat_list

    # def province_select(self):
    #     province_list = ["北京市","天津市","河北省","黑龙江省","吉林省","辽宁省","内蒙古自治区","山西省"]
    #     self.rgs.province_select.loadItems(province_list)





    # def upload_info(self):
    #     item_list = self.che.comboBox_res.Selectlist()
    #     sat_list = []
    #     #sat_list = ["高分一号", "高分二号", "高分一号B星", "高分一号C星", "高分一号D星", "高分六号", "高分七号", "资源三号02星", "资源三号03星", "CB04A"]
    #     switch = {"2米分辨率": self.functionA, "0.8米分辨率": self.functionB, "0.5米分辨率": self.functionC}
    #     for item in item_list:
    #         try:
    #             sat_list = sat_list + switch[item]()
    #         except KeyError as e:
    #             pass
    #     global comboBox_sat
    #     self.che.comboBox_sat.loadItems(sat_list)
    #
    # def functionA(self):
    #     return ["高分一号", "高分一号B星", "高分一号C星",
    #             "高分一号D星", "高分六号", "资源三号02星",
    #             "资源三号03星", "CB04A","资源一号E星","资源一号F星"]
    #
    # def functionB(self):
    #     return ["高分二号"]
    #
    # def functionC(self):
    #     return ["高分七号"]

cities = {'北京市': ['怀柔区','密云区','平谷区','延庆区','昌平区','海淀区','顺义区','朝阳区','东城区','西城区','石景山区','门头沟区','大兴区','房山区','丰台区'],
 '天津市': ['和平区','河东区','河西区','南开区','河北区','红桥区','东丽区','西青区','津南区','北辰区','武清区','宝坻区','滨海新区','宁河区','静海区','蓟州区'],
 '上海市': ['黄浦区','徐汇区','长宁区','静安区','普陀区','虹口区','杨浦区','闵行区','宝山区','嘉定区','浦东新区','金山区','松江区','青浦区','奉贤区','崇明区'],
 '重庆市': ['万州区','涪陵区','渝中区','大渡口区','江北区','沙坪坝区','九龙坡区','南岸区','北碚区','綦江区','大足区','渝北区','巴南区','黔江区','长寿区','江津区','合川区','永川区','南川区','璧山区','铜梁区','潼南区','荣昌区','开州区','梁平区','武隆区','城口县','丰都县','垫江县','忠县','云阳县','奉节县','巫山县','巫溪县','石柱土家族自治县','秀山土家族自治县','酉阳土家族自治县','彭水苗族土家族自治县'],
 '香港特别行政区': ['香港特别行政区'],
 '澳门特别行政区': ['澳门特别行政区'],
 '河北省': ['石家庄市',
  '唐山市',
  '秦皇岛市',
  '邯郸市',
  '邢台市',
  '保定市',
  '张家口市',
  '承德市',
  '沧州市',
  '廊坊市',
  '衡水市'],
 '山西省': ['太原市',
  '大同市',
  '阳泉市',
  '长治市',
  '晋城市',
  '朔州市',
  '晋中市',
  '运城市',
  '忻州市',
  '临汾市',
  '吕梁市'],
 '内蒙古自治区': ['呼和浩特市','兴安盟','锡林郭勒盟','阿拉善盟',
  '包头市',
  '乌海市',
  '赤峰市',
  '通辽市',
  '鄂尔多斯市',
  '呼伦贝尔市',
  '巴彦淖尔市',
  '乌兰察布市'],
 '辽宁省': ['沈阳市', '大连市','鞍山市','抚顺市','本溪市','丹东市','锦州市','营口市','阜新市','辽阳市','盘锦市','铁岭市','朝阳市','葫芦岛市'],
 '吉林省': ['长春市','吉林市','四平市','辽源市','通化市','白山市','松原市','白城市','延边朝鲜族自治州'],
 '黑龙江省': ['哈尔滨市','齐齐哈尔市','鸡西市','鹤岗市','双鸭山市','大庆市','伊春市','佳木斯市','七台河市','牡丹江市','黑河市','绥化市','大兴安岭地区'],
 '江苏省': ['南京市',
  '徐州市',
  '连云港市',
  '宿迁市',
  '淮安市',
  '盐城市',
  '扬州市',
  '泰州市',
  '南通市',
  '镇江市',
  '常州市',
  '无锡市',
  '苏州市'],
 '浙江省': ['杭州市',
  '宁波市','金华市',
  '湖州市',
  '嘉兴市',
  '舟山市',
  '绍兴市',
  '衢州市',
  '台州市',
  '温州市',
  '丽水市'],
 '安徽省': ['合肥市',
  '芜湖市',
  '蚌埠市',
  '淮南市',
  '马鞍山市',
  '淮北市',
  '铜陵市',
  '安庆市',
  '黄山市',
  '滁州市',
  '阜阳市',
  '宿州市',
  '六安市',
  '亳州市',
  '池州市',
  '宣城市'],
 '福建省': ['厦门市',
  '福州市',
  '南平市',
  '三明市',
  '莆田市',
  '泉州市',
  '漳州市',
  '龙岩市',
  '宁德市'],
 '江西省': ['南昌市',
  '九江市',
  '景德镇市',
  '鹰潭市',
  '新余市',
  '萍乡市',
  '赣州市',
  '上饶市',
  '抚州市',
  '宜春市',
  '吉安市'],
 '山东省': ['济南市',
  '青岛市',
  '聊城市',
  '德州市',
  '东营市',
  '淄博市',
  '潍坊市',
  '烟台市',
  '威海市',
  '日照市',
  '临沂市',
  '枣庄市',
  '济宁市',
  '泰安市',
  '滨州市',
  '菏泽市'],
 '河南省': ['郑州市',
  '开封市',
  '洛阳市',
  '平顶山市',
  '安阳市',
  '鹤壁市',
  '新乡市',
  '焦作市',
  '濮阳市',
  '许昌市',
  '漯河市',
  '三门峡市',
  '南阳市',
  '商丘市',
  '周口市',
  '驻马店市',
  '信阳市','济源市'],
 '湖北省': ['武汉市',
  '十堰市',
  '襄阳市',
  '荆门市',
  '孝感市',
  '黄冈市',
  '鄂州市',
  '黄石市',
  '咸宁市',
  '荆州市',
  '宜昌市',
  '随州市','荆州市','仙桃市','潜江市','天门市','神农架林区'],
 '湖南省': ['长沙市',
  '衡阳市',
  '张家界市',
  '常德市',
  '益阳市',
  '岳阳市',
  '株洲市',
  '湘潭市',
  '郴州市',
  '永州市',
  '邵阳市',
  '怀化市',
  '娄底市','湘西土家族苗族自治州'],
 '广东省': ['广州市',
  '深圳市',
  '清远市',
  '韶关市',
  '河源市',
  '梅州市',
  '潮州市',
  '汕头市',
  '揭阳市',
  '汕尾市',
  '惠州市',
  '东莞市',
  '珠海市',
  '中山市',
  '江门市',
  '佛山市',
  '肇庆市',
  '云浮市',
  '阳江市',
  '茂名市',
  '湛江市'],
 '广西壮族自治区': ['南宁市',
  '桂林市',
  '柳州市',
  '梧州市',
  '贵港市',
  '玉林市',
  '钦州市',
  '北海市',
  '防城港市',
  '崇左市',
  '百色市',
  '河池市',
  '来宾市',
  '贺州市'],
 '海南省': ['海口市', '三亚市', '三沙市', '儋州市', '文昌市', '琼海市', '万宁市', '东方市', '五指山市',
         '定安县','屯昌县','澄迈县','临高县','白沙黎族自治县','昌江黎族自治县','乐东黎族自治县','陵水黎族自治县','保亭黎族苗族自治县','琼中黎族苗族自治县'],
 '四川省': ['成都市',
  '广元市',
  '绵阳市',
  '德阳市',
  '南充市',
  '广安市',
  '遂宁市',
  '内江市',
  '乐山市',
  '自贡市',
  '泸州市',
  '宜宾市',
  '攀枝花市',
  '巴中市',
  '达州市',
  '资阳市',
  '眉山市',
  '雅安市','阿坝藏族羌族自治州','甘孜藏族自治州','凉山彝族自治州'],
 '贵州省': ['贵阳市', '六盘水市', '遵义市', '安顺市', '毕节市', '铜仁市','黔西南布依族苗族自治州','黔东南苗族侗族自治州','黔南布依族苗族自治州'],
 '云南省': ['昆明市', '曲靖市', '玉溪市', '丽江市', '昭通市', '普洱市', '临沧市', '保山市',
         '楚雄彝族自治州','红河哈尼族彝族自治州','文山壮族苗族自治州','西双版纳傣族自治州','大理白族自治州','德宏傣族景颇族自治州','怒江傈僳族自治州','迪庆藏族自治州'],
 '陕西省': ['西安市',
  '延安市',
  '铜川市',
  '渭南市',
  '咸阳市',
  '宝鸡市',
  '汉中市',
  '榆林市',
  '商洛市','安康市'],
 '甘肃省': ['兰州市',
  '嘉峪关市',
  '金昌市',
  '白银市',
  '天水市',
  '酒泉市',
  '张掖市',
  '武威市',
  '庆阳市',
  '平凉市',
  '定西市',
  '陇南市','临夏回族自治州','甘南藏族自治州'],
 '青海省': ['西宁市', '海东市','海北藏族自治州','黄南藏族自治州','海南藏族自治州','果洛藏族自治州','玉树藏族自治州'],
 '西藏自治区': ['拉萨市', '日喀则市', '昌都市', '林芝市', '山南市', '那曲市','阿里地区'],
 '宁夏回族自治区': ['银川市', '石嘴山市', '吴忠市', '中卫市', '固原市'],
 '新疆维吾尔自治区': ['乌鲁木齐市', '克拉玛依市', '吐鲁番市', '哈密市',
              '昌吉回族自治州','博尔塔拉蒙古自治州','巴音郭楞蒙古自治州','阿克苏地区','克孜勒苏柯尔克孜自治州','喀什地区',
              '和田地区','伊犁哈萨克自治州','塔城地区','阿勒泰地区','石河子市','阿拉尔市','图木舒克市',
              '五家渠市','北屯市','铁门关市','双河市','可克达拉市','昆玉市','胡杨河市','新星市'],
 '台湾省': ['台湾省']}



