# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ShowGml
                                 A QGIS plugin
 Show selected feature geometry in GML format
                              -------------------
        begin                : 2013-11-12
        copyright            : (C) 2013 by Priit Voolaid
        email                : priit.voolaid@mail.ee
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *

# Initialize Qt resources from file resources.py
import resources

# Import the code for the dialog
from showgmldialog import ShowGmlDialog

import ogr
import xml.dom.minidom

class ShowGml:

    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = QFileInfo(QgsApplication.qgisUserDbFilePath()).path() + "/python/plugins/showgml"
        # initialize locale
        localePath = ""
        locale = QSettings().value("locale/userLocale").toString()[0:2]

        if QFileInfo(self.plugin_dir).exists():
            localePath = self.plugin_dir + "/i18n/showgml_" + locale + ".qm"

        if QFileInfo(localePath).exists():
            self.translator = QTranslator()
            self.translator.load(localePath)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Create the dialog (after translation) and keep reference
        self.dlg = ShowGmlDialog()

    def initGui(self):
        # Create action that will start plugin configuration
        self.action = QAction(
            QIcon(":/plugins/showgml/icon.png"),
            u"ShowGML", self.iface.mainWindow())
        # connect the action to the run method
	self.action.triggered.connect(self.run)

        # Add toolbar button and menu item
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu(u"&showGML", self.action)

	# Connect selectionChanged signal to updateUi method
	self.iface.mapCanvas().selectionChanged.connect(self.updateUi)

    def unload(self):
        # Remove the plugin menu item and icon
        self.iface.removePluginMenu(u"&showGML", self.action)
        self.iface.removeToolBarIcon(self.action)

    # run method that performs all the real work
    def run(self):
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        self.dlg.exec_()

    def updateUi(self, layer=None):
	if layer:
	  if layer.selectedFeatureCount() > 0:
	    feat = layer.selectedFeatures()[0]
	    qgis_geom = feat.geometry().asWkb()
	    ogr_geom = ogr.CreateGeometryFromWkb(qgis_geom)
	    gml =  ogr_geom.ExportToGML("SPACE_INDENTATION=NO")
	    
	    #parsed_gml = xml.dom.minidom.parseString(gml)
	    #pretty_gml = parsed_gml.toprettyxml(indent="  ", newl="\n")

	    self.dlg.ui.textBrowser.setPlainText("%s" % gml)
	  else:
	    self.dlg.ui.textBrowser.setPlainText("")

	
