# -----------------------------------------------------------------------------#
# Title:       ShowFeatureCountToggle                                          #
# Author:      Mike Elstermann (#geoObserver)                                  #
# Version:     v0.3                                                            #
# Created:     15.10.2025                                                      #
# Last Change: 25.02.2026                                                      #
# see also:    https://geoobserver.de/qgis-plugins/                            #
#                                                                              #
# This file contains code generated with assistance from an AI                 #
# No warranty is provided for AI-generated portions.                           #
# Human review and modification performed by: Mike Elstermann (#geoObserver)   #
# -----------------------------------------------------------------------------#

import os
from qgis.PyQt import QtWidgets, QtGui
from qgis.core import QgsLayerTreeGroup, QgsLayerTreeLayer


class ShowFeatureCountToggle:
    def __init__(self, iface):
        self.iface = iface
        self.action = None
        self.toolbar = None
        self.plugin_dir = os.path.dirname(os.path.abspath(__file__))
        self.feature_counts_visible = False

    def initGui(self):
        # Toolbar suchen oder erstellen
        tb_name = "geoObserverTools"
        main_window = self.iface.mainWindow()

        for tb in main_window.findChildren(QtWidgets.QToolBar):
            if tb.objectName() == tb_name:
                self.toolbar = tb
                break

        if not self.toolbar:
            self.toolbar = self.iface.addToolBar(tb_name)
            self.toolbar.setObjectName(tb_name)
            self.toolbar.setToolTip("geoObserverTools ...")

        # Aktion erzeugen
        icon_inactive = os.path.join(self.plugin_dir, "button_inactive.png")

        self.action = QtWidgets.QAction(
            QtGui.QIcon(icon_inactive),
            "Objektcounts show/hide",
            main_window
        )

        self.action.setCheckable(False)
        self.action.triggered.connect(self.toggle_counts)

        # In Toolbar einfügen
        self.toolbar.addAction(self.action)

    def unload(self):
        # Aktion und Toolbar-Aufräumung
        if self.action and self.toolbar:
            self.toolbar.removeAction(self.action)

        if self.action:
            try:
                self.iface.removePluginMenu("Show Feature Count Toggle", self.action)
            except Exception:
                pass  # Menüeintrag existiert evtl. nicht mehr

    def toggle_counts(self):
        root = self.iface.layerTreeView().layerTreeModel().rootGroup()
        self.feature_counts_visible = not self.feature_counts_visible

        self._set_counts_on_all(root, self.feature_counts_visible)

        # Icon je nach Zustand setzen
        if self.feature_counts_visible:
            icon_path = os.path.join(self.plugin_dir, "button_active.png")
        else:
            icon_path = os.path.join(self.plugin_dir, "button_inactive.png")

        self.action.setIcon(QtGui.QIcon(icon_path))

    def _set_counts_on_all(self, group, show):
        for child in group.children():

            if isinstance(child, QgsLayerTreeLayer):
                layer = child.layer()

                # Qt5 / Qt6 / QGIS-kompatible Abfrage des Layer-Typs
                if layer and hasattr(layer, "isSpatial") and layer.isSpatial():
                    child.setCustomProperty("showFeatureCount", show)

            elif isinstance(child, QgsLayerTreeGroup):
                self._set_counts_on_all(child, show)