from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.gui import *
import qgis.utils
from qgis.networkanalysis import *
from packageUI import PackageUI


#initialize Qt resources from file resouces.py
import resources

class networking:
    def __init__(self, iface):
        
        self.iface=iface
        self.canvas=self.iface.mapCanvas()
        self.pin=QgsMapToolEmitPoint(self.canvas)
        self.haveDotLayer=False
        self.userPoints=[]
        self.havePLayer=False
    def initGui(self):
        #create action that will start plugin configuration
        self.action=QAction(QIcon(":/plugins/ShortestPath/pin.png"), "Find Shortest Path", self.iface.mainWindow())
        self.action.setWhatsThis("Configuration for test plugin")
        self.action.setStatusTip("Find the Shortest Path")
        QObject.connect(self.action, SIGNAL("triggered()"),self.run)

        #add toolbar button and menu item
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu("&Find Shortest Path", self.action)

        #connect to signal renderComplete which is emitted when canvas rendering is done
        QObject.connect(self.pin, SIGNAL("canvasClicked(const QgsPoint &, Qt::MouseButton)"), self.placePin)
            
    def unload(self):
         #remove the plugin menu item and icon
         self.iface.removePluginMenu("&Add Two Points", self.action)
         self.iface.removeToolBarIcon(self.action)

         #disconnect from signal of the canvas
         QObject.disconnect(self.pin,SIGNAL("canvasClicked(const QgsPoint &, Qt::MouseButton)"),self.placePin)

    def run(self):        
        #create and show a configuration dialog or something similar
        print "NAPlug: run called"
        self.myVLayer=self.iface.activeLayer()
        if self.myVLayer is None:
            reply=QMessageBox.warning(self.iface.mainWindow(),
                                      "Error",
                                      "Please load a vector line Layer")
        else:
             #Call the UI Dialog
            self.myCrs=self.myVLayer.crs()
            self.dialog=PackageUI()
            
        #Show the dialog for the information
            self.dialog.show()
            QObject.connect(self.dialog.ui.btnRouting,
                            SIGNAL("clicked()"), 
                            self.act)
          
        #Change the mouse cursor to pinTool so that user can place points on map
            self.canvas.setMapTool(self.pin)

    def createPLayer(self):
        self.pLayer=QgsVectorLayer("Point","Pins","memory")
        
        self.provider=self.pLayer.dataProvider()
        self.provider.addAttributes([
                QgsField("id",QVariant.Int),
                QgsField("x",QVariant.Double),
                QgsField("y",QVariant.Double)
                ])
        self.pLayer.updateFieldMap()
        QgsMapLayerRegistry.instance().addMapLayer(self.pLayer)
        result=QObject.connect(self.pLayer, SIGNAL("layerDeleted()"),self.DeletePLayer)
        self.havePLayer=True
    def DeletePLayer(self):
        self.havePLayer=False
    
#Place Pins on the map
    def placePin(self, point):
        x=point.x()
        y=point.y()
        self.userPoints.append([x,y])
        if self.havePLayer==False:
            self.createPLayer()
        fc=int(self.provider.featureCount())
        feature=QgsFeature()
        feature.setGeometry(QgsGeometry.fromPoint(point))
        feature.setAttributeMap( {
                0 : QVariant(fc),
                1 : QVariant(x),
                2 : QVariant(y)})
        self.provider.addFeatures([feature])
        self.pLayer.updateExtents()
        self.pLayer.setCacheImage(None)
        self.canvas.refresh()
                                  
        
    def act(self):
        print "act is running"
        print self.userPoints
        self.pointsCount=len(self.userPoints)
        print str(self.pointsCount)
        for i in range (self.pointsCount-1):
            self.pathGraphBuild(self.userPoints[i],self.userPoints[i+1],(i+1))
       
    def pathGraphBuild(self,startPoint,endPoint,pid):
        
        self.director=QgsLineVectorLayerDirector(self.myVLayer,-1,'','','',3)
        self.properter=QgsDistanceArcProperter()
        self.director.addProperter(self.properter)
        
        self.builder=QgsGraphBuilder(self.myCrs)
        
        #Get the Start and End Points for each two pair of points
        sx=startPoint[0]
        sy=startPoint[1]
        ex=endPoint[0]
        ey=endPoint[1]
        sp=QgsPoint(sx,sy)
        ep=QgsPoint(ex,ey)


        tiedPoints=self.director.makeGraph(self.builder,[sp,ep])
        self.graph=self.builder.graph()
        
        tStart=tiedPoints[0]
        tEnd=tiedPoints[1]
        
        idStart=self.graph.findVertex(tStart)
        idEnd=self.graph.findVertex(tEnd)
        
        (tree, cost)=QgsGraphAnalyzer.dijkstra(self.graph, idStart, 0)
        
        if tree[idEnd]==-1:
            print "Path not found"
        else:
            p=[]
            curPos=idEnd
            while curPos != idStart:
                p.append(self.graph.vertex(self.graph.arc(tree[curPos]).inVertex()).point())
                curPos=self.graph.arc(tree[curPos]).outVertex();
            p.append(tStart)
            rb=QgsRubberBand(self.iface.mapCanvas())
            rb.setColor(Qt.red)
            for pnt in p:
                rb.addPoint(pnt)
                
       
