# -*- coding: utf-8 -*-
"""
/***************************************************************************
 e
                                 A QGIS plugin
 e
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-09-09
        git sha              : $Format:%H$
        copyright            : (C) 2022 by e
        email                : e
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon 
from qgis.PyQt.QtWidgets import QAction, QFileDialog
from PyQt5 import uic
from qgis.core import QgsProject, QgsVectorLayer


# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .e_dialog import eDialog
import os.path
import numpy
import netCDF4
import os
from netCDF4 import Dataset
from pathlib import Path
import processing, tempfile
import processing, tempfile 
import webbrowser
 
class e:
    """QGIS Plugin Implementation."""
    
    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'e_{}.qm'.format(locale))
        
        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&e')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        
        
    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Sentinel-5p data explorer', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action
        
        
    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        
        #local path 
        local_path = os.path.dirname(__file__)
        
        icon_path = local_path + '/icon'
        self.add_action(
            icon_path,
            text=self.tr(u'Sentinel-5p data explorer'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    
        
    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&e'),
                action)
            self.iface.removeToolBarIcon(action)
        
        
    def select_file(self):
        options = QFileDialog.Options()
        filename, _filter = QFileDialog.getOpenFileName(self.dlg, "Select outpout file", filter="netCDF4 (*.nc)",options=options)
        self.dlg.comboBox.clear()
        self.dlg.comboBox_2.clear()
        if filename is not '':
            p = netCDF4.Dataset(filename, "r")
            self.dlg.comboBox_2.addItems(list(p.groups.keys()) + list(p.groups['PRODUCT'].groups['SUPPORT_DATA'].groups.keys()))
            self.dlg.lineEdit.setText(filename)
            p.close()
        
    def load(self):
        self.dlg.comboBox.clear()
        if self.dlg.lineEdit.text() is not '':
            d = netCDF4.Dataset(self.dlg.lineEdit.text(), "r")
            if str(self.dlg.comboBox_2.currentText()) == str('PRODUCT'):
                self.dlg.comboBox.addItems(list(d.groups['PRODUCT'].variables.keys()))
            if str(self.dlg.comboBox_2.currentText()) == str('METADATA'):
                self.dlg.comboBox.addItems(list(d.groups[str(self.dlg.comboBox_2.currentText())].variables.keys()))
            else:
                self.dlg.comboBox.addItems(list(d.groups['PRODUCT'].groups['SUPPORT_DATA'].groups[str(self.dlg.comboBox_2.currentText())].variables.keys()))
            d.close()
    
    
    
    def select_out(self):
        self.dlg.textBrowser_2.clear()
        if self.dlg.lineEdit.text() is not '':
            p = netCDF4.Dataset(self.dlg.lineEdit.text(), "r")
            lon = p.groups['PRODUCT'].variables['longitude'][:].__array__().flatten()
            lat = p.groups['PRODUCT'].variables['latitude'][:].__array__().flatten()
            if str(self.dlg.comboBox_2.currentText()) == str('PRODUCT'):
                product = p.groups[str(self.dlg.comboBox_2.currentText())].variables[self.dlg.comboBox.currentText()][:].__array__().flatten()   
            else:
                product = p.groups['PRODUCT'].groups['SUPPORT_DATA'].groups[str(self.dlg.comboBox_2.currentText())].variables[self.dlg.comboBox.currentText()][:].__array__().flatten()   
            data = numpy.array([lon, lat, product])
            self.dlg.textBrowser_2.append(str(data.T))
        options = QFileDialog.Options()
        filename, _filter = QFileDialog.getSaveFileName(self.dlg, "Select destination folder and file name", filter="text (*.txt)",options=options)
        if filename is not '':
            numpy.savetxt(filename, data.T, delimiter="\t", fmt='%1.8f')
            strr = "x" + "\t" + "y" + "\t" + "z"
            with open(filename, 'r+') as f:
                content = f.read()
                f.seek(0, 0)
                f.write(strr.rstrip('\r\n') + '\n' + content)
            uri = f"file:///{filename}?type=csv&delimiter=%5Ct&skipEmptyFields=Yes&maxFields=10000&detectTypes=yes&xField=x&yField=y&zField=z&crs=EPSG:4326&spatialIndex=no&subsetIndex=no&watchFile=no"
            QgsProject.instance().addMapLayer(QgsVectorLayer(uri, str(self.dlg.comboBox.currentText()), 'delimitedtext'))
            p.close()
        
    
    
    def details(self):
        if self.dlg.comboBox.currentText() is not '':
            self.dlg.textBrowser.clear()
            d = netCDF4.Dataset(self.dlg.lineEdit.text(), "r")
            if str(self.dlg.comboBox_2.currentText()) == str('PRODUCT'):
                self.dlg.textBrowser.append(str(d.groups['PRODUCT'].variables[str(self.dlg.comboBox.currentText())]))
            else:
                self.dlg.textBrowser.append(str(d.groups['PRODUCT'].groups['SUPPORT_DATA'].groups[str(self.dlg.comboBox_2.currentText())].variables[str(self.dlg.comboBox.currentText())]))
            d.close()

    def help(self):
        webbrowser.open('https://sentinel-5p-data-explorer-qgis-plugin.000webhostapp.com/README.html')
    
    def hub(self):
        webbrowser.open('https://s5phub.copernicus.eu/dhus/#/home')
        
    def add_layer(self):
        self.dlg.textBrowser_2.clear()
        if self.dlg.lineEdit.text() is not '':
            p = netCDF4.Dataset(self.dlg.lineEdit.text(), "r")
            lon = p.groups['PRODUCT'].variables['longitude'][:].__array__().flatten()
            lat = p.groups['PRODUCT'].variables['latitude'][:].__array__().flatten()
            if str(self.dlg.comboBox_2.currentText()) == str('PRODUCT'):
                product = p.groups[str(self.dlg.comboBox_2.currentText())].variables[self.dlg.comboBox.currentText()][:].__array__().flatten()   
            else:
                product = p.groups['PRODUCT'].groups['SUPPORT_DATA'].groups[str(self.dlg.comboBox_2.currentText())].variables[self.dlg.comboBox.currentText()][:].__array__().flatten()   
            data = numpy.array([lon, lat, product])
            options = QFileDialog.Options()
            filename = os.path.dirname(__file__) + "/bin/product - temp.txt"
            data = data.T
            data[data >= 10000000] = 0
            numpy.savetxt(filename, data, delimiter="\t", fmt='%1.12f')
            strr = "x" + "\t" + "y" + "\t" + "z"
            with open(filename, 'r+') as f:
                content = f.read()
                f.seek(0, 0)
                f.write(strr.rstrip('\r\n') + '\n' + content)
                f.close()

            uri = f"file:///{filename}?type=csv&delimiter=%5Ct&skipEmptyFields=Yes&maxFields=10000&detectTypes=yes&xField=x&yField=y&zField=z&crs=EPSG:4326&spatialIndex=no&subsetIndex=no&watchFile=no"
            Lname = str(self.dlg.comboBox.currentText()) + '__' + str(p.__dict__['time_reference'])
            QgsProject.instance().addMapLayer(QgsVectorLayer(uri, Lname, 'delimitedtext'))
            self.dlg.textBrowser_2.append( Lname + '\n' + ' Layer load successfully!')
            p.close()
    
    def run(self):
        """Run method that performs all the real work"""
        
        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = eDialog()
            self.dlg.pushButton.clicked.connect(self.select_file)
            self.dlg.pushButton_3.clicked.connect(self.load)
            self.dlg.pushButton_2.clicked.connect(self.select_out)
            self.dlg.pushButton_6.clicked.connect(self.details)
            self.dlg.pushButton_4.clicked.connect(self.help)
            self.dlg.pushButton_5.clicked.connect(self.hub)
            self.dlg.pushButton_7.clicked.connect(self.add_layer)

        # show the dialog
        self.dlg.show()
        
        # Run the dialog event loop
        result = self.dlg.exec_()
        
        
        
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            self.dlg.comboBox.clear()
            self.dlg.comboBox_2.clear()
            self.dlg.lineEdit.clear()
            self.dlg.textBrowser.clear()
            self.dlg.textBrowser_2.clear()
            pass
 