# -*- coding: utf-8 -*-
"""
/***************************************************************************
 SensorThingsAPI
 
 The plugin enables QGIS software (www.qgis.org) to access dynamic data from sensors, 
 using SensorThingsAPI protocol (https://www.ogc.org/standards/sensorthings)
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-04-22
        copyright            : (C) 2024 by Deda Next (Sandro Moretti)
        email                : sandro.moretti@dedagroup.it
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 This script initializes the plugin, making it known to QGIS.
"""

#: Constant name of plugin
__QGIS_PLUGIN_NAME__ = 'SensorThingsInspector'

#: Constant to enable debug messages in plugin log.
__PLG_DEBUG__ = False

#: Global instance of configuration class
plgConfig = None



# noinspection PyPep8Naming
def classFactory(iface):  # pylint: disable=invalid-name
    """Load SensorThingsInspector class from file SensorThingsInspector.

    :param iface: A QGIS interface instance.
    :type iface: QgsInterface
    """
    
    from SensorThingsAPI.log.logger import QgisLogger as logger
    logger.name = __QGIS_PLUGIN_NAME__
    
    # Instance global configuration class
    from SensorThingsAPI.sensor_things_inspector_config import SensorThingsInspectorConfig
    
    global plgConfig # pylint: disable=W0603
    plgConfig = SensorThingsInspectorConfig()
    
    #
    from SensorThingsAPI.sensor_things_inspector import SensorThingsInspectorPlugin
    
    return SensorThingsInspectorPlugin(iface)
