# Semi-Automatic Classification Plugin

![SCP](semiautomaticclassificationplugin.png) The Semi-Automatic Classification
Plugin (SCP) is a free open source plugin for QGIS that allows for the
supervised classification of remote sensing images, providing tools for the
download, the preprocessing and postprocessing of images.

The overall objective of SCP is to provide a set of intertwined tools for
raster processing in order to make an automatic workflow and ease the land
cover classification, which could be performed also by people whose main field
is not remote sensing.

Search and download is available for Landsat, Sentinel-2 images.
Several algorithms are available for the land cover classification.
This plugin is built on Remotior Sensus library and requires the installation 
of additional dependencies. For more information please visit https://fromgistors.blogspot.com .

## Plugin installation

The SCP is available for QGIS version 4.x.
The SCP is developed with Python 3 and requires the installation of 
Remotior Sensus, GDAL (OGR), NumPy, SciPy and Matplotlib.

For the installation of QGIS and SCP on different operating systems please
follow this [guide](https://semiautomaticclassificationmanual.readthedocs.io/en/latest/installation.html).

## Using the plugin

If you are new to SCP, please follow
this [tutorial](https://semiautomaticclassificationmanual.readthedocs.io/en/latest/tutorial_1.html).

## Web site

All the SCP information is available from
the [SCP website](https://fromgistors.blogspot.com/p/semi-automatic-classification-plugin.html).

## Documentation

Check [the user manual](https://semiautomaticclassificationmanual.readthedocs.io)
or the online [tutorials](https://fromgistors.blogspot.com/search/label/Tutorial)
available.

[Videos](https://www.youtube.com/user/fromgistors) are also available.

## Contributing to the development

If you find some issue that you are willing to fix, code contributions are
welcome. Please read [the development notes](DEVELOPMENT.md) before
contributing.

## Authors

* **Luca Congedo**

## License

This plugin is distributed under a GNU General Public License version 3.

## How to cite

Congedo, Luca, (2021). Semi-Automatic Classification Plugin: A Python tool for
the download and processing of remote sensing images in QGIS. Journal of Open
Source Software, 6(64), 3172, https://doi.org/10.21105/joss.03172

[![DOI](https://joss.theoj.org/papers/10.21105/joss.03172/status.svg)](https://doi.org/10.21105/joss.03172)

## Code on Zenodo

[![DOI](https://zenodo.org/badge/18038317.svg)](https://zenodo.org/badge/latestdoi/18038317)
