# -*- coding: utf-8 -*-
"""
/***************************************************************************
 SeisPlotPy
                                 A QGIS plugin
 SEG-Y Visualization and Navigation
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-11-26
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Arjun V H
        email                : arjunvelliyidathu@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# -*- coding: utf-8 -*-
import os
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QMessageBox
from .resources import *

# Import the custom tool
from .core.map_tool import SeismicNavigationTool

class SeisPlotPy:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor."""
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)
        
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'SeisPlotPy_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        self.actions = []
        self.menu = self.tr(u'&SeisPlotPy')

        self.controllers = [] 
        self.first_start = None
        self.tool = None

    def tr(self, message):
        return QCoreApplication.translate('SeisPlotPy', message)

    def add_action(self, icon_path, text, callback, enabled_flag=True, add_to_menu=True, add_to_toolbar=True, status_tip=None, whats_this=None, parent=None):
        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)
        if status_tip is not None:
            action.setStatusTip(status_tip)
        if whats_this is not None:
            action.setWhatsThis(whats_this)
        if add_to_toolbar:
            self.iface.addToolBarIcon(action)
        if add_to_menu:
            self.iface.addPluginToMenu(self.menu, action)
        self.actions.append(action)
        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        
        # 1. Load Button
        icon_path = ':/plugins/seisplotpy/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Load SEG-Y'),
            callback=self.run,
            parent=self.iface.mainWindow())
            
        # 2. Link Cursor Button
        self.action_link = self.add_action(
            icon_path, 
            text=self.tr(u'Link/Nav Tool'),
            callback=self.activate_tool,
            parent=self.iface.mainWindow(),
            status_tip="Activate to link QGIS cursor with Seismic View"
        )
        self.action_link.setCheckable(True)

        # 3. Initialize the tool
        self.tool = SeismicNavigationTool(self.iface.mapCanvas())
        
        # 4. Connect Tool Signals
        self.tool.canvas_moved.connect(self.broadcast_hover)
        self.tool.canvas_double_clicked.connect(self.broadcast_click)
        
        # 5. About action (menu only, no toolbar icon)
        self.about_action = self.add_action(
            icon_path,
            text=self.tr(u'About SeisPlotPy'),
            callback=self.show_about_dialog,
            parent=self.iface.mainWindow(),
            add_to_toolbar=False
        )

        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        if self.tool and self.iface.mapCanvas().mapTool() == self.tool:
            self.iface.mapCanvas().unsetMapTool(self.tool)
            
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&SeisPlotPy'),
                action)
            self.iface.removeToolBarIcon(action)

    def run(self):
        """Launch a new Controller (Window)"""
        from .controller import MainController
        new_controller = MainController(self.iface)
        self.controllers.append(new_controller)

    def activate_tool(self):
        """Sets our custom tool on the canvas."""
        if self.action_link.isChecked():
            self.iface.mapCanvas().setMapTool(self.tool)
        else:
            self.iface.mapCanvas().unsetMapTool(self.tool)
    
    def show_about_dialog(self):
        """Show a simple About dialog with author and support info."""
        text = (
            "SeisPlotPy is currently being developed and maintained by Arjun V H\n"
            "Contact: arjunvelliyidathu@gmail.com\n\n"
            "SeisPlotPy is released under the GPL-2.0 license.\n\n"
            "Found a bug? Need a feature?\n"
            "Please report it here:\n"
            "https://github.com/arjun-vh/SeisPlotPy-QGIS/issues"
        )

        QMessageBox.information(
            self.iface.mainWindow(),
            "About SeisPlotPy",
            text
        )

    def broadcast_hover(self, point):
        """Send mouse coordinates to ALL windows (even hidden ones)."""
        for ctrl in self.controllers:
            # Only send hover events to visible windows to save performance
            if ctrl.view.isVisible() and hasattr(ctrl, 'handle_map_hover'):
                ctrl.handle_map_hover(point)

    def broadcast_click(self, point):
        """Send double click to ALL windows (including hidden/closed ones)."""
        for ctrl in self.controllers:
            if hasattr(ctrl, 'handle_map_click'):
                ctrl.handle_map_click(point)