# -*- coding: utf-8 -*-
"""
/***************************************************************************
 A QGIS plugin
SaxonyCadastralParcels: Download Flurstuecke Sachsen und Thueringen, Darstellung in QGIS und Konvertierung nach DXF
        copyright            : (C) 2026 by EZUSoft
        email                : qgis (at) makobo.de
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""









from os import path, remove
from qgis.core import QgsNetworkAccessManager
from qgis.PyQt.QtCore import QEventLoop, QTimer, QUrl
from qgis.PyQt.QtNetwork import QNetworkRequest, QNetworkReply

def exec_loop(loop):

    try:
        return loop.exec_()
    except AttributeError:
        return loop.exec()

def is_no_error(reply):

    try:

        return reply.error() == QNetworkReply.NetworkError.NoError
    except AttributeError:

        return reply.error() == QNetworkReply.NoError

def DownLoadOverQT(dlURL, LokFileName, timeout_ms=300000, max_redirects=5):


    def write_file(filename, content):
        if path.exists(filename):
            remove(filename)
        with open(filename, "wb") as f:
            f.write(bytes(content))

    manager = QgsNetworkAccessManager.instance()
    current_url = dlURL
    redirects = 0
    size = None
    status = None

    while redirects <= max_redirects:
        loop = QEventLoop()
        timer = QTimer()
        timer.setSingleShot(True)

        request = QNetworkRequest(QUrl(current_url))
        reply = manager.get(request)

        def on_timeout():
            reply.abort()
            loop.quit()

        def on_finished():
            loop.quit()

        timer.timeout.connect(on_timeout)
        reply.finished.connect(on_finished)

        timer.start(timeout_ms)
        exec_loop(loop)


        try:
            status = reply.attribute(QNetworkRequest.HttpStatusCodeAttribute)
        except Exception:
            status = None


        try:
            redirect_url = reply.header(QNetworkRequest.LocationHeader)
        except Exception:
            redirect_url = None


        if is_no_error(reply) and not redirect_url:
            content = reply.readAll()
            write_file(LokFileName, content)
            size = path.getsize(LokFileName) if path.exists(LokFileName) else None
            reply.deleteLater()
            break


        if redirect_url:
            current_url = str(redirect_url)
            redirects += 1
            reply.deleteLater()
            continue


        reply.deleteLater()
        break

    return size, status





