# -*- coding: utf-8 -*-
"""
/***************************************************************************
 A QGIS plugin
SaxonyCadastralParcels: Download Flurstuecke Sachsen und Thueringen, Darstellung in QGIS und Konvertierung nach DXF
        copyright            : (C) 2026 by EZUSoft
        email                : qgis (at) makobo.de
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

























DEV_STANDALONE = __name__ == "__main__"




import sys
import os
import re
import time
import getpass
import traceback
import tempfile
import codecs
from glob import glob
from itertools import cycle
from configparser import ConfigParser




if not DEV_STANDALONE:
    try:
        from qgis.core import QgsProject, QgsVectorLayer
    except ImportError:
        QgsProject = None
        QgsVectorLayer = None

    try:
        from qgis.utils import iface
    except ImportError:
        iface = None




if not DEV_STANDALONE:
    try:
        from qgis.PyQt.QtCore import QSettings
        from qgis.PyQt.QtWidgets import QApplication, QMessageBox
    except ImportError:
        try:
            from PyQt5.QtCore import QSettings
            from PyQt5.QtWidgets import QApplication, QMessageBox
        except ImportError:
            QSettings = None
            QApplication = None
            QMessageBox = None











try:

    from qt_compat import QGIS_VERSION_INT, QGIS3, QGIS4, QT6
except ImportError:
    from .qt_compat import QGIS_VERSION_INT, QGIS3, QGIS4, QT6


def NodeFindByFullName(FullNode, Start=None):
    if Start is None: 
        Start = QgsProject.instance().layerTreeRoot()
    if isinstance(FullNode, list):
        sNode = FullNode
    else:
        sNode = FullNode.split("\t")
    Gefunden = None
    for node in Start.children():
        if str(type(node)) == "<class 'qgis._core.QgsLayerTreeGroup'>":
            if node.name() == sNode[0]:
                if len(sNode) > 1:
                    Gefunden = NodeFindByFullName(sNode[1:], node)
                else:
                    Gefunden = node
    return Gefunden             

def NodeCreateByFullName(FullNode, Start=None):



    ToDo = 0
    if Start is None: 
        Start = QgsProject.instance().layerTreeRoot()
    if isinstance(FullNode, list):
        sNode = FullNode
    else:
        sNode = FullNode.split("\t")
    Found = False
    for node in Start.children():
        if str(type(node)) == "<class 'qgis._core.QgsLayerTreeGroup'>":
            if node.name() == sNode[0]: 
                Found = True
                break
    if not Found: 
        node = Start.addGroup(sNode[0])
        ToDo += 1
    if len(sNode) > 1:
        node, ReToDo = NodeCreateByFullName(sNode[1:], node)
        ToDo += ReToDo
    return node, ToDo

def NodeRemoveByFullName(FullNode, Start=None):
    if Start is None: 
        Start = QgsProject.instance().layerTreeRoot()
    if isinstance(FullNode, list):
        sNode = FullNode
    else:
        sNode = FullNode.split("\t")
    delNodeName = sNode[-1]
    if len(sNode) > 1:
        parent = NodeFindByFullName(sNode[:-1], Start)
    else:
        parent = Start
    if not parent: 
        return False
    for node in parent.children():
        if str(type(node)) == "<class 'qgis._core.QgsLayerTreeGroup'>":
            if node.name() == delNodeName:
                parent.removeChildNode(node)
                return True


def toUnicode(text):


    if isinstance(text, str):
        return text
    elif isinstance(text, bytes):
        return text.decode("utf8")
    else:
        return str(text)
    
glFehlerListe = []
glHinweisListe = []

def addFehler(Fehler): 
    glFehlerListe.append(toUnicode(Fehler))

def getFehler():
    return glFehlerListe

def resetFehler():
    global glFehlerListe
    glFehlerListe = []  

def addHinweis(Hinweis):
    glHinweisListe.append(toUnicode(Hinweis))

def getHinweis2String():
    return "\n".join(glHinweisListe)

def getHinweis():
    return glHinweisListe

def resetHinweis():
    global glHinweisListe
    glHinweisListe = [] 

def fncPluginVersion():
    config = ConfigParser()
    config.read(os.path.join(os.path.dirname(__file__), 'metadata.txt'))
    return config.get('general', 'version')
    
def subLZF(Sonstiges=None):

    exc_type, exc_obj, exc_tb = sys.exc_info()
    fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
    tb_lineno = exc_tb.tb_lineno
    try:
        QgsMessageLog.logMessage(
            traceback.format_exc().replace("\n", chr(9)) + 
            (chr(9) + Sonstiges if Sonstiges else ""), 
            'EZUSoft:Error'
        )
    except:
        pass
    addFehler(
        "LZF:" + traceback.format_exc().replace("\n", chr(9)) + 
        (chr(9) + Sonstiges if Sonstiges else "")
    )    

def cut4view(fulltext, zeichen=1500, zeilen=15, anhang='\n\n                  ............. and many more .........\n'):
    cut = False
    ctext = fulltext
    if len(fulltext) > zeichen:
        cut = True
        ctext = ctext[:zeichen]
    arr = ctext.split('\n')
    if len(arr) > zeilen:
        cut = True
        ctext = '\n'.join(arr[:zeilen])
    if cut:
        ctext = ctext + anhang
    return ctext
 
def errbox(text, p=None):
    su = toUnicode(text)
    QMessageBox.critical(None, "PlugIn Error", cut4view(su))
    try:
        QgsMessageLog.logMessage(su, 'EZUSoft:Error')
    except:
        pass

def msgbox(text):
    su = toUnicode(text)
    QMessageBox.information(None, "PlugIn Hinweis", cut4view(su))
    try:
        QgsMessageLog.logMessage(su, 'EZUSoft:Hinweise')
    except:
        pass

def errlog(text, DebugMode=False):
    su = toUnicode(text)   
    if DebugMode:
        QMessageBox.information(None, "DEBUG:", su)
    try:
        QgsMessageLog.logMessage(su, 'EZUSoft:Fehler')
    except:
        pass

def EZUTempClear(All=None):
    Feh = 0
    Loe = 0
    tmp = EZUTempDir()
    if All:
        for dat in glob(tmp + '*.*'):
            try:
                os.remove(dat)
                Loe += 1
            except:
                Feh += 1
    else:
        for shp in glob(tmp + '*.shp'):
            try:
                os.remove(shp)
                Loe += 1
                for rest in glob(shp[0:-4] + '.*'):
                    os.remove(rest)
                    Loe += 1
            except:
                Feh += 1
    return Loe, Feh

def EZUTempDir():
    tmp = (tempfile.gettempdir()).replace("\\", "/") + "/{D5E6A1F8-392F-4241-A0BD-5CED09CFABC7}/"
    if not os.path.exists(tmp):
        os.makedirs(tmp) 
    if os.path.exists(tmp):
        return tmp
    else:
        QMessageBox.critical(None, "Program termination", "Temporary directory\n%s\ncan not be created" % tmp)
        return None


def debuglog(text, DebugMode=False):
    if DebugMode:
        su = toUnicode(text)   
        try:
            QgsMessageLog.logMessage(su, 'EZUSoft:Debug')
        except:
            pass

def hinweislog(text, p=None):
    su = toUnicode(text)   
    try:
        QgsMessageLog.logMessage(su, 'EZUSoft:Comments')
    except:
        pass
    
def printlog(text, p=None):
    su = toUnicode(text)        
    try:
        print(su)
    except:
        try:
            print(su.encode("utf-8"))
        except:
            print("printlog:Tip can not view")


def fncKorrDateiName(OrgName, Ersatz="_"):
    NeuTex = ""
    for i in range(len(OrgName)):

        if re.search(r"[/\\\[\]:*?|!=]", OrgName[i]):
            NeuTex += Ersatz
        else:
            NeuTex += OrgName[i]
    return NeuTex    

def fncDateCode():
    lt = time.localtime()
    return ("%02i%02i%02i") % (lt[0:3])  

def fncXOR(message, key=None):
    if key is None:
        key = fncDateCode()
    return ''.join(("%0.1X" % (ord(c)^ord(k))).zfill(2) for c, k in zip(message, cycle(key)))

def ifAscii(uText):
    try:
        for char in uText:
            if(ord(char)) > 128:
                return False   
        return True
    except:
        return False 
    
def toUTF8(uText):
    try:
        a = ""
        for char in uText:
            a += chr(ord(char))
        return a
    except:
        return uText    

def tryDecode(txt, sCharset):

    try:
        if isinstance(txt, bytes):
            return txt.decode(sCharset)
        elif isinstance(txt, str):
            return txt
        else:
            return str(txt)
    except:
        return '#decodeerror#'    

def ClearDir(Verz):
    for dat in glob(Verz + '*.*'):
        try:
            os.remove(dat)
        except:
            return False
    return True
    
def fncMakeDatName(OrgName):
    v = OrgName.replace("\\", "/")
    return v.replace("//", "/")

def qXDatAbsolute2Relativ(tmpDat, qlrDat, PathAbsolute):
    subPath = fncMakeDatName(PathAbsolute + "/")
    iDatNum = open(tmpDat, encoding="utf-8")
    oDatNum = open(qlrDat, "w", encoding="utf-8")
    for iZeile in iDatNum:
        s1 = iZeile.replace('source="' + subPath, 'source="./')
        s1 = s1.replace('k="name" v="' + subPath, 'k="name" v="./')
        s1 = s1.replace('<datasource>' + subPath, '<datasource>./')
        oDatNum.write(s1)
    iDatNum.close()
    oDatNum.close()
    os.remove(tmpDat)


def fncUniDatReadAll23(DatName, sEncode="utf-8"):




    with open(DatName, "r", encoding=sEncode) as tmp:
        tmpArray = tmp.readlines()
    return tmpArray

def subUniDatWriteAll23(DatName, Art, zArray, sEncode="utf-8"):




    with open(DatName, Art, encoding=sEncode) as tmp:
        tmp.writelines(zArray)
    
def fncUniDatOpen23(DatName, Art, sEncode="utf-8"):




    return open(DatName, Art, encoding=sEncode)
        
