# -*- coding: utf-8 -*-
"""
/***************************************************************************
 A QGIS plugin
SaxonyCadastralParcels: Download Flurstuecke Sachsen und Thueringen, Darstellung in QGIS und Konvertierung nach DXF
        copyright            : (C) 2026 by EZUSoft
        email                : qgis (at) makobo.de
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""





from xml.dom import minidom
import urllib.request
import locale
import datetime
import uuid
import os
from urllib.parse import quote
from qgis.PyQt.QtCore import QSettings, QT_VERSION_STR
from qgis.core import  Qgis
from qgis.PyQt.QtCore import QEventLoop
try:

    from .fnc4all import *
    from .qt_compat import (
        QUrl, QByteArray,
        QNetworkAccessManager, QNetworkRequest, QNetworkReply,
        HttpStatusCodeAttribute, RedirectionTargetAttribute,
        exec_dialog, QTimer
    )
except ImportError:

    from fnc4all import *
    from qt_compat import (
        QUrl, QByteArray,
        QNetworkAccessManager, QNetworkRequest, QNetworkReply,
        HttpStatusCodeAttribute, RedirectionTargetAttribute,
        exec_dialog, QTimer
    )





def fncProgKennung():

    qt_major = QT_VERSION_STR.split(".")[0]
    return "CastralParcels" + qt_major


def fncProgVersion():
    return "V " + fncPluginVersion()

def fncProgKennung():
    return "CastralParcels|" + fncPluginVersion() + '|' + Qgis.QGIS_VERSION

def CheckVersion(zeit=0, debug=False):
    url = 'https://makobo.de/links/CastralParcels.php?id=' + quote(fncProgKennung() + '|' + str(zeit))

    try:
        request = QNetworkRequest(QUrl(url))
        request.setRawHeader(b"User-Agent", b"QGIS-Plugin-ADXF2Shape")

        manager = QNetworkAccessManager()

        reply = manager.get(request)

        loop = QEventLoop()
        reply.finished.connect(loop.quit)


        timer = QTimer()
        timer.setSingleShot(True)

        def _on_timeout():
            if debug:
                print("CheckVersion: Timeout")
            if reply.isRunning():
                reply.abort()

        timer.timeout.connect(_on_timeout)
        timer.start(3000)   


        exec_dialog(loop)

        timer.stop()


        error_code = reply.error()

        if hasattr(QNetworkReply, 'NetworkError'):
            no_error = QNetworkReply.NetworkError.NoError   
        else:
            no_error = QNetworkReply.NoError                

        if error_code != no_error:
            if debug:
                print("CheckVersion Fehler:", reply.errorString())
        else:
            if debug:
                print("Request erfolgreich")

        reply.deleteLater()

    except Exception as e:
        if debug:
            print("CheckVersion Fehler:", e)












def fncDebugMode():
    if os.path.exists(os.path.dirname(__file__) + '/00-debug.txt'):
        return True
    else:
        return False






def fncBrowserID():
    s = QSettings("EZUSoft", fncProgKennung())
    s.setValue("-id-", (fncProgKennung() + str(uuid.uuid4())))
    return s.value("-id-", "")






def tr(message):
    return message  


def fncCGFensterTitel(intCG=None):
    s = QSettings("EZUSoft", fncProgKennung())
    sVersion = "-"
    if not intCG:
        intCG = int(s.value("cgversion", -1))
    if intCG == 0:
        sVersion = "11.2"
    if intCG == 1:
        sVersion = "2016"
    return (
        u"Download und Konvertierung Inspire Flurstücke   "
        u"(Programmversion " + fncProgVersion() + u")"
    )






def StandAusAtom(XMLDat):
    try:
        usock = urllib.request.urlopen(XMLDat)
        xmldoc = minidom.parse(usock)
        usock.close()

        Ebene1 = xmldoc.getElementsByTagName("feed")
        Ebene2 = Ebene1[0].getElementsByTagName("entry")
        Ebene3 = Ebene2[0].getElementsByTagName("updated")
        sDate = Ebene3[0].firstChild.data[0:10]

        locale.setlocale(locale.LC_ALL, 'de_DE')
        return datetime.datetime.strptime(
            sDate, '%Y-%m-%d'
        ).strftime("%d. %B %Y")

    except Exception:
        return '#unbekannt#'




