# -*- coding: utf-8 -*-
"""
/***************************************************************************
 A QGIS plugin
SaxonyCadastralParcels: Download Flurstuecke Sachsen und Thueringen, Darstellung in QGIS und Konvertierung nach DXF
        copyright            : (C) 2020 by EZUSoft
        email                : qgis (at) makobo.de
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""











DEV_STANDALONE = __name__ == "__main__"




import os
import sys




from qgis.PyQt import uic
from qgis.PyQt.QtCore import QDir
from qgis.PyQt.QtWidgets import QDialog, QApplication




if DEV_STANDALONE:


    from fnc4all import *
    from fnc4SaxonyCadastralParcels import *

else:

    try:
        from .fnc4all import *
        from .fnc4SaxonyCadastralParcels import *
    except ImportError as e:

        from fnc4all import *
        from fnc4SaxonyCadastralParcels import *



d = os.path.dirname(__file__)
QDir.addSearchPath("SaxonyCadastralParcels", d)

   
class uiAbout(QDialog):  
    def __init__(self, parent=None):

        super(uiAbout, self).__init__(parent)
        

        uic.loadUi(os.path.join(d, 'uiAbout.ui'), self)

        

        s = self.lblLink.text()
        s = s.replace("$$Homepage$$", "https://www.makobo.de/links/Home_SaxonyCadastralParcels.php?id=" + fncBrowserID())
        s = s.replace("$$Daten$$", "https://www.makobo.de/links/Daten_SaxonyCadastralParcels.php?id=" + fncBrowserID())
        s = s.replace("$$Forum$$", "https://www.makobo.de/links/Forum_SaxonyCadastralParcels.php?id=" + fncBrowserID())
        s = s.replace("$$Doku$$", "https://www.makobo.de/links/Dokumentation_SaxonyCadastralParcels.php?id=" + fncBrowserID())
        self.lblLink.setText(s)
  

