# 📦 Sample by Features

![Logo Sample by Features](https://plugins.qgis.org/media/cache/6b/b7/6bb7a162257fa7d9de238d7c0dd1bb82.png)

**Autor:** Alex Santos (IBGE)  
**Versão:** 1.3.1  
**Repositório:** [github.com/alxcart/SampleByFeatures](https://github.com/alxcart/SampleByFeatures)

---

## 📖 About (English)

The *Sample by Features* plugin calculates the sample size (n) based on the total population (N) of features in a vector layer. The inspection severity is determined by levels I, II, or III, and the acceptable quality limit (AQL) defines the maximum proportion of nonconforming items.

This plugin follows the methodology defined in **ISO 2859-2** and **ISO 19157:2013** for spatial data quality.

---

## 📖 Sobre (Português)

O plugin *Sample by Features* calcula o tamanho da amostra (n) com base na população de feições (N) de uma camada vetorial. O grau de severidade da inspeção é definido pelos níveis I, II ou III. O limite de qualidade aceitável (AQL) estabelece a proporção máxima de itens não conformes aceitável em uma amostra.

Este plugin é fundamentado nas normas **NBR 5425, 5426, 5427** e na **ISO 19157:2013**, voltadas para controle e avaliação da qualidade de dados espaciais.

---

## ✨ Principais Recursos

- Compatível com QGIS 3.x
- Interface simples e intuitiva
- Baseado em normas internacionais
- Exportação direta dos resultados

---

## 📝 Changelog

- ✅ Ajuste no formato da data (agora `YYYYMMDD`)
- ✅ Otimização de scripts
- ✅ Adição do campo `layer` nos resultados
- ✅ Melhorias visuais e correções de bugs menores

---

## 🔗 Links

- 📦 [Repositório GitHub](https://github.com/alxcart/SampleByFeatures)
- 📚 [Documentação Wiki](https://github.com/alxcart/SampleByFeatures/wiki)
- ❓ [Relatar problemas](https://github.com/alxcart/SampleByFeatures/issues)

---

> Desenvolvido por Alex Santos – IBGE  
> Este plugin faz parte de uma linha de ferramentas voltadas ao controle de qualidade de dados geoespaciais.
