# -*- coding: utf-8 -*-
"""
/***************************************************************************
 SampleByFeature
                                 A QGIS plugin

This plugin calculates the sample size (n) from the population size (N), according to ISO 2859-2.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-04-14
        modify               : 2019-07-04
        version              : 0.2
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Alex Santos
        email                : alxcart@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QAction, QFileDialog, QMessageBox

from qgis.core import *
from math import ceil
import os.path 
from osgeo import ogr
import random

from .constants import * # constants of project

# based on the clip_multiple_layers plugin
import processing, os, subprocess, time
from qgis.utils import *

from qgis.PyQt.QtCore import *

from processing.algs.gdal.GdalUtils import GdalUtils

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .samplebyfeatures_dialog import SampleByFeatureDialog

class SampleByFeature:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'SampleByFeature_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Create the dialog (after translation) and keep reference
        self.dlg = SampleByFeatureDialog()

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Sample by feature')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        #self.first_start = None
        
        #Connecting the buttons and actions / Conectando os botoes e acoes
        self.dlg.lineEdit.clear()

        self.initFolder();
        self.dlg.pushButton.clicked.connect(self.select_output_file);


    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('SampleByFeature', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToVectorMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/SampleByFeatures/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Sample by feature'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginVectorMenu(
                self.tr(u'&Sample by feature'),
                action)
            self.iface.removeToolBarIcon(action)

    def initFolder(self):
        path_project = QgsProject.instance().fileName()
        path_project = path_project[:path_project.rfind("/"):]

        self.folderName = path_project

        self.dlg.lineEdit.setText(self.folderName);

    def select_output_file(self):
    #Select output folder / Seleciona a pasta de saida
        folderTmp = QFileDialog.getExistingDirectory(self.dlg, "Select output folder ", self.folderName)
        if folderTmp != "":
            self.folderName = folderTmp
        self.dlg.lineEdit.setText(self.folderName);

    def isFileOpened(self, file_path):
        if os.path.exists(file_path):
            try:
                os.rename(file_path, file_path+"_")
                os.rename(file_path+"_", file_path)
                return False
            except OSError as e:
                return True

    def run(self):
        """Run method that performs all the real work"""
        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = SampleByFeatureDialog()
            self.dlg.pushButton.clicked.connect(self.select_output_file)

        # Preenchendo o comboBox (principal)
        self.dlg.comboBox.clear()
        #self.dlg.comboBoxLevel.clear()

        layers = QgsProject.instance().mapLayers().values()
        for layer in layers:
            if layer.type() == QgsMapLayer.VectorLayer :
                self.dlg.comboBox.addItem( layer.name(), layer )

        # show the dialog
        self.dlg.show()

        # Run the dialog event loop
        result = self.dlg.exec_()

        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            #filename = self.dlg.lineEdit.text()

            if not os.path.isdir(self.folderName):
                raise FileNotFoundError(
                    errno.ENOENT, os.strerror(errno.ENOENT), self.folderName)

            directory = self.folderName + "/sample_features"
            if not os.path.exists(directory):
                os.makedirs(directory)

            ### Begin to simulate in the python terminal 
            #ly = iface.activeLayer()
            #ly.name()
            #selection = ly
            #dp = ly.dataProvider()
            #lyrInput = selection
            #Nivel_de_Inspecao = 1
            #path_project = QgsProject.instance().fileName()
            #path_project = path_project[:path_project.rfind("/"):]
            #directory = path_project + "/sample_features"
            ### End to simulate in the python terminal

            #Input data selection 
            index = self.dlg.comboBox.currentIndex()
            selection = self.dlg.comboBox.itemData(index)
            checkedLayers = QgsProject.instance().layerTreeRoot().checkedLayers()
            
            # Data provider from selection 
            Camada = selection  ###
            dp = selection.dataProvider()
            provider = dp       ###
            geometry = selection.wkbType()
            crs = provider.crs()
            encoding = dp.encoding()

            # Data features from selection 
            lyrInput = QgsVectorLayer.getFeatures(selection) # substituir camada por selection OK

            features = QgsVectorLayer.getFeatures(selection)
            featureCount = len(selection) # substituir camada por selection - OK
            
            #fields = QgsFields() # utilizar na inspecao por area 
            fields = provider.fields()
            fields.append(QgsField("id_measure", QVariant.Int))
            fields.append(QgsField("checked", QVariant.String))
            fields.append(QgsField("status", QVariant.String))

            # Sampling plan / Plano de amostragem
            Nivel_de_Inspecao = self.dlg.comboBoxLevel.currentIndex()
            #dicSampleLength={2:[2,2,3],9:[2,3,5],16:[3,5,8],26:[5,8,13],51:[5,13,20],91:[8,20,32],151:[13,32,50],281:[20,50,80],501:[32,80,125],1201:[50,125,200],3201:[80,200,315],10001:[125,315,500],35001:[200,500,800],150001:[315,800,1250],500001:[500,1250,2000]}

            # Function select sample # Seleciona amostra
            #Input: featureCount (area ou feicoes)
            #Output: sample_size (tamanho da amostra)                        
            for i in sorted(dicSampleLength.keys(),reverse=True):
                if featureCount >= i:
                    index1 = i
                    break

            randomNum = random.sample(range(featureCount),1)[0]
            sample_size=dicSampleLength[index1][Nivel_de_Inspecao]

            isSelectedId = random.sample(range(featureCount), sample_size)

            #Prepare output / Preparar saida
            pth = directory
            filename = os.path.join(pth + "/sample_" + selection.name() +".shp")
            ds = ogr.GetDriverByName("Esri Shapefile")

            file = QgsVectorFileWriter(filename, encoding, fields, geometry, crs, ds.name)

            for i, feat in enumerate(features):
                if i in isSelectedId:
                    file.addFeature(feat)
            del file
           
            iface.addVectorLayer(filename, "", "ogr")

            QMessageBox.about(None, "Simple random sampling", "Sampling units created")
