# Sample by Area

![Logo sample by area](https://plugins.qgis.org/media/cache/f9/2c/f92cac6c1fc3bac1f4a406495ddcd766.png)

### by Alex Santos (IBGE)  
**Version**: 1.3.0  
**GitHub**: [alxcart](https://github.com/alxcart/SampleByArea)

---

## 📌 About (English)

The population size (N) is the dimension of the area of interest (AOI), divided by the dimension of the inspection areas. The plugin is capable of working with isolated elements, in addition to continuous areas, generating a number of samples according to the statistical precepts present in ISO standards.

- **Inspection level I, II or III** indicates the degree of severity of the inspection.
- **Acceptable Quality Limit (AQL)** is the percentage of undesired items tolerated in your dataset.

This sampling plan is based on the Brazilian standards NBR 5425, 5426, and 5427 (translations of the ISO 2859 series).  
Given the population size (N), the AQL and inspection level, the plan determines the sample size (n), acceptance number (Ac), and rejection number (Re) to support decisions regarding dataset quality.

---

## 📌 Sobre (Português)

O tamanho da população (N) é a dimensão da área de interesse (AOI), dividido pela dimensão da área de inspeção. O plugin é capaz de trabalhar com elementos isolados, além de áreas contínuas, gerando um número de amostras de acordo com preceitos estatísticos presentes nas normas ISO.

- **Nível de inspeção I, II ou III** indica o grau de severidade da inspeção.
- **Limite de Qualidade Aceitável (LQA)** é o percentual de itens não conformes aceito no conjunto de dados.

O plano de amostragem é baseado nas normas brasileiras NBR 5425, 5426 e 5427 (traduções da série ISO 2859).  
Com base no tamanho da população (N), no LQA e no nível de inspeção, o plano indica o tamanho da amostra (n) e os números de aceitação (Ac) e rejeição (Re), orientando a decisão de aprovação ou reprovação dos dados avaliados.

---

**🔗 Project Homepage:** [GitHub - SampleByArea](https://github.com/alxcart/SampleByArea)

**📂 Plugin Tags:**  
`sampling plan`, `spatial data quality`, `sample`, `area`, `vector`, `quality`, `ISO 19157:2013`, `ISO 2859`, `AQL`, `LQA`, `geopackage`

