# -*- coding: utf-8 -*-
"""
/***************************************************************************
 STLGeneratorDialog
                                 A QGIS plugin
 This plugin lets you generate an STL from a DEM and allows the exclusion of nodata regions.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2022-03-30
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Suheyb Aden
        email                : suheyb1@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from email import message
import os
import sys
from threading import Thread
from .mesh_generator import MeshGenerator, MeshGeneratorError

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets, QtCore
from qgis.PyQt.QtWidgets import QMessageBox

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
sys.path.append(os.path.dirname(__file__))
FORM_CLASS, _ = uic.loadUiType(
    os.path.join(os.path.dirname(__file__), "stl_generator_dialog_base.ui")
)


class STLGeneratorDialog(QtWidgets.QDialog, FORM_CLASS):
    start_backend = QtCore.pyqtSignal(object, str)

    def __init__(self, parent=None):
        """Constructor."""
        super(STLGeneratorDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.start_thread()

        self.saveLocation_input.setFilePath(os.path.expanduser("~"))

        # Indicates if a background process is already running or not
        self.running = False

    # Connects signals and slots between UI elements and background process
    def connect_signals(self):
        # UI related signals
        self.generateSTL_button.clicked.connect(self.begin_generating_STL)
        self.exit_button.clicked.connect(self.close_window)

        # Background process signals
        self.worker.progress_changed.connect(self.progress.setValue)
        self.worker.progress_text.connect(self.progress.setFormat)
        self.worker.finished.connect(self.finished_generating_STL)
        self.worker.handle_generator_error.connect(self.handle_generator_error)

        self.start_backend.connect(self.worker.generate_STL)

        # self.worker_thread.finished.connect(self.worker_thread.deleteLater)

    # Starts thread for background process
    def start_thread(self):
        self.worker = WorkerObject()
        self.worker_thread = QtCore.QThread()
        self.worker.moveToThread(self.worker_thread)
        self.worker_thread.start()

        self.connect_signals()

    # Performs setup routine before starting to generate STL in background thread
    def begin_generating_STL(self):

        if not self.running:
            self.progress.setValue(0)
            self.progress.setFormat("%p% Beginning to Generate STL...")

            # Set the parameters for generating the STL file
            self.running = True
            self.start_backend.emit(
                {
                    "printHeight": self.printHeight_input.value(),
                    "baseHeight": self.baseHeight_input.value(),
                    "saveLocation": os.path.join(
                        self.saveLocation_input.filePath(),
                        self.layers_comboBox.currentLayer().name() + ".stl",
                    ),
                    "bedX": self.bedWidth_input.value(),
                    "bedY": self.bedLength_input.value(),
                    "lineWidth": self.lineWidth_input.value(),
                },
                self.layers_comboBox.currentLayer().source(),
            )

    def finished_generating_STL(self):
        self.running = False

    def stop_thread(self):
        self.finished_generating_STL()

        if self.worker_thread.isRunning():
            self.worker_thread.exit()
            self.worker_thread.wait()

    @QtCore.pyqtSlot(object)
    def handle_generator_error(self, error: MeshGeneratorError):
        QMessageBox.critical(self, self.tr("Error"), self.tr(error.message))

    # Closes dialog window
    def close_window(self):
        self.stop_thread()
        self.close()


# Worker that contains all the work done in the background thread
class WorkerObject(QtCore.QObject):
    progress_changed = QtCore.pyqtSignal(int)
    progress_text = QtCore.pyqtSignal(str)
    handle_generator_error = QtCore.pyqtSignal(object)
    finished = QtCore.pyqtSignal()

    def __init__(self) -> None:
        super().__init__()
        self.mesh_generator = MeshGenerator()
        self.running = False

    # Generates STL file on button press
    @QtCore.pyqtSlot(object, str)
    def generate_STL(self, parameters, path):
        try:
            self.progress_changed.emit(10)
            self.progress_text.emit("%p% Reading Raster Data...")
            self.mesh_generator.generate_height_array(
                parameters, source_dem=path
            )

            self.progress_changed.emit(60)
            self.progress_text.emit("%p% Putting Together STL File...")
            self.mesh_generator.manually_generate_stl()

            self.progress_changed.emit(100)
            self.progress_text.emit("%p% Finished Generating STL File!")
        except Exception as e:
            self.handle_generator_error.emit(e)
            self.progress_text.emit("Failed to Generate STL : " + str(e))
            self.finished.emit()

        self.finished.emit()
