# -*- coding: utf-8 -*-

"""
/***************************************************************************
 ServeisEcosistemics
                                 A QGIS plugin
 Genera uns seguit de capes per a la visualització dels beneficis dels servesi ecosistemics.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-01-25
        copyright            : (C) 2022 by ICRA
        email                : ariu@icra.cat
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'ICRA'
__date__ = '2022-01-25'
__copyright__ = '(C) 2022 by ICRA'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect
import processing

from PyQt5.QtCore import *
from PyQt5.QtGui import *
from PyQt5.QtWidgets import *
from qgis.core import *
from .serveis_eco_provider import ServeisEcosistemicsProvider

from .serveis_eco_algorithm import ServeisEcosistemicsAlgorithm
from .serveis_eco_algorithm_bak import ServeisEcosistemicsAlgorithm2
from .allProcess.VEPHidro import ProducciHidroelctricaVephidro as VEPHidro

from processing.gui.AlgorithmDialog import AlgorithmDialog

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class ServeisEcosistemicsPlugin(object):

    def __init__(self, iface):
        self.provider = None
        self.iface = iface
        self.provider = ServeisEcosistemicsProvider()

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""

        QgsApplication.processingRegistry().addProvider(self.provider)

    def vephidro(self):
        servei = VEPHidro()
        servei.initAlgorithm()
        servei.setProvider(self.provider)
        dlg = AlgorithmDialog(servei, parent=self.iface.mainWindow())
        dlg.show()
        # do NOT remove!!!! if you do then sip forgets the python subclass of AlgorithmDialog and you get a broken
        # dialog
        dlg.exec_()

    def initGui(self):
        # create action that will start plugin configuration

        self.menu = QMenu("S+HydPower", self.iface.mainWindow().menuBar())
        self.action_Hidro = QAction("Execute", self.iface.mainWindow())

        #self.action_ACB = QAction("ACB", self.iface.mainWindow())



        actions = self.iface.mainWindow().menuBar().actions()
        lastAction = actions[-1]
        self.iface.mainWindow().menuBar().insertMenu(lastAction, self.menu)
        self.menu.addAction(self.action_Hidro)

        self.action_Hidro.triggered.connect(self.vephidro)

        self.initProcessing()

    def unload(self):
        self.menu.deleteLater()
        # self.iface.removeToolBarIcon(self.action)

        QgsApplication.processingRegistry().removeProvider(self.provider)

