# SIOSE2Manning

SIOSE2Manning is a QGIS plugin that automatically assigns Manning roughness coefficients to SIOSE AR 2016, 2017, 2018 y 2020 polygons using the dominant land cover (ID_COBERTURA_MAX) and clips them to a user-defined Area of Interest (AOI).

The plugin is designed to streamline hydraulic and hydrological modelling workflows such as HEC-RAS, converting SIOSE AR land cover data into ready-to-use roughness layers.

## Main features

- Load SIOSE AR GeoPackage (GPKG)
- Automatically detect the T_COMBINADA layer via ID_COBERTURA_MAX
- Select an Area of Interest (AOI) by clicking on any visible polygon layer
- Clip SIOSE AR polygons to the selected AOI
- Assign Manning roughness values automatically based on ID_COBERTURA_MAX
- Calculate polygon areas in square meters (m2) and hectares (ha)
- Generate a clean output layer ready for hydraulic modelling

## Methodology

This version assigns Manning n using the dominant land cover classification ID_COBERTURA_MAX from the T_COMBINADA layer of SIOSE AR.

Each dominant land cover ID is mapped to a predefined Manning coefficient using an internal lookup table.

Future versions may include weighted roughness calculations using percentage-based cover compositions from T_VALORES.

## Intended use

SIOSE2Manning is intended for hydraulic and hydrological studies including:

- Flood hazard studies
- Flood risk assessment
- HEC-RAS 1D and 2D modelling
- Urban drainage studies
- Catchment-scale hydrological analysis
- Preliminary feasibility studies

## Data scope

Current version supports:

- SIOSE AR 2016, 2017, 2018 y 2020 Spain
- GeoPackage format
- T_COMBINADA layer structure

The plugin automatically detects valid SIOSE AR layers based on the presence of the ID_COBERTURA_MAX field.

## Requirements

- QGIS 3.28 or later
- SIOSE AR dataset in GeoPackage (.gpkg) format

## Output fields

The resulting layer contains:

- MANNING_N
- AREA_M2
- AREA_HA

## Authors

Pedro Bohorquez  
Hugo Bohorquez  

## License

GPL v2 or later
