from qgis.PyQt.QtWidgets import QDialog
from qgis.PyQt.QtGui import QDesktopServices
from qgis.PyQt.QtCore import QUrl
from ..tools.analytics import analytics_log, AnalyticsEvent

class CurrentSituationPanel:
    def __init__(self, dialog: QDialog, plugin) -> None:
        self._plugin = plugin
        self._dialog = dialog

    def setup_panel(self) -> None:
        print("Setup CurrentSituationPanel")
        self._dialog.contact_button_2.clicked.connect(self.more_info_clicked)

    def more_info_clicked(self):
        QDesktopServices.openUrl(QUrl("https://stratopo.nl/nl/contact/"))
        analytics_log(self._plugin, AnalyticsEvent.CLICKED_CURRENT_SITUATION_LINK)

    def make_active_panel(self):
        print("CurrentSituationPanel make active")
        analytics_log(self._plugin, AnalyticsEvent.OPENED_CURRENT_SITUATION_PANEL)
