## Prerequisites
* Make sure QGIS is installed on your machine.
* This was tested on MacOS version 12.2.1 with QGIS version 
QGIS version 3.24.0

## Create Plugin
* Use the `Plugin Builder` to create a new plugin. If you don't see the plugin builder in the plugins drop down menu in QGIS, install the pluging first under: `Plugins > Manage and Install Plugings`.
* When creating a new plugin don't use spaces in the `Class name` and `Module name`
* Make sure to save the plugin in the `<QGIS_USER_DIRECTORY>/python/plugins/` folder. You can locate this folder by going to `Settings > User Profiles > Open Active Profile Folder` in QGIS

### Update resources
* (If you add images or other resources) Edit the `resources.qrc` as well.
* Go to the folder and run: (You need to do this when every time you change the resources.qrc file. For example if you add or remove an image). Make sure `pyqt5` is installed `pip3 install pyqt5`.
    ```
    pyrcc5 resources/resources.qrc -o resources/resources.py
    ```

### Open plugin in QGIS
* Now restart QGIS
* Once restarted, go to `Plugins > Manage and Install Plugings`, search for your plugin and check the ckeckmark in front of the plugin name. A new icon will appear in the menu bar.

## Design using QT Designer
* Locate the `.ui` file in your newly created plugin directory.
* Right click on the file and open with QT Designer. This comes installed with QGIS

## Reload Plugin
* If you make changes to a plugin you have to restart QGIS or you need to reload the plugin, this can be done by using the `Plugin Reloader` plugin.
* Go to `Plugins > Plugin Reloader > Confige` to configure the plugin you would like to reload.
* Now you can reload the plugin by clicking on the reload icon in the toolbar.

## Console log
* To see the python console when testing the plugin. Go to `Plugins > Python Console`

## Upload
* Navigate to parent dirictory `<QGIS_USER_DIRECTORY>python/plugins/`
* Create zip on MacOS by using the following command:
    ```
    zip -r GeoStrategieKit.zip SGS -x ".DS_Store" -x "__MACOSX" -x '*.git*' -x '*__pycache__*'
    ```
* Upload the zip file to [plugins.qgis.org](https://plugins.qgis.org/accounts/login/?next=/plugins/add/).
Credentionals needed for logging in can be found in [Bitwarden](https://vault.bitwarden.com).