from PyQt5.QtCore import Qt
from qgis.core import QgsWkbTypes, QgsPointXY, QgsProject, QgsCoordinateReferenceSystem, QgsCoordinateTransform
from qgis.gui import QgsMapTool, QgsRubberBand

class MapClickTool(QgsMapTool):
    def __init__(self, canvas, callback):
        QgsMapTool.__init__(self, canvas)
        self.canvas = canvas
        self.callback = callback

    def canvasReleaseEvent(self, event):
        pt = self.toMapCoordinates(event.originalPixelPoint())
        sourceCrs = QgsCoordinateReferenceSystem(QgsProject.instance().crs())
        destCrs = QgsCoordinateReferenceSystem(4326)
        tr = QgsCoordinateTransform(sourceCrs, destCrs, QgsProject.instance())
        self.callback(tr.transform(pt))


class MyRectangleTool(QgsMapTool):
    def __init__(self, canvas, callback_rectangle_created):
        super().__init__(canvas)
        self.rubberBand = QgsRubberBand(canvas, True)
        self.rubberBand.setWidth(3)
        self.rubberBand.setColor(Qt.blue)
        self.rubberBand.setFillColor(Qt.transparent)
        self.startPoint = self.endPoint = None
        self.isEmittingPoint = False
        self.callback_rectangle_created = callback_rectangle_created

    def canvasPressEvent(self, e):
        self.startPoint = self.endPoint = self.toMapCoordinates(e.pos())
        self.isEmittingPoint = True
        self.showRect(self.startPoint, self.endPoint)

    def canvasReleaseEvent(self, e):
        self.isEmittingPoint = False
        self.callback_rectangle_created(self)

    def canvasMoveEvent(self, e):
        if self.rubberBand is not None:

            if not self.isEmittingPoint:
                return

            self.endPoint = self.toMapCoordinates(e.pos())
            self.showRect(self.startPoint, self.endPoint)

    def showRect(self, startPoint, endPoint):
        self.rubberBand.reset(QgsWkbTypes.PolygonGeometry)

        if startPoint.x() == endPoint.x() or startPoint.y() == endPoint.y():
            return

        point1 = QgsPointXY(startPoint.x(), startPoint.y())
        point2 = QgsPointXY(startPoint.x(), endPoint.y())
        point3 = QgsPointXY(endPoint.x(), endPoint.y())
        point4 = QgsPointXY(endPoint.x(), startPoint.y())
        self.rubberBand.addPoint(point1, False)
        self.rubberBand.addPoint(point2, False)
        self.rubberBand.addPoint(point3, False)
        self.rubberBand.addPoint(point4, True)  # true to update canvas
        self.rubberBand.show()

    def deactivate(self) -> None:
        super().deactivate()
        self.rubberBand.reset()
        del self.rubberBand
        self.rubberBand = None
