
import enum
from .networking import NetworkRequestTask
from qgis.core import QgsApplication

class AnalyticsEvent(enum.Enum):
    OPENED_PLUGIN = 1
    OPENED_INTRO_PANEL = 2
    CLICKED_INTRO_LINK = 3
    OPENED_ISOCHRONE_PANEL = 4
    MADE_ISOCHRONE_REQUEST = 5
    OPENED_PUPILS_NETWORK_PANEL = 6
    CLICKED_PUPILS_NETWORK_LINK = 7
    OPENED_CURRENT_SITUATION_PANEL = 8
    CLICKED_CURRENT_SITUATION_LINK = 9
    OPENED_SYMULATE_CITY_PANEL = 10
    CLICKED_SYMULATE_CITY_LINK = 11
    OPENED_DATASETS_PANEL = 12
    CLICKED_DATASET_1_LINK = 13
    CLICKED_DATASET_2_LINK = 14
    CLICKED_DATASET_3_LINK = 15
    CLICKED_DATASET_4_LINK = 16
    CLICKED_DATASET_5_LINK = 17
    CLICKED_DATASET_6_LINK = 18
    CLICKED_DATASET_7_LINK = 19
    CLICKED_DATASET_8_LINK = 20

def analytics_log(plugin, analytics_type):

    # Make request
    url = plugin.analytics_url
    requestBody = {
        "user_id": plugin.user_id,
        "event_type": analytics_type.name,
        "secret": "eZWyRoLsss8UUMQHJw5J"
    }
    headers = {'Content-type': 'application/json'}

    globals()['get_isochrone_task'] = NetworkRequestTask(url, headers, requestBody, analytics_callback)
    QgsApplication.taskManager().addTask(globals()['get_isochrone_task'])

def analytics_callback(response):
    print(response)