from qgis.PyQt.QtWidgets import QDialog
from qgis.PyQt.QtGui import QDesktopServices
from qgis.PyQt.QtCore import QUrl
from ..tools.analytics import analytics_log, AnalyticsEvent

class SimulateCityPanel():
    def __init__(self, dialog: QDialog, plugin) -> None:
        self._plugin = plugin
        self._dialog = dialog

    def setup_panel(self) -> None:
        print("Setup SimulateCityPanel")
        self._dialog.contact_button_3.clicked.connect(self.more_info_clicked)

    def more_info_clicked(self):
        QDesktopServices.openUrl(QUrl("https://stratopo.nl/nl/contact/"))
        analytics_log(self._plugin, AnalyticsEvent.CLICKED_SYMULATE_CITY_LINK)

    def make_active_panel(self):
        print("SimulateCityPanel active")
        analytics_log(self._plugin, AnalyticsEvent.OPENED_SYMULATE_CITY_PANEL)
