# -*- coding: utf-8 -*-
"""
/***************************************************************************
Dialog
                                 A QGIS plugin
 Generete isochrones
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2022-03-01
        git sha              : $Format:%H$
        copyright            : (C) 2022 by StraTopo
        email                : c.vaessens@stratopo.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import QtWidgets
from qgis.PyQt import uic
from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtGui import QPixmap, QIcon
from qgis.PyQt.QtWidgets import QListWidgetItem

from .introduction_panel import IntroductionPanel
from .pupil_network_panel import PupilNetworkPanel
from .simulate_city_panel import SimulateCityPanel
from .isochrone_panel import IsochronePanel
from .panels import Panels
from .datasets_panel import DatasetsPanel
from .current_situation_panel import CurrentSituationPanel

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'main.ui'))


class MainDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, plugin, parent=None):
        """Constructor."""
        super(MainDialog, self).__init__(parent)
        self._plugin = plugin
        self.setupUi(self)

        self.stratopoLogo.setPixmap(QPixmap(':/resources/images/Logo.png'))


        self.PupilNetworkExampleImage.setPixmap(QPixmap(':/resources/images/PupilNetworkExampleImage.png'))
        self.CurrentSituationExampleImage.setPixmap(QPixmap(':/resources/images/CurrentSituationExampleImage.png'))
        self.SimulateCityExampleImage.setPixmap(QPixmap(':/resources/images/SimulateCityExampleImage.png'))

        self.panels = {
            Panels.Introduction: {
                "name": "Introductie",
                "icon": QIcon(':/resources/images/InfoIcon.png'),
                "panel": IntroductionPanel(self, self._plugin),
                "index": 0,
                "enabled": True
            },
            Panels.Isochrone: {
                "name": "Reistijd-contouren",
                "icon": QIcon(':/resources/images/IsochroneIcon.png'),
                "panel": IsochronePanel(self, self._plugin),
                "index": 1,
                "enabled": True
            },
            Panels.PupilNetwork: {
                "name": "Waar fietsen scholieren?",
                "icon": QIcon(':/resources/images/BikeIcon.png'),
                "panel": PupilNetworkPanel(self, self._plugin),
                "index": 2,
                "enabled": True
            },
            Panels.CurrentSituation: {
                "name": "Bereikbare voorzieningen",
                "icon": QIcon(':/resources/images/ShoppingIcon.png'),
                "panel": CurrentSituationPanel(self, self._plugin),
                "index": 3,
                "enabled": True
            },
            Panels.SimulateCity: {
                "name": "Simuleer toekomstige stad",
                "icon": QIcon(':/resources/images/HouseIcon.png'),
                "panel": SimulateCityPanel(self, self._plugin),
                "index": 4,
                "enabled": True
            },
            Panels.Datasets: {
                "name": "Datasets",
                "icon": QIcon(':/resources/images/DatabaseIcon.png'),
                "panel": DatasetsPanel(self, self._plugin),
                "index": 5,
                "enabled": True
            },
        }

        # setup menu items and call setup_panel()
        for panel in self.panels:
            item = QListWidgetItem(self.panels[panel]["name"])
            item.setIcon(self.panels[panel]["icon"])
            if not self.panels[panel]["enabled"]:
                item.setFlags(Qt.NoItemFlags)
            self.menu_list_widget.addItem(item)

            self.panels[panel]["panel"].setup_panel()

        # add event listener
        self.menu_list_widget.itemClicked.connect(self.list_widget_clicked)

        self.switch_panel(Panels.Introduction)

        self.setWindowFlags(Qt.WindowStaysOnTopHint)

    def list_widget_clicked(self, item):
        # Get list item and find panel with same index
        item_index = self.menu_list_widget.row(item)
        destination = Panels.Isochrone
        for panel in self.panels:
            if self.panels[panel]["index"] == item_index:
                destination = panel
                break
        self.switch_panel(destination)

    def switch_panel(self, panel_name):
       if self.panels[panel_name]["enabled"]:
            self.panels[panel_name]["panel"].make_active_panel()
            self.menu_list_widget.setCurrentRow(self.panels[panel_name]["index"])
            self.stacked_widget.setCurrentIndex(self.panels[panel_name]["index"])
