from qgis.PyQt.QtWidgets import QDialog
from qgis.PyQt.QtGui import QDesktopServices
from qgis.PyQt.QtCore import QUrl
from ..tools.analytics import analytics_log, AnalyticsEvent

class IntroductionPanel():
    def __init__(self, dialog: QDialog, plugin) -> None:
        self._plugin = plugin
        self._dialog = dialog

    def setup_panel(self) -> None:
        print("Setup IntroductionPanel")

        self._dialog.intro_more_info_button.clicked.connect(self.more_info_clicked)

    def more_info_clicked(self):
        print("IntroductionPanel button clicked")
        QDesktopServices.openUrl(QUrl("https://www.stratopo.nl"))
        analytics_log(self._plugin, AnalyticsEvent.CLICKED_INTRO_LINK)

    def make_active_panel(self):
        print('IntroductionPanel make active')
        analytics_log(self._plugin, AnalyticsEvent.OPENED_INTRO_PANEL)