from qgis.PyQt.QtWidgets import QDialog
from qgis.PyQt.QtGui import QDesktopServices
from qgis.PyQt.QtCore import QUrl
from ..tools.analytics import analytics_log, AnalyticsEvent

class DatasetsPanel():
    def __init__(self, dialog: QDialog, plugin) -> None:
        self._plugin = plugin
        self._dialog = dialog

    def setup_panel(self) -> None:
        print("Setup DatasetsPanel")

        self._dialog.datasets_button_1.clicked.connect(self.more_info_clicked_1)
        self._dialog.datasets_button_2.clicked.connect(self.more_info_clicked_2)
        self._dialog.datasets_button_3.clicked.connect(self.more_info_clicked_3)
        self._dialog.datasets_button_4.clicked.connect(self.more_info_clicked_4)
        self._dialog.datasets_button_5.clicked.connect(self.more_info_clicked_5)
        self._dialog.datasets_button_6.clicked.connect(self.more_info_clicked_6)
        self._dialog.datasets_button_7.clicked.connect(self.more_info_clicked_7)
        self._dialog.datasets_button_8.clicked.connect(self.more_info_clicked_8)


    def more_info_clicked_1(self):
        QDesktopServices.openUrl(QUrl("https://shop.stratopo.nl/products/natura-2000-gebieden"))
        analytics_log(self._plugin, AnalyticsEvent.CLICKED_DATASET_1_LINK)

    def more_info_clicked_2(self):
        QDesktopServices.openUrl(QUrl("https://shop.stratopo.nl/products/rijksmonumenten"))
        analytics_log(self._plugin, AnalyticsEvent.CLICKED_DATASET_2_LINK)
    
    def more_info_clicked_3(self):
        QDesktopServices.openUrl(QUrl("https://shop.stratopo.nl/products/verkeersongevallen-2021"))
        analytics_log(self._plugin, AnalyticsEvent.CLICKED_DATASET_3_LINK)

    def more_info_clicked_4(self):
        QDesktopServices.openUrl(QUrl("https://shop.stratopo.nl/products/voedselbanken"))
        analytics_log(self._plugin, AnalyticsEvent.CLICKED_DATASET_4_LINK)

    def more_info_clicked_5(self):
        QDesktopServices.openUrl(QUrl("https://shop.stratopo.nl/products/reistijdisochronen"))
        analytics_log(self._plugin, AnalyticsEvent.CLICKED_DATASET_5_LINK)

    def more_info_clicked_6(self):
        QDesktopServices.openUrl(QUrl("https://shop.stratopo.nl/products/openbaar-vervoer-haltes"))
        analytics_log(self._plugin, AnalyticsEvent.CLICKED_DATASET_6_LINK)

    def more_info_clicked_7(self):
        QDesktopServices.openUrl(QUrl("https://shop.stratopo.nl/products/onderwijs-data"))
        analytics_log(self._plugin, AnalyticsEvent.CLICKED_DATASET_7_LINK)

    def more_info_clicked_8(self):
        QDesktopServices.openUrl(QUrl("https://shop.stratopo.nl/products/fietsnetwerken-nederland"))
        analytics_log(self._plugin, AnalyticsEvent.CLICKED_DATASET_8_LINK)

    def make_active_panel(self):
        print('Datasets DatasetsPanel')
        analytics_log(self._plugin, AnalyticsEvent.OPENED_DATASETS_PANEL)