from email.policy import default
import imp
from qgis.PyQt.QtWidgets import QDialog
from qgis.PyQt.QtCore import QVariant, Qt
from qgis.core import QgsApplication, QgsVectorLayer, QgsFeature, QgsPointXY, QgsGeometry, QgsProject, QgsField
from qgis.utils import iface
from .panels import Panels
import re
from ..tools.networking import NetworkRequestTask
from ..tools.tools import MapClickTool
from http import HTTPStatus
from ..tools.analytics import analytics_log, AnalyticsEvent


class IsochronePanel():
    def __init__(self, dialog: QDialog, plugin) -> None:
        self._plugin = plugin
        self._dialog = dialog

        # self.previous_map_tool = None
        self.isochrone_button_enabled = True
        
        self.request_lat = 0
        self.request_lon = 0

    def setup_panel(self) -> None:
        print("Setup Isochrone panel")

        self.display_error()
        # self._dialog.isochrone_layer_combo_box.setFilters(QgsMapLayerProxyModel.PointLayer)

        # Get list with point layers
        # point_layer_list = []
        # for layer in QgsProject.instance().mapLayers().values():
        #     if type(layer) is QgsVectorLayer:
        #         if layer.geometryType() == QgsWkbTypes.PointGeometry:
        #             point_layer_list.append(layer.name())
        # print(point_layer_list)

        self._dialog.isochrone_create_push_button.clicked.connect(self.clicked_btn)
        self._dialog.isochrone_get_coordinate_push_button.clicked.connect(self.get_coordinate_from_selected_point)

       


    def get_map_point(self, point):
        print(point)
        self._dialog.isochrone_lat_line_edit.setText(f"{point.y():.6f}")
        self._dialog.isochrone_lon_line_edit.setText(f"{point.x():.6f}")

        # canvas = iface.mapCanvas()
        # canvas.setMapTool(self.previous_map_tool)



    def make_active_panel(self):
        print('isochrone make active')
        self.display_error()
        analytics_log(self._plugin, AnalyticsEvent.OPENED_ISOCHRONE_PANEL)

    def display_error(self):
        if self._plugin.error_message is None:
            self._dialog.isochrone_error_label.setVisible(False)
        else:
            self._dialog.isochrone_error_label.setText(self._plugin.error_message)
            self._dialog.isochrone_error_label.setVisible(True)


    def get_coordinate_from_selected_point(self):
        canvas = iface.mapCanvas()        
        
        # self.previous_map_tool = iface.mapCanvas().mapTool() # QgsMapToolPan
        # print(self.previous_map_tool)
        map_tool = MapClickTool(canvas, self.get_map_point)
        canvas.setMapTool(map_tool)

    

    def clicked_btn(self):

        if self.isochrone_button_enabled:
            print("clicked")


            latLineEditText = self._dialog.isochrone_lat_line_edit.text()
            lonLineEditText = self._dialog.isochrone_lon_line_edit.text()
            
            isochrone_travel_times_check_box_five_checked = self._dialog.isochrone_travel_times_check_box_five.isChecked()
            isochrone_travel_times_check_box_ten_checked = self._dialog.isochrone_travel_times_check_box_ten.isChecked()
            isochrone_travel_times_check_box_fifteen_checked = self._dialog.isochrone_travel_times_check_box_fifteen.isChecked()
            isochrone_travel_times_check_box_twenty_checked = self._dialog.isochrone_travel_times_check_box_twenty.isChecked()
            isochrone_travel_times_check_box_twentyfive_checked = self._dialog.isochrone_travel_times_check_box_twentyfive.isChecked()
            isochrone_travel_times_check_box_thirty_checked = self._dialog.isochrone_travel_times_check_box_thirty.isChecked()

            isochrone_modality_radio_button_walking_checked = self._dialog.isochrone_modality_radio_button_walking.isChecked()
            isochrone_modality_radio_button_biking_checked = self._dialog.isochrone_modality_radio_button_biking.isChecked()
            isochrone_modality_radio_button_driving_checked = self._dialog.isochrone_modality_radio_button_driving.isChecked()

            # TODO: isochroon voor ieder punt
            # lat = None
            # lon = None
            # selectedLayer = QgsProject.instance().mapLayersByName('test')
            # selectedLayer = self._dialog.isochrone_layer_combo_box.currentLayer()

            # if not len(selectedLayer) == 1:
            #     print("Wrong lat input")
            #     self._plugin.error_message = 'Error in latitude'
            #     self.showIsochonesWindow()
            #     return

            # if type(selectedLayer) is QgsVectorLayer:
            #     if selectedLayer.geometryType() == QgsWkbTypes.PointGeometry:
            #         for feature in selectedLayer.getFeatures():
            #             # TODO: check if feature is multipoint
            #             try:
            #                 geometry = QgsGeometry.asPoint(feature.geometry())#get the geometry of the feature
            #                 point = QgsPointXY(geometry)
            #                 lon = point.x() # lan
            #                 lat = point.y() # lat
            #                 print(lat, lon)
            #                 break
            #             except:
            #                 pass

            
            # Get Lat Long
            if not bool(re.match("^-?[0-9]{1,3}(?:[\.,][0-9]+)?$", latLineEditText)):
                print("Wrong lat input")
                self._plugin.error_message = 'Error in latitude'
                # self.showIsochonesWindow()
                self.display_error()
                return
            if not bool(re.match("^-?[0-9]{1,3}(?:[\.,][0-9]+)?$", lonLineEditText)):
                print("Wrong lon input")
                self._plugin.error_message = 'Error in longitude'
                # self.showIsochonesWindow()
                self.display_error()
                return

            self.request_lat = float(latLineEditText.replace(',', '.')) 
            self.request_lon = float(lonLineEditText.replace(',', '.'))


            # Travel Times
            travelTimesList = []

            if isochrone_travel_times_check_box_five_checked:
                travelTimesList.append(5)
            if isochrone_travel_times_check_box_ten_checked:
                travelTimesList.append(10)
            if isochrone_travel_times_check_box_fifteen_checked:
                travelTimesList.append(15)
            if isochrone_travel_times_check_box_twenty_checked:
                travelTimesList.append(20)
            if isochrone_travel_times_check_box_twentyfive_checked:
                travelTimesList.append(25)
            if isochrone_travel_times_check_box_thirty_checked:
                travelTimesList.append(30)

            if len(travelTimesList) == 0:
                print("At least one travel time should be checked")
                self._plugin.error_message = 'Error: travel time not selected'
                # self.showIsochonesWindow()
                self.display_error()
                return

            # Modality
            modality = ""
            if isochrone_modality_radio_button_walking_checked:
                modality = "walk"
            if isochrone_modality_radio_button_biking_checked:
                modality = "bike"
            if isochrone_modality_radio_button_driving_checked:
                modality = "car"

            if modality == "":
                print("One form of modality should be checked")
                self._plugin.error_message = 'Error: modality not selected'
                # self.showIsochonesWindow()
                self.display_error()
                return


            self._dialog.isochrone_create_push_button.setText("Loading... Please wait")
            self.isochrone_button_enabled = False

            # Make request
            url = self._plugin.api_url+"/routing/v1/isochrones"
            requestBody = {
                "latitude": self.request_lat,
                "longitude": self.request_lon,
                "minutes": travelTimesList,
                "modality": modality
            }
            headers = {'Content-type': 'application/json', 'Authorization': "17a65f043406c4b2c8b89cd2ed8473b28"}

            globals()['get_isochrone_task'] = NetworkRequestTask(url, headers, requestBody, self.get_isochrone_callback)
            QgsApplication.taskManager().addTask(globals()['get_isochrone_task'])

            analytics_log(self._plugin, AnalyticsEvent.MADE_ISOCHRONE_REQUEST)


    def get_isochrone_callback(self, response):

        if response.status_code == HTTPStatus.OK:
            self._dialog.isochrone_create_push_button.setText("Create")
            self.isochrone_button_enabled = True
            print(response.json())
            self.drawIsochrone(response.json(), True)
            self._plugin.error_message = None
            self.display_error()
        elif response.status_code in (HTTPStatus.FORBIDDEN, HTTPStatus.UNAUTHORIZED):
            self._dialog.isochrone_create_push_button.setText("Create")
            self.isochrone_button_enabled = True
            print("Error form server: ", response.status_code)
            self._plugin.error_message = 'Provide a valid API key and try again'
            self.display_error()
            # self.showConfigurationWindow()
            # self._dialog.switch_panel(Panels.Settings)
        elif response.status_code == HTTPStatus.INTERNAL_SERVER_ERROR:
            # check if point is within the Netherlands

            url = "https://nominatim.openstreetmap.org/reverse.php?lat={}&lon={}&format=jsonv2".format(self.request_lat, self.request_lon)
            globals()['is_within_nl_task'] = NetworkRequestTask(url, None, None, self.is_within_nl_callback, False)
            QgsApplication.taskManager().addTask(globals()['is_within_nl_task'])

        else:
            self._dialog.isochrone_create_push_button.setText("Create")
            self.isochrone_button_enabled = True
            print("Error form server: ", response.status_code)
            self._plugin.error_message = 'Server error'
            # self.showIsochonesWindow()
            self.display_error()

    def is_within_nl_callback(self, response):
        
        if response.status_code == HTTPStatus.OK:
            json = response.json()
            if "address" in json:
                if "country_code" in json["address"]:
                    if json["address"]["country_code"] == 'nl':
                        self._plugin.error_message = 'Server error'
                        self.display_error()
                    else:
                        self._plugin.error_message = 'Select a coordinate within the Netherlands'
                        self.display_error()
                else:
                    self._plugin.error_message = 'Server error'
                    self.display_error()
            elif "error" in json:
                self._plugin.error_message = 'Select a coordinate within the Netherlands'
                self.display_error()
            else:
                self._plugin.error_message = 'Server error'
                self.display_error()
        else:
            print("Error form server: ", response.status_code)
            self._plugin.error_message = 'Server error'
            self.display_error()
        self._dialog.isochrone_create_push_button.setText("Create")
        self.isochrone_button_enabled = True

    def drawIsochrone(self, geoJson, drawPoint):
        """Draw GeoJson on new layer"""

        if "features" in geoJson and "properties" in geoJson:
            
            newFeatures = []
            for jsonFeature in geoJson["features"]:
                if "geometry" in jsonFeature and "properties" in jsonFeature:
                    if "coordinates" in jsonFeature["geometry"] and "type" in jsonFeature["geometry"]:

                        newAttributes = ["", "", 0]
                        if "modality" in jsonFeature["properties"]:
                            newAttributes[0] = jsonFeature["properties"]["modality"]
                        if "speed_type" in jsonFeature["properties"]:
                            newAttributes[1] = jsonFeature["properties"]["speed_type"]
                        if "travel_time_minute" in jsonFeature["properties"]:
                            newAttributes[2] = jsonFeature["properties"]["travel_time_minute"]


                        if jsonFeature["geometry"]["type"] == "Polygon":
                            
                            newCoordinatesListOne = []
                            for coordinateListOne in jsonFeature["geometry"]["coordinates"]:
                                newCoordinatesListTwo = []
                                for coordinate in coordinateListOne:
                                    if len(coordinate) == 2:
                                        newCoordinatesListTwo.append(QgsPointXY(coordinate[0], coordinate[1]))
                                newCoordinatesListOne.append(newCoordinatesListTwo)

                            feature = QgsFeature()
                            feature.setGeometry(QgsGeometry.fromPolygonXY(newCoordinatesListOne))

                        elif jsonFeature["geometry"]["type"] == "MultiPolygon":
                        
                            newCoordinatesListOne = []
                            for coordinateListOne in jsonFeature["geometry"]["coordinates"]:
                                newCoordinatesListTwo = []
                                for coordinateListTwo in coordinateListOne:
                                    newCoordinatesListThree = []
                                    for coordinate in coordinateListTwo:
                                        print(coordinate)
                                        if len(coordinate) == 2:
                                            newCoordinatesListThree.append(QgsPointXY(coordinate[0], coordinate[1]))
                                    newCoordinatesListTwo.append(newCoordinatesListThree)
                                newCoordinatesListOne.append(newCoordinatesListTwo)

                            feature = QgsFeature()
                            feature.setGeometry(QgsGeometry.fromMultiPolygonXY(newCoordinatesListOne))
                        
                        feature.setAttributes(newAttributes)
                        newFeatures.append(feature)
                        

            if len(newFeatures) > 0 and "latitude" in geoJson["properties"] and "longitude" in geoJson["properties"]:

                layers = []

                if drawPoint:
                    # point
                    pointLayer =  QgsVectorLayer('Point', 'Isochrones_StartingPoint' , "memory")
                    pointDataProvider = pointLayer.dataProvider() 

                    pt = QgsFeature()
                    point1 = QgsPointXY(geoJson["properties"]["longitude"], geoJson["properties"]["latitude"])
                    pt.setGeometry(QgsGeometry.fromPointXY(point1))
                    pointDataProvider.addFeatures([pt])

                    pointLayer.updateExtents()

                    layers.append(pointLayer)

                # polygon
                polygonLayer = QgsVectorLayer('Polygon?crs=epsg:4326', 'Isochrones' , 'memory')
                polygonDataProvider = polygonLayer.dataProvider()

                polygonDataProvider.addAttributes([QgsField("modality", QVariant.String), QgsField("speed_type", QVariant.String), QgsField("travel_time_minute", QVariant.Int)])
                polygonLayer.updateFields()

                newFeatures.reverse()
                polygonDataProvider.addFeatures(newFeatures)
                polygonLayer.updateExtents()

                layers.append(polygonLayer)

                # add layers
                QgsProject.instance().addMapLayers(layers)

