import traceback

import requests
from qgis.core import QgsTask
from .resources import plugin_version, qgis_version_sanitized

try:
    from qgis.core import Qgis
except ImportError:
    from qgis.core import QGis as Qgis
class NetworkRequestTask(QgsTask):

    def __init__(self, request_url, request_headers, request_body, callback, edit_user_agent=True):
        super().__init__('My awesome task', QgsTask.CanCancel)
        self.request_url = request_url
        self.request_headers = request_headers
        self.request_body = request_body
        self.callback = callback
        self.edit_user_agent = edit_user_agent
        self.response = None
        self.exception = None
        print("network start")

    def run(self):
        #  Here you implement your heavy lifting.
        #  Should periodically test for isCanceled() to gracefully
        #  abort.
        #  This method MUST return True or False.
        #  Raising exceptions will crash QGIS, so we handle them
        #  internally and raise them in self.finished

        print("network run")
 

        try:
            if self.edit_user_agent:
                self.request_headers['User-Agent'] = "QGIS {}; GeoStrategieKit Plugin v{}".format(qgis_version_sanitized(), plugin_version())

            # Make request
            self.response = requests.post(self.request_url, json=self.request_body, headers=self.request_headers)

        except (UnicodeEncodeError, ValueError, KeyError, TypeError, AttributeError) as e:
            self.exception = e
            return False

        return True
    
    def finished(self, result):
        #  This function is automatically called when the task has
        #  completed (successfully or not).
        #  You implement finished() to do whatever follow-up stuff
        #  should happen after the task is complete.
        #  finished is always called from the main thread, so it's safe
        #  to do GUI operations and raise Python exceptions here.
        #  result is the return value from self.run.
        print("network finished")

        if self.exception:
            raise self.exception

        self.callback(self.response)

 
    def cancel(self):
        super().cancel()