# -*- coding: utf-8 -*-
"""
/***************************************************************************
 SELCAAnalysis
                                 A QGIS plugin
 This plugin analyzes the correlation between land cover changes and dependent variables such as population and GDRP, and provides probabilistic estimating of future land cover patterns.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-02-27
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Author
        email                : email@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.core import QgsApplication

# Import the dialog and processing provider
from .selca_analysis_dialog import SelcaAnalysisDialog
from .Processing.Processing_Provider import SelcaProvider
import os.path

class SelcaAnalysis:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor."""
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(self.plugin_dir, 'i18n', f'SelcaAnalysis_{locale}.qm')

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        self.actions = []
        self.menu = self.tr(u'&SELCA')  # Use consistent menu name
        self.first_start = None

    def initProcessing(self):
        """Register the processing provider."""
        self.provider = SelcaProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def tr(self, message):
        """Translate a string using Qt translation API."""
        return QCoreApplication.translate('SelcaAnalysis', message)

    def add_action(self, icon_path, text, callback, enabled_flag=True, add_to_menu=True,
                   add_to_toolbar=True, status_tip=None, whats_this=None, parent=None):
        """Add a toolbar icon to the toolbar."""
        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(self.menu, action)

        self.actions.append(action)
        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        self.initProcessing()
        # Use direct path to icon without Qt resource
        icon_path = os.path.join(self.plugin_dir, 'Icons', 'logo1.png')
        self.add_action(
            icon_path,
            text=self.tr(u'SELCA Dialog'),
            callback=self.run,
            parent=self.iface.mainWindow()
        )
        self.first_start = True

    def unload(self):
        """Remove the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(self.tr(u'&SELCA'), action)
            self.iface.removeToolBarIcon(action)
        QgsApplication.processingRegistry().removeProvider(self.provider)

    def run(self):
        """Run method that performs all the real work."""
        if self.first_start:
            self.first_start = False
            self.dlg = SelcaAnalysisDialog()
        self.dlg.show()
        result = self.dlg.exec_()
        if result:
            # Do something with the dialog result if needed
            pass
