# SEBCS abbreviation

| Feature                                                                                 |                                        Unit                                         | Description                                                                                                                                     |
|:----------------------------------------------------------------------------------------|:-----------------------------------------------------------------------------------:|:------------------------------------------------------------------------------------------------------------------------------------------------|
| <img src="https://render.githubusercontent.com/render/math?math=a_w">                   |                                          °                                          | Aspect                                                                                                                                          |
| B                                                                                       |                                        rel.                                         | Spectral bands, spectral reflectance                                                                                                            |                                                                                              
| C                                                                                       |                                       const.                                        | Constant                                                                                                                                        |
| <img src="https://render.githubusercontent.com/render/math?math=c_p">                   | <img src="https://render.githubusercontent.com/render/math?math=J.kg^{-1}.K^{-1}">  | Thermal heat capacity of dry air (<img src="https://render.githubusercontent.com/render/math?math=c_p = 1012\ J.kg^{-1}.K^{-1}">)               |
| d                                                                                       |                                          m                                          | Effective height of the canopy                                                                                                                  |
| DMT                                                                                     |                                          m                                          | Digital model of terrain                                                                                                                        |
| <img src="https://render.githubusercontent.com/render/math?math=d{\epsilon}">           |                                      unitless                                       | Effect of natural surfaces geometry distribution and their internal reflection                                                                  |
| <img src="https://render.githubusercontent.com/render/math?math=E_a">                   |                                         kPa                                         | Water vapour pressure of saturated air                                                                                                          |
| <img src="https://render.githubusercontent.com/render/math?math=e_a">                   |                                         kPa                                         | Water vapour pressure                                                                                                                           |                                                                                                     
| <img src="https://render.githubusercontent.com/render/math?math=E_s">                   |                                         kPa                                         | Water vapour pressure of saturated air at the surface                                                                                           |             
| <img src="https://render.githubusercontent.com/render/math?math=e_s">                   |                                         kPa                                         | Water vapour pressure at the surface                                                                                                            |                      
| <img src="https://render.githubusercontent.com/render/math?math=F_L">                   |                                      unitless                                       | Factor of Monin-Obukhov length                                                                                                                  |                      
| g                                                                                       |     <img src="https://render.githubusercontent.com/render/math?math=m.s^{-2}">      | Gravitational forcing                                                                                                                           |                                                                                                             
| G                                                                                       |     <img src="https://render.githubusercontent.com/render/math?math=W.m^{-2}">      | Ground heat flux                                                                                                                                |                                                                                                                  
| h                                                                                       |                                          m                                          | Canopy height                                                                                                                                   |
| H                                                                                       |     <img src="https://render.githubusercontent.com/render/math?math=W.m^{-2}">      | Sensible heat flux                                                                                                                              |
| <img src="https://render.githubusercontent.com/render/math?math=H_s">                   |                                          °                                          | Hour angle                                                                                                                                      |
| <img src="https://render.githubusercontent.com/render/math?math=h_{st}">                |                                          m                                          | Mean height of canopy around the meteo-station                                                                                                  |                                         
| <img src="https://render.githubusercontent.com/render/math?math=I_s">                   |     <img src="https://render.githubusercontent.com/render/math?math=W.m^{-2}">      | Incident shortwave solar radiation perpendicular to beam                                                                                        |
| L                                                                                       |                                          m                                          | Monin-Obukhov length                                                                                                                            |
| <img src="https://render.githubusercontent.com/render/math?math=L_{dry}">               |                                          m                                          | Monin-Obukhov length for dry air                                                                                                                |                         
| Lat                                                                                     |                                          °                                          | Latitude                                                                                                                                        |                                                                        
| Long                                                                                    |                                          °                                          | Longitude                                                                                                                                       |                                                                      
| N                                                                                       |                                      unitless                                       | No. of day in year                                                                                                                              |                                                         
| MSAVI                                                                                   |                                      unitless                                       | Modified Soil Adjusted Vegetation Index                                                                                                         |                                
| NDMI                                                                                    |                                      unitless                                       | Normalized Difference Moisture Index                                                                                                            |                                    
| NDVI                                                                                    |                                      unitless                                       | Normalized Difference Vegetation Index                                                                                                          |                                  
| P                                                                                       |                                         kPa                                         | Atmospheric pressure                                                                                                                            |                                                            
| Pv                                                                                      |                                      unitless                                       | Fractional vegetation index                                                                                                                     |                                               
| <img src="https://render.githubusercontent.com/render/math?math=r_a">                   |     <img src="https://render.githubusercontent.com/render/math?math=s.m^{-1}">      | Surface aerodynamic resistance for heat and momentum transfer                                                                                   |                   
| <img src="https://render.githubusercontent.com/render/math?math=r_c">                   |     <img src="https://render.githubusercontent.com/render/math?math=s.m^{-1}">      | Surface resistance for water vapour transfer                                                                                                    |                  
| <img src="https://render.githubusercontent.com/render/math?math=r_{cp}">                |     <img src="https://render.githubusercontent.com/render/math?math=s.m^{-1}">      | Surface aerodynamic resistance for water vapour transfer in case of potential evapotranspiration                                                | 
| Rh                                                                                      |                                          %                                          | Relative humidity of air                                                                                                                        |                                                         
| <img src="https://render.githubusercontent.com/render/math?math=Rl_{\uparrow}">         |     <img src="https://render.githubusercontent.com/render/math?math=W.m^{-2}">      | Upward longwave radiation flux                                                                                                                  |                                  
| <img src="https://render.githubusercontent.com/render/math?math=Rl_{\downarrow}">       |     <img src="https://render.githubusercontent.com/render/math?math=W.m^{-2}">      | Downward longwave radiation flux                                                                                                                |                                 
| Rn                                                                                      |     <img src="https://render.githubusercontent.com/render/math?math=W.m^{-2}">      | Total net radiation                                                                                                                             |
| <img src="https://render.githubusercontent.com/render/math?math=R_{blue}">              |                                        rel.                                         | Spectral reflectance in blue spectral area (BLUE band)                                                                                          |
| <img src="https://render.githubusercontent.com/render/math?math=R_{green}">             |                                        rel.                                         | Spectral reflectance in green spectral area (GREEN band)                                                                                        |
| <img src="https://render.githubusercontent.com/render/math?math=R_{red}">               |                                        rel.                                         | Spectral reflectance in red spectral area (RED band)                                                                                            |
| <img src="https://render.githubusercontent.com/render/math?math=R_{nir}">               |                                        rel.                                         | Spectral reflectance in NIR spectral area (NIR band)                                                                                            |
| <img src="https://render.githubusercontent.com/render/math?math=R_{swir1}">             |                                        rel.                                         | Spectral reflectance in SWIR spectral area at approx. 1.6 <img src="https://render.githubusercontent.com/render/math?math={\mu}m"> (SWIR1 band) |
| <img src="https://render.githubusercontent.com/render/math?math=R_{swir2}">             |                                        rel.                                         | Spectral reflectance in NIR spectral area at approx. 2.2 <img src="https://render.githubusercontent.com/render/math?math={\mu}m"> (SWIR2 band)  |
| <img src="https://render.githubusercontent.com/render/math?math=Rs_{\uparrow}">         |     <img src="https://render.githubusercontent.com/render/math?math=W.m^{-2}">      | Reflected shortwave radiation flux                                                                                                              | 
| <img src="https://render.githubusercontent.com/render/math?math=Rs_{\downarrow}">       |     <img src="https://render.githubusercontent.com/render/math?math=W.m^{-2}">      | Incomming shortwave radiation flux                                                                                                              |
| <img src="https://render.githubusercontent.com/render/math?math=Rs_{\downarrow const}"> |     <img src="https://render.githubusercontent.com/render/math?math=W.m^{-2}">      | Incomming shortwave radiation flux at the horizontal surface                                                                                    |
| <img src="https://render.githubusercontent.com/render/math?math=S_t">                   |                                                                                     | Solar time                                                                                                                                      |
| <img src="https://render.githubusercontent.com/render/math?math=T^*">                   |                                          K                                          | Scaling parameter of temperature in the boundary layer                                                                                          |
| <img src="https://render.githubusercontent.com/render/math?math=T_a">                   |                                         °C                                          | Air temperature in height z                                                                                                                     |
| <img src="https://render.githubusercontent.com/render/math?math=T_{a\_K}">              |                                          K                                          | Air temperature in height z                                                                                                                     |
| <img src="https://render.githubusercontent.com/render/math?math=T_B">                   |                                          K                                          | Surface brightness temperature (<img src="https://render.githubusercontent.com/render/math?math={\varepsilon}"> = 1.0)                          |
| <img src="https://render.githubusercontent.com/render/math?math=T_{max}">               |                                         °C                                          | Max. surface temperature in the image                                                                                                           |
| <img src="https://render.githubusercontent.com/render/math?math=T_s">                   |                                         °C                                          | Surface temperature                                                                                                                             |
| <img src="https://render.githubusercontent.com/render/math?math=T_{s\_K}">              |                                          K                                          | Surface temperature                                                                                                                             |
| <img src="https://render.githubusercontent.com/render/math?math=T_{st}">                |                                         °C                                          | Air temperature measured at meteostation in height <img src="https://render.githubusercontent.com/render/math?math=z_{st}">                     |
| <img src="https://render.githubusercontent.com/render/math?math=T_{s\_dry}">            |                                          K                                          | Calculated maximal surface temperature                                                                                                          |
| <img src="https://render.githubusercontent.com/render/math?math=T_{s\_wet}">            |                                          K                                          | Calculated minimal surface temperature                                                                                                          |
| U                                                                                       |     <img src="https://render.githubusercontent.com/render/math?math=m.s^{-1}">      | Wind speed in height z                                                                                                                          |
| <img src="https://render.githubusercontent.com/render/math?math=u^*">                   |     <img src="https://render.githubusercontent.com/render/math?math=m.s^{-1}">      | Friction velocity of the wind                                                                                                                   |                                                                                                                   
| <img src="https://render.githubusercontent.com/render/math?math=U_{st}">                |     <img src="https://render.githubusercontent.com/render/math?math=m.s^{-1}">      | Wind speed measured at meteostation in height <img src="https://render.githubusercontent.com/render/math?math=z_{st}">                          |                                                                                            
| VPD                                                                                     |                                         kPa                                         | Water vapour pressure deficit                                                                                                                   |                                                                                                                   
| W                                                                                       |                                         mm                                          | Amount of water for rain in atmosphere                                                                                                          |
| <img src="https://render.githubusercontent.com/render/math?math=w_b">                   |                                       const.                                        | Constants for spectral bands                                                                                                                    |                                                                                                                    
| x                                                                                       |                                      unitless                                       | Constant                                                                                                                                        |                                                                                                                                        
| z                                                                                       |                                          m                                          | Height of the mixing layer (z=200)                                                                                                              |                                                                                                              
| <img src="https://render.githubusercontent.com/render/math?math=z_{0h}">                |                                          m                                          | Aerodynamic roughness for heat and water vapour transfer                                                                                        |                                                                                        
| <img src="https://render.githubusercontent.com/render/math?math=z_{0m}">                |                                          m                                          | Aerodynamic roughness for momentum transfer                                                                                                     |                                                                                                     
| <img src="https://render.githubusercontent.com/render/math?math=z_{st}">                |                                          m                                          | Height of measurement at the meteostation                                                                                                       |                                                                                                     
| <img src="https://render.githubusercontent.com/render/math?math=\alpha">                |                                        rel.                                         | Albedo                                                                                                                                          |                                                                                                                                          
| <img src="https://render.githubusercontent.com/render/math?math=\alpha_{PT}">           |                                      unitless                                       | Priestley-Taylor alpha (<img src="https://render.githubusercontent.com/render/math?math=\alpha_{PT}=1.26">)                                     |
| <img src="https://render.githubusercontent.com/render/math?math=\alpha_z">              |                                          °                                          | Solar height angle                                                                                                                              |                                                                                                                              
| <img src="https://render.githubusercontent.com/render/math?math=\beta">                 |                                      unitless                                       | Bowen ratio                                                                                                                                     |                                                                                                                                     
| <img src="https://render.githubusercontent.com/render/math?math=\beta_s">               |                                          °                                          | Slope gradient                                                                                                                                  |                                                                                                                                  
| <img src="https://render.githubusercontent.com/render/math?math=\Gamma">                |  <img src="https://render.githubusercontent.com/render/math?math=^\circ C.m^{-1}">  | Adiabatic lapse rate (<img src="https://render.githubusercontent.com/render/math?math={\Gamma=0.0065}\ ^\circ C.m^{-1}">)                       |
| <img src="https://render.githubusercontent.com/render/math?math=\gamma">                | <img src="https://render.githubusercontent.com/render/math?math=kPa.^\circ C^{-1}"> | Psychrometric constant                                                                                                                          |                                                                                                                          
| <img src="https://render.githubusercontent.com/render/math?math=\gamma^*">              | <img src="https://render.githubusercontent.com/render/math?math=kPa.^\circ C^{-1}"> | Modified psychrometric constant according to Jackson et al. (1981)                                                                              |                                                                              
| <img src="https://render.githubusercontent.com/render/math?math=\delta_s">              |                                          °                                          | Solar declination                                                                                                                               |                                                                                                                               
| <img src="https://render.githubusercontent.com/render/math?math=\delta T">              |                                          K                                          | Temperature gradient calculated according to Bastiaanssen et al. (1998)                                                                         |                                                                         
| <img src="https://render.githubusercontent.com/render/math?math=\delta T_{dry}">        |                                          K                                          | Temperature gradient for the dry areas                                                                                                          |                                                                                                          
| <img src="https://render.githubusercontent.com/render/math?math=\Delta">                | <img src="https://render.githubusercontent.com/render/math?math=kPa.^\circ C^{-1}"> | The slope of the saturated water vapour pressure to temperature gradient                                                                        |                                                                        
| <img src="https://render.githubusercontent.com/render/math?math=\varepsilon">           |                                        rel.                                         | Surface emissivity                                                                                                                              |                                                                                                                              
| <img src="https://render.githubusercontent.com/render/math?math=\varepsilon_a">         |                                        rel.                                         | Atmospheric emissivity                                                                                                                          |                                                                                                                          
| <img src="https://render.githubusercontent.com/render/math?math=\varepsilon_s">         |                                        rel.                                         | Soil emissivity                                                                                                                                 |                                                                                                                                 
| <img src="https://render.githubusercontent.com/render/math?math=\varepsilon_v">         |                                        rel.                                         | Vegetation emissivity                                                                                                                           |                                                                                                                           
| <img src="https://render.githubusercontent.com/render/math?math=\kappa">                |                                      unitless                                       | Kármán constant (<img src="https://render.githubusercontent.com/render/math?math=\kappa"> = 0.41)                                               |                                                                                                                   
| <img src="https://render.githubusercontent.com/render/math?math=\lambda">               |     <img src="https://render.githubusercontent.com/render/math?math=J.g^{-1}">      | Latent heat of evaporation                                                                                                                      |                                                                                                                      
| <img src="https://render.githubusercontent.com/render/math?math=\lambda E">             |     <img src="https://render.githubusercontent.com/render/math?math=W.m^{-2}">      | Latent heat flux                                                                                                                                |                                                                                                                                
| <img src="https://render.githubusercontent.com/render/math?math=\lambda E_{max}">       |     <img src="https://render.githubusercontent.com/render/math?math=W.m^{-2}">      | Latent heat flux equal to Rn-G                                                                                                                  |                                                                                                                  
| <img src="https://render.githubusercontent.com/render/math?math=\lambda E_p">           |     <img src="https://render.githubusercontent.com/render/math?math=W.m^{-2}">      | Potential latent heat flux                                                                                                                      |                                                                                                                      
| <img src="https://render.githubusercontent.com/render/math?math=\lambda E_{PT}">        |     <img src="https://render.githubusercontent.com/render/math?math=W.m^{-2}">      | Priestley-Taylor potential latent heat flux                                                                                                     |                                                                                                     
| <img src="https://render.githubusercontent.com/render/math?math=\pi">                   |                                      unitless                                       | Ludolf number                                                                                                                                   |                                                                                                                                   
| <img src="https://render.githubusercontent.com/render/math?math=\rho">                  |     <img src="https://render.githubusercontent.com/render/math?math=kg.m^{-3}">     | Dry air density                                                                                                                                 |                                                                                                                                 
| <img src="https://render.githubusercontent.com/render/math?math=\rho_{s\_b}">           |                                        rel.                                         | Surface spectral reflectance for optical bands                                                                                                  |                                                                                                  
| <img src="https://render.githubusercontent.com/render/math?math=\rho_{t\_b}">           |                                        rel.                                         | TOA spectral reflectance for optical bands                                                                                                      |                                                                                                      
| <img src="https://render.githubusercontent.com/render/math?math=\varsigma">             |                                      unitless                                       | Monin-Obukhov stability parameter                                                                                                               |                                                                                                               
| <img src="https://render.githubusercontent.com/render/math?math=\sigma">                |  <img src="https://render.githubusercontent.com/render/math?math=W.m^{-2}.K^{-4}">  | Stefan-Boltzmann constant (<img src="https://render.githubusercontent.com/render/math?math=\sigma=5.6703\cdot 10^{-8}\ W.m^{-2}.K^{-4}">)       |
| <img src="https://render.githubusercontent.com/render/math?math=\Psi_h {(\varsigma)}">  |                                      unitless                                       | Stability parameter for heat transfer                                                                                                           |                                                                                                           
| <img src="https://render.githubusercontent.com/render/math?math=\Psi_m {(\varsigma)}">  |                                      unitless                                       | Stability parameter for momentum transfer                                                                                                       |                                                                                                       
| <img src="https://render.githubusercontent.com/render/math?math=\Omega">                |                                        rel.                                         | Decoupling coefficient (Omega factor)                                                                                                           |                                                                                                           
| <img src="https://render.githubusercontent.com/render/math?math=\eta">                  |                                          °                                          | Satellite inclination angle to nadir                                                                                                            |                                                                                                            
| <img src="https://render.githubusercontent.com/render/math?math=\theta">                |                                          °                                          | Solar zenith angle                                                                                                                              |                                                                                                                              
| <img src="https://render.githubusercontent.com/render/math?math=\tau_{in\_b}">          |                                        rel.                                         | Atmospheric transmittance for spectral bands for direct radiation                                                                               |                                                                               
| <img src="https://render.githubusercontent.com/render/math?math=\tau_{out\_b}">         |                                        rel.                                         | Atmospheric transmittance for spectral bands for diffuse radiation                                                                              |                                                                              
